/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia;

import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.plugin.DefaultIOParameters;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.PlugModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableAppl;
import com.dassault.cecilia.core.plugin.PlugableModel;
import com.dassault.cecilia.core.plugin.PluginMCompiler;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.pluginmanager.ExtendedPlugable;
import com.dassault.cecilia.core.pluginmanager.PluginManager;
import com.dassault.cecilia.core.pluginmanager.PluginManagerPanel;
import com.dassault.cecilia.core.taskmanager.TaskMng;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.io.ocas51.CoreUtil;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.CeciliaBatchTreeCtrl;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import com.dassault.cecilia.main.cecilia.OpenFolder;
import com.dassault.cecilia.main.cecilia.gui.CPlugPanel;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public class CeciliaPlugable
implements ExtendedPlugable {
    private static Logger _LOG = Logger.getLogger(CeciliaPlugable.class.getPackage().getName());
    CeciliaAppl _appl;
    CeciliaGUI _gui;
    TaskMng _taskManager;
    CPlugPanel _taskPanel;
    PluginManager _pluginManager;
    Map<String, String> _pluginOptions = new HashMap<String, String>();
    PluginManagerPanel _pluginManagerPanel;
    PluginMCompiler _currentPluginCompiler = null;
    CeciliaBatchTreeCtrl _batchCtrl;
    private static Set<String> __maskSavePreferencies = new HashSet<String>(Arrays.asList("", "plugable.option.path"));
    private static Map<String, String> __renameLoadPreferencies = null;

    public CeciliaPlugable(CeciliaAppl appl, CeciliaGUI gui) {
        this._appl = appl;
        this._gui = gui;
        this._taskManager = new TaskMng(this);
        this._pluginManager = new PluginManager(this);
        this._batchCtrl = new CeciliaBatchTreeCtrl(appl);
    }

    public CeciliaAppl getApplication() {
        return this._appl;
    }

    public boolean loadPluginManager(InputStream stream, String pluginPath) {
        try {
            if (this._pluginManager.loadPlugins(stream, pluginPath)) {
                _LOG.finest("PluginManager - Nbr of Jar: " + this._pluginManager.getJars().size());
                _LOG.finest("PluginManager - Nbr of PluginAction: " + this._pluginManager.getPlugins("PluginAction").size());
                return true;
            }
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "Error during load plugin configuration", e);
        }
        return false;
    }

    public boolean attachPluginManager() {
        try {
            this._pluginManagerPanel = new PluginManagerPanel(this._pluginManager, this);
            this._pluginManagerPanel.attachComponents();
            return true;
        }
        catch (IOException e) {
            this._pluginManagerPanel = null;
            _LOG.log(Level.INFO, "Error during attach plugin component", e);
            return false;
        }
    }

    public void resetPluginManager(File pluginFile) {
        this._pluginManager.clear();
        this._pluginManagerPanel = new PluginManagerPanel(this._pluginManager, this);
        if (pluginFile != null) {
            if (pluginFile.exists()) {
                try {
                    FileUtility.copyFile((File)pluginFile, (File)new File(pluginFile.getAbsolutePath() + "~"));
                }
                catch (IOException e) {
                    _LOG.log(Level.WARNING, "La copie de sauvegarde du precedent fichier de plugin n'a pas fonctionne", e);
                }
            }
            this._pluginManager.write();
        }
    }

    public PluginManagerPanel getPluginManagerPanel() {
        return this._pluginManagerPanel;
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("type")) {
            return "Module";
        }
        if (key.equals("licence")) {
            return "Cecilia".toUpperCase();
        }
        if (key.equals("plugin.name")) {
            return "Cecilia";
        }
        if (key.equals("plugin.version")) {
            return "6.2";
        }
        String property = null;
        if (key.equals("plugable.path")) {
            property = "cecilia.home";
        }
        if (property != null) {
            return this.getPropertyPath(property);
        }
        return null;
    }

    protected String getPropertyPath(String property) {
        if (property != null) {
            File file;
            String path = System.getProperty(property);
            if (path == null) {
                _LOG.info("Property '" + property + "' is not defined - Use default path.");
                path = ".";
            }
            if ((file = new File(path)).isDirectory()) {
                return file.getAbsolutePath();
            }
            _LOG.severe("Property '" + property + "' does not define path directory");
        }
        return ".";
    }

    private InfoDatum doGetDatum(final JInternalFrame iframe, final String key) {
        class CThreadGetDatum
        extends CThread {
            InfoDatum _result;

            public CThreadGetDatum() {
                super(jInternalFrame);
                this._result = null;
            }

            @Override
            protected void firstDo() {
                if (iframe != null && iframe instanceof PlugableModel) {
                    this._result = ((PlugableModel)((Object)iframe)).getDatum(key);
                }
            }
        }
        CThreadGetDatum thread = new CThreadGetDatum();
        if (thread.realiseDo()) {
            return thread._result;
        }
        return null;
    }

    @Override
    public InfoDatum getDatum(String key) {
        DBInternalFrame iframe;
        InfoDatum result;
        _LOG.finest("Call CeciliaPlugable::getDatum(" + key + ", ...)");
        if (key.startsWith("<?xml") && (result = this._batchCtrl.getDatum(key)) != null) {
            return result;
        }
        JInternalFrame iframe2 = this._gui.getDesktop().getDesktop().getSelectedFrame();
        if (iframe2 != null && iframe2 instanceof PlugableModel) {
            return this.doGetDatum(iframe2, key);
        }
        OpenFolder currentFolder = this._appl.getOpenFolders().getSelectedFolder();
        if (currentFolder != null && (iframe = currentFolder.getAccess().getMasterFrame()) != null && iframe instanceof PlugableModel) {
            return this.doGetDatum(iframe, key);
        }
        return null;
    }

    private boolean doSetDatumOnFrame(JInternalFrame iframe, InfoDatum idatum, Plugable srcPlugable) {
        if (iframe == null) {
            return false;
        }
        if (!(iframe instanceof DBInternalFrame)) {
            return false;
        }
        long idFrame = ((DBInternalFrame)iframe).getDBFolder().getID();
        if (idatum.getModel().getUID() != idFrame) {
            return false;
        }
        if (!(iframe instanceof PlugableModel)) {
            return false;
        }
        ((PlugableModel)((Object)iframe)).setDatum(idatum, srcPlugable);
        return true;
    }

    @Override
    public void setDatum(InfoDatum idatum, Plugable srcPlugable) {
        DBInternalFrame iframe;
        _LOG.finest("Call CeciliaPlugable::setDatum(" + idatum + ", ...)");
        if (idatum.getKey().startsWith("<?xml") && this._batchCtrl.setDatum(idatum)) {
            return;
        }
        JInternalFrame iframe2 = this._gui.getDesktop().getDesktop().getSelectedFrame();
        if (this.doSetDatumOnFrame(iframe2, idatum, srcPlugable)) {
            return;
        }
        OpenFolder currentFolder = this._appl.getOpenFolders().getSelectedFolder();
        if (currentFolder != null && this.doSetDatumOnFrame(iframe = currentFolder.getAccess().getMasterFrame(), idatum, srcPlugable)) {
            return;
        }
        for (OpenFolder currentFolder2 : this._appl.getOpenFolders().getOpenFolders()) {
            DBInternalFrame iframe3 = currentFolder2.getAccess().getMasterFrame();
            if (!this.doSetDatumOnFrame(iframe3, idatum, srcPlugable)) continue;
            return;
        }
    }

    private IModel doGetModel(final JInternalFrame iframe, final String key) {
        class CThreadGetModel
        extends CThread {
            IModel _result;

            public CThreadGetModel() {
                super(jInternalFrame);
                this._result = null;
            }

            @Override
            protected void firstDo() {
                if (iframe != null && iframe instanceof PlugModel) {
                    this._result = ((PlugModel)((Object)iframe)).getModel(key);
                }
            }
        }
        CThreadGetModel thread = new CThreadGetModel();
        if (thread.realiseDo()) {
            return thread._result;
        }
        return null;
    }

    @Override
    public IModel getModel(String key) {
        DBInternalFrame iframe;
        _LOG.finest("Call CeciliaPlugable::getModel(" + key + ")");
        JInternalFrame iframe2 = this._gui.getDesktop().getDesktop().getSelectedFrame();
        if (iframe2 != null && iframe2 instanceof PlugModel) {
            return this.doGetModel(iframe2, key);
        }
        OpenFolder currentFolder = this._appl.getOpenFolders().getSelectedFolder();
        if (currentFolder != null && (iframe = currentFolder.getAccess().getMasterFrame()) != null && iframe instanceof PlugModel) {
            return this.doGetModel(iframe, key);
        }
        return null;
    }

    public Set<String> getKeyOptions() {
        return this._pluginOptions.keySet();
    }

    @Override
    public String getOption(String key) {
        String res = null;
        if (key.equals("plugable.option.path")) {
            res = this._pluginOptions.get(key + ".tmp");
            if (res == null) {
                String path = System.getProperty("cecilia.export.path");
                if (path == null && (res = this._pluginOptions.get(key)) != null) {
                    path = res.toString();
                }
                if (path != null) {
                    return path;
                }
            }
        } else {
            res = this._pluginOptions.get(key);
        }
        return res == null ? "" : res.toString();
    }

    @Override
    public void setOption(String key, String value) {
        if (key.equals("plugable.option.path")) {
            this._pluginOptions.put(key + ".tmp", value);
        }
        this._pluginOptions.put(key, value);
    }

    @Override
    public boolean addPanel(PlugPanel panel, long uid) {
        _LOG.finest("Call CeciliaPlugable::addPanel(panel, model)");
        if (panel == null) {
            return false;
        }
        CPlugPanel iFrame = new CPlugPanel(panel, this);
        if (uid != -1L) {
            boolean attached = false;
            for (OpenFolder currentFolder : this._appl.getOpenFolders().getOpenFolders()) {
                DBFolder dbFolder = currentFolder.getDBFolder();
                if (dbFolder.getID() != uid) continue;
                currentFolder.addFrame(iFrame);
                iFrame.setDBFolder(dbFolder);
                attached = true;
                break;
            }
            if (!attached) {
                _LOG.info("PlugPanel with unrecognised UID: " + uid + " [title=" + panel.getInfo("ppanel.title") + "]");
            }
        }
        iFrame.showView(this._gui.getDesktop());
        return true;
    }

    public void displayTaskManager() {
        PlugPanel pp;
        if (this._taskPanel == null && (pp = this._taskManager.requestDisplay()) != null) {
            this._taskPanel = new CPlugPanel(pp, this, true);
        }
        if (this._taskPanel != null) {
            if (!this._taskPanel.isVisible()) {
                this._taskPanel.showView(this._gui.getDesktop());
            } else {
                this._taskPanel.toFront();
            }
        }
    }

    @Override
    public boolean addTask(PlugTask task, long uid) {
        _LOG.finest("Call CeciliaPlugable::addTask(task, model)");
        if (task == null) {
            return false;
        }
        this._taskManager.addTask(task, uid);
        this.displayTaskManager();
        return true;
    }

    public TaskMng getTaskManager() {
        return this._taskManager;
    }

    @Override
    public Window getWindow() {
        return this._gui;
    }

    @Override
    public List getPlugins(String typeKey) {
        return this._pluginManager.getPlugins(typeKey);
    }

    public List getPlugins(String typeKey, String subTypeKey) {
        return this._pluginManager.getPlugins(typeKey, subTypeKey);
    }

    @Override
    public PluginModel getPlugin(String pluginKey) {
        return this._pluginManager.getPlugin(pluginKey);
    }

    @Override
    public PluginWithOptions getPreferencies(String key) {
        return this._appl.getPreferencies().getOptions(key);
    }

    @Override
    public void putPreferencies(PluginWithOptions prefs) {
        this._appl.getPreferencies().addOptions(prefs);
    }

    @Override
    public List getToolbars() {
        return new ArrayList<String>(this._gui.getToolbars().getToolbarsKey());
    }

    @Override
    public JToolBar getToolbar(String name) {
        return this._gui.getToolbars().getToolBar(name);
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this._gui.getJMenuBar();
    }

    @Override
    public void refreshMenubarAndToolbars() {
        this._gui.refreshMenubarAndToolbars();
    }

    @Override
    public void pluginChange() {
        this.refreshMenubarAndToolbars();
    }

    @Override
    public PageFormat getPageFormat(String key) {
        return this.getApplication().getPageFormat();
    }

    public void savePreferencies(Appendable outData, String indent) throws IOException {
        outData.append(indent).append("<").append("cec.prefs").append(">\n");
        for (String key : new TreeSet<String>(this.getKeyOptions())) {
            if (key.endsWith(".tmp") || __maskSavePreferencies.contains(key)) continue;
            String value = this.getOption(key);
            outData.append(indent).append("  <").append("preference");
            outData.append(" key='" + key + "'");
            outData.append(" value='" + DefaultIOParameters.toXML(value) + "'");
            outData.append("/>\n");
        }
        outData.append(indent).append("</").append("cec.prefs").append(">\n");
    }

    public void loadPreferencies(Reader inData) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(inData);
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("<preference") == -1) continue;
            String key = CoreUtil.searchString(line, "key=");
            String value = CoreUtil.searchString(line, "value=");
            String obsolete = __renameLoadPreferencies.get(key);
            if (obsolete != null) {
                if (obsolete.isEmpty()) {
                    _LOG.finer("Obsolete preference - remove: " + key);
                    continue;
                }
                _LOG.finer("Obsolete preference - rename: " + key + " => " + obsolete);
                key = obsolete;
            }
            this.setOption(key, DefaultIOParameters.fromXML(value));
        }
    }

    public void clearPreferencies() {
        this._pluginOptions.clear();
    }

    @Override
    public PlugableAppl getAppl() {
        return this._appl;
    }

    static {
        __renameLoadPreferencies = new HashMap<String, String>();
        __renameLoadPreferencies.put("PluginActionSyntax", "");
        __renameLoadPreferencies.put("PluginActionVerify", "");
        __renameLoadPreferencies.put("com.dassault.cecilia.dbobj.mbsa.component.gui.AltaIconAndSizeDlg.com.dassault.cecilia.dbobj.mbsa.component.gui.AltaIconAndSizeDlg.KeyKeepProportion", "com.dassault.cecilia.dbobj.mbsa.component.gui.AltaIconAndSizeDlg#KeyKeepProportion");
        __renameLoadPreferencies.put("com.dassault.cecilia.dbobj.mbsa.component.gui.AltaIconAndSizeDlg.KeyKeepProportion", "com.dassault.cecilia.dbobj.mbsa.component.gui.AltaIconAndSizeDlg#KeyKeepProportion");
        __renameLoadPreferencies.put("PREF_AUTOMATIC_NUMEROTATION_SEPARATOR", "com.dassault.cecilia.dbobj.mbsa.component.pref.AltaContentDisplayPreferencies#AutomaticRenumerotationSeparator");
        __renameLoadPreferencies.put("displayLinks", "com.dassault.cecilia.dbobj.mbsa.component.pref.AltaContentDisplayPreferencies#DisplayLinks");
        __renameLoadPreferencies.put("com.dassault.cecilia.dbobj.mbsa.system.AltaConfig$AlwaysDisplayConfig", "com.dassault.cecilia.dbobj.mbsa.system.AltaConfig#AlwaysDisplayConfig");
        __renameLoadPreferencies.put("com.dassault.cecilia.lib.mbsa.Stepper$InstantaneousAuto", "com.dassault.cecilia.lib.mbsa.Stepper#InstantaneousAuto");
        __renameLoadPreferencies.put("com.dassault.cecilia.lib.mbsa.Stepper$InstantaneousLoop", "com.dassault.cecilia.lib.mbsa.Stepper#InstantaneousLoop");
        __renameLoadPreferencies.put("", "");
    }
}

