/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.actions;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNode;
import com.dassault.cecilia.core.cecilia.folder.DBFolderVirtualTreeModel;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResIcoArbor;
import com.dassault.cecilia.dbobj.faulttree.egli.EGLICmdExtract;
import com.dassault.cecilia.dbobj.faulttree.egli.EGLICmdGenerate;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import com.dassault.cecilia.main.cecilia.actions.DeclareActions;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

public class EglActions {
    CeciliaAppl _appl;
    CeciliaGUI _gui;

    public EglActions(CeciliaAppl appl, CeciliaGUI gui) {
        this._appl = appl;
        this._gui = gui;
    }

    public void make(DeclareActions actions) {
        actions.putAction("EGL_GENERATE", new CeciliaAction(ResMsgVoc.getString("VOC_GENERATE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolderTreeActivable projectTree = EglActions.this._gui.getFolders().getTree(DBFolder.Family.PROJECT);
                ArrayList selFolders = EglActions.this.recupEGLFolderSelected(projectTree);
                if (selFolders == null) {
                    return;
                }
                EGLICmdGenerate cmd = new EGLICmdGenerate(EglActions.this._appl, projectTree, selFolders, EglActions.this._appl.getDBUser());
                cmd.realiseDo();
            }
        });
        actions.putAction("EGL_REGENERATE", new CeciliaAction(ResMsgVoc.getString("VOC_REGENERATE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolderTreeActivable projectTree = EglActions.this._gui.getFolders().getTree(DBFolder.Family.PROJECT);
                if (projectTree == null) {
                    return;
                }
                if (JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(EglActions.this._gui), ResMsgObj.getString("EGL_GENERATE_QUESTION"), EglActions.this._appl.getTitle(), 2) == 0) {
                    EGLICmdGenerate cmd = new EGLICmdGenerate(EglActions.this._appl, projectTree, new ArrayList<DBFolder>(), EglActions.this._appl.getDBUser());
                    cmd.realiseDo();
                }
            }
        });
        actions.putAction("EGL_EXTRACT", new CeciliaAction(ResIcoArbor.getImageIcon("EVENT_GLOBAL_LIST"), ResMsgVoc.getString("VOC_EXTRACT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBFolderTreeActivable projectTree = EglActions.this._gui.getFolders().getTree(DBFolder.Family.PROJECT);
                ArrayList selFolders = EglActions.this.recupEGLFolderSelected(projectTree);
                EGLICmdExtract cmd = new EGLICmdExtract(EglActions.this._appl, projectTree, selFolders, EglActions.this._appl.getDBUser());
                cmd.realiseDo();
            }
        });
    }

    private ArrayList<DBFolder> recupEGLFolderSelected(DBFolderTreeActivable projectTree) {
        if (projectTree == null) {
            return null;
        }
        TreePath[] selPaths = projectTree.getSelectionPaths();
        if (selPaths == null) {
            return null;
        }
        if (selPaths.length == 0) {
            return null;
        }
        LinkedHashSet<DBFolder> selFolders = new LinkedHashSet<DBFolder>();
        for (int i = 0; i < selPaths.length; ++i) {
            DBFolderTreeNode selectNode = (DBFolderTreeNode)selPaths[i].getLastPathComponent();
            if (selectNode.getSource().isSystem()) continue;
            if (selectNode instanceof DBFolderVirtualTreeModel.DBFolderVirtualTreeNode && ((DBFolderVirtualTreeModel.DBFolderVirtualTreeNode)selectNode).getFamilyFlag() != 0) {
                short ff = ((DBFolderVirtualTreeModel.DBFolderVirtualTreeNode)selectNode).getFamilyFlag();
                DBFolder dbParent = selectNode.getSource();
                for (DBFolder dbChild : dbParent.getChildren()) {
                    if (dbChild.getFamilyFlag() != ff) continue;
                    selFolders.add(dbChild);
                }
                continue;
            }
            selFolders.add(selectNode.getSource());
        }
        if (selFolders.size() == 0) {
            return null;
        }
        return new ArrayList<DBFolder>(selFolders);
    }
}

