/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.gui;

import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.lib.util.collection.IdentityHashSet;
import com.dassault.cecilia.main.cecilia.ResIcoCecilia;
import com.dassault.cecilia.main.cecilia.gui.CInternalFrame;
import com.dassault.cecilia.main.cecilia.gui.DesktopPreferencies;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultDesktopManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JWindow;

public class AltaOriginDesktopPane
extends JDesktopPane
implements Preferencies.PreferenciesListener {
    private static Logger _LOG = Logger.getLogger(AltaOriginDesktopPane.class.getPackage().getName());
    private Image _logo = null;
    private String _imageFileName = "";
    private boolean _isPattern = false;
    private Vector _listFrameIcon = new Vector();
    private int _currentIndex = 0;
    private JPanel _listFramePanel = new JPanel();
    private JTextField _selectedFrameName = new JTextField("            ");
    private JPanel _mainWindowPanel = new JPanel();
    private JWindow _previewWindow;
    ArrayList<ChangeSelectedFrameListener> _listeners = new ArrayList();
    IdentityHashSet<JInternalFrame> _forgetLogFrames = new IdentityHashSet();
    long _prefsCode = -1L;

    public AltaOriginDesktopPane(boolean isPattern) {
        this.setDesktopManager(new DefaultDesktopManager());
        this._isPattern = isPattern;
        this._logo = ResIcoCecilia.getInstance().getImage("BACKGROUND_CREPI", -1, -1);
        this._imageFileName = "BACKGROUND_CREPI";
        this.putClientProperty("JDesktopPane.dragMode", "outline");
    }

    public AltaOriginDesktopPane(Color color) {
        this.setDesktopManager(new DefaultDesktopManager());
        this.setBackground(color);
        this.putClientProperty("JDesktopPane.dragMode", "outline");
    }

    public void makeDesktop(JFrame parent) {
        this._previewWindow = new JWindow(parent);
        this._previewWindow.getContentPane().setLayout(new GridBagLayout());
        this._previewWindow.getContentPane().add((Component)this._mainWindowPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._mainWindowPanel.setLayout(new GridBagLayout());
        this._mainWindowPanel.setBorder(BorderFactory.createEtchedBorder());
        this._mainWindowPanel.add((Component)this._listFramePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._mainWindowPanel.add((Component)this._selectedFrameName, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this._listFramePanel.setLayout(new GridBagLayout());
        this._listFramePanel.setOpaque(false);
        this._selectedFrameName.setOpaque(false);
        this._selectedFrameName.setEditable(false);
        this._previewWindow.setSize(400, 100);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this._previewWindow.setLocation((screenSize.width - 400) / 2, (screenSize.height - 100) / 2);
        KeyListener altSpaceListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && e.isAltDown()) {
                    ((FrameIcon)AltaOriginDesktopPane.this._listFrameIcon.elementAt(AltaOriginDesktopPane.this._currentIndex)).setSelected(false);
                    AltaOriginDesktopPane.this._currentIndex++;
                    if (AltaOriginDesktopPane.this._currentIndex >= AltaOriginDesktopPane.this._listFrameIcon.size()) {
                        AltaOriginDesktopPane.this._currentIndex = 0;
                    }
                    ((FrameIcon)AltaOriginDesktopPane.this._listFrameIcon.elementAt(AltaOriginDesktopPane.this._currentIndex)).setSelected(true);
                    AltaOriginDesktopPane.this._selectedFrameName.setText(((FrameIcon)AltaOriginDesktopPane.this._listFrameIcon.elementAt(AltaOriginDesktopPane.this._currentIndex)).getFrame().getTitle());
                    AltaOriginDesktopPane.this._listFramePanel.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!e.isAltDown()) {
                    AltaOriginDesktopPane.this.popLastSelectedFrame();
                    AltaOriginDesktopPane.this.showPreviewWindow(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        this._selectedFrameName.addKeyListener(altSpaceListener);
        this._selectedFrameName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (AltaOriginDesktopPane.this.previewWindowIsVisible()) {
                    AltaOriginDesktopPane.this._selectedFrameName.requestFocus();
                }
            }
        });
    }

    public void scrollView() {
        this._selectedFrameName.requestFocus();
    }

    public void popLastSelectedFrame() {
        try {
            JInternalFrame frame = ((FrameIcon)this._listFrameIcon.elementAt(this._currentIndex)).getFrame();
            if (frame.isIcon()) {
                try {
                    frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            frame.toFront();
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean previewWindowIsVisible() {
        return this._previewWindow.isVisible();
    }

    public void showPreviewWindow(boolean visible) {
        boolean first = true;
        if (visible) {
            visible = false;
            this._listFramePanel.removeAll();
            this._currentIndex = 0;
            if (this._listFrameIcon.size() != 0) {
                this._listFrameIcon.removeAllElements();
            }
            JInternalFrame[] frames = this.getAllFrames();
            int x = 0;
            int y = 0;
            if (frames.length != 0) {
                for (int i = 0; i < frames.length; ++i) {
                    JInternalFrame frame = frames[i];
                    if (!frame.isVisible() && !frame.isIcon()) continue;
                    FrameIcon frameIcon = new FrameIcon(frame);
                    this._listFramePanel.add((Component)frameIcon, new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
                    if (x >= 8) {
                        x = 0;
                        ++y;
                    }
                    this._listFrameIcon.addElement(frameIcon);
                    if (first) {
                        frameIcon.setSelected(true);
                        this._selectedFrameName.setText(frame.getTitle());
                        first = false;
                    }
                    visible = true;
                }
            }
            this._previewWindow.pack();
            this._previewWindow.setSize(400, this._previewWindow.getSize().height);
        }
        this._previewWindow.setVisible(visible);
        if (visible) {
            this._selectedFrameName.requestFocus();
        }
    }

    public void setImage(String imageFileName, boolean isPattern) {
        this._isPattern = isPattern;
        if (imageFileName.startsWith("BACKGROUND_")) {
            ImageIcon icon = ResIcoCecilia.getImageIcon(imageFileName);
            if (icon != null) {
                this._logo = icon.getImage();
                this._imageFileName = imageFileName;
            } else {
                this.removeImage();
            }
        } else {
            this.removeImage();
        }
    }

    public void setImage(File imageFile, boolean isPattern) {
        this._isPattern = isPattern;
        this._logo = new ImageIcon(Toolkit.getDefaultToolkit().createImage(imageFile.getName())).getImage();
        this._imageFileName = imageFile.getName();
    }

    public boolean isPattern() {
        return this._isPattern;
    }

    public Image getImage() {
        return this._logo;
    }

    public String getImageFileName() {
        return this._imageFileName;
    }

    public void removeImage() {
        this._logo = null;
        this._imageFileName = "";
    }

    public void setColor(Color color) {
        this.setBackground(color);
    }

    public void setColor(int r, int g, int b) {
        this.setBackground(new Color(r, g, b));
    }

    public void closeAllFrame() {
        JInternalFrame[] allFrames = this.getAllFrames();
        if (allFrames != null) {
            for (int i = allFrames.length - 1; i >= 0; --i) {
                allFrames[i].doDefaultCloseAction();
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        int x = 0;
        if (this._logo != null) {
            if (this._isPattern) {
                if (this._logo.getWidth(this) > 0 && this._logo.getHeight(this) > 0) {
                    for (int y = 0; y < this.getSize().height; y += this._logo.getHeight(this)) {
                        for (x = 0; x < this.getSize().width; x += this._logo.getWidth(this)) {
                            g.drawImage(this._logo, x, y, this._logo.getWidth(this), this._logo.getHeight(this), this.getBackground(), this);
                        }
                    }
                } else {
                    this._logo = null;
                    this.paintComponent(g);
                }
            } else {
                g.drawImage(this._logo, 0, 0, this.getSize().width, this.getSize().height, this.getBackground(), this);
            }
        } else {
            this.paintComponent(g);
        }
        this.paintChildren(g);
    }

    public void addChangeSelectedFrameListener(ChangeSelectedFrameListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public void removeChangeSelectedFrameListener(ChangeSelectedFrameListener listener) {
        this._listeners.remove(listener);
    }

    protected void fireChanged(ChangeSelectedFrameEvent event) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).selectChanged(event);
        }
    }

    @Override
    public void setSelectedFrame(JInternalFrame f) {
        JInternalFrame previousFrame = this.getSelectedFrame();
        if (previousFrame == f) {
            return;
        }
        super.setSelectedFrame(f);
        if (f == null) {
            this.fireChanged(new ChangeSelectedFrameEvent(f, null));
        } else {
            DBFolder dbFolder = null;
            if (!(f instanceof CInternalFrame)) {
                if (!this._forgetLogFrames.contains((Object)f)) {
                    _LOG.info("Fenetre interne qui n'etend pas CInternalFrame ? : " + f.getClass().getName() + " - " + f.getTitle());
                    this._forgetLogFrames.add((Object)f);
                }
            } else {
                CInternalFrame cf = (CInternalFrame)f;
                dbFolder = cf.getDBFolder();
                if (dbFolder == null && !this._forgetLogFrames.contains((Object)f)) {
                    _LOG.finer("Fenetre interne qui n'est pas rattachee a un objet metier : " + f.getClass().getName() + " - " + f.getTitle());
                    this._forgetLogFrames.add((Object)f);
                }
            }
            this.fireChanged(new ChangeSelectedFrameEvent(f, dbFolder));
        }
    }

    @Override
    public void changePreferencies(Preferencies prefs) {
        if (this._prefsCode == prefs.getRefresh()) {
            return;
        }
        this._prefsCode = prefs.getRefresh();
        PluginWithOptions opts = prefs.getOptions(DesktopPreferencies.PREF_KEY);
        if (opts != null && opts instanceof DesktopPreferencies) {
            DesktopPreferencies dPref = (DesktopPreferencies)opts;
            this.setColor(dPref.getColorBackground());
            this.setImage(dPref.getKeyPattern(), dPref.isPattern());
            this.repaint();
        }
    }

    public static interface ChangeSelectedFrameListener {
        public void selectChanged(ChangeSelectedFrameEvent var1);
    }

    public static class ChangeSelectedFrameEvent {
        DBFolder _folder;
        JInternalFrame _frame;

        public ChangeSelectedFrameEvent(JInternalFrame frame, DBFolder folder) {
            this._frame = frame;
            this._folder = folder;
        }

        public DBFolder getFolder() {
            return this._folder;
        }

        public JInternalFrame getFrame() {
            return this._frame;
        }
    }

    private class FrameIcon
    extends JComponent {
        private Icon _icon;
        private JInternalFrame _frame;
        private boolean _selected = false;

        public FrameIcon(JInternalFrame frame) {
            this._frame = frame;
            this._icon = frame.getFrameIcon();
        }

        public JInternalFrame getFrame() {
            return this._frame;
        }

        public void setSelected(boolean selected) {
            this._selected = selected;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this._icon.getIconWidth() + 8, this._icon.getIconHeight() + 8);
        }

        @Override
        public void paint(Graphics g) {
            this._icon.paintIcon(this, g, 4, 4);
            if (this._selected) {
                g.setColor(new Color(0, 0, 128));
                g.drawRect(0, 0, this.getPreferredSize().width - 1, this.getPreferredSize().height - 1);
                g.drawRect(1, 1, this.getPreferredSize().width - 3, this.getPreferredSize().height - 3);
            }
        }
    }
}

