/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.cecilia.gui;

import com.dassault.cecilia.core.ResIcoCore;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class CHorizontalScrollBox
extends JPanel {
    JButton _butGoLeft;
    JButton _butGoRight;
    JPanel _ctrlIcones;
    JScrollPane _scrollIcones;
    private boolean _bFirstPreferred = false;

    public CHorizontalScrollBox() {
        super(new GridBagLayout());
        this.make();
    }

    public Container getPanelContainer() {
        return this._ctrlIcones;
    }

    public void addComponent(Component added) {
        this._ctrlIcones.add(added);
        this._ctrlIcones.updateUI();
        this._scrollIcones.validate();
    }

    public void delComponent(Component removed) {
        this._ctrlIcones.remove(removed);
        this._ctrlIcones.updateUI();
        this._scrollIcones.validate();
    }

    private void make() {
        this._ctrlIcones = new JPanel(new FlowLayout(0, 0, 0));
        this._ctrlIcones.setBorder(BorderFactory.createRaisedBevelBorder());
        this._scrollIcones = new JScrollPane(this._ctrlIcones){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                Dimension icone = CHorizontalScrollBox.this._ctrlIcones.getPreferredSize();
                if (size.height < icone.height) {
                    size.height = icone.height;
                }
                return size;
            }
        };
        this._scrollIcones.setHorizontalScrollBarPolicy(31);
        this._scrollIcones.setVerticalScrollBarPolicy(21);
        this._scrollIcones.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int step = 100 * e.getWheelRotation();
                JViewport viewPort = CHorizontalScrollBox.this._scrollIcones.getViewport();
                if (step < 0) {
                    int reste = viewPort.getViewPosition().x;
                    if (reste >= (step *= -1)) {
                        viewPort.setViewPosition(new Point(viewPort.getViewPosition().x - step, viewPort.getViewPosition().y));
                    } else if (reste > 0) {
                        viewPort.setViewPosition(new Point(viewPort.getViewPosition().x - reste, viewPort.getViewPosition().y));
                    }
                } else {
                    int reste = viewPort.getViewSize().width - (viewPort.getViewPosition().x + viewPort.getExtentSize().width);
                    if (reste >= step) {
                        viewPort.setViewPosition(new Point(viewPort.getViewPosition().x + step, viewPort.getViewPosition().y));
                    } else if (reste > 0) {
                        viewPort.setViewPosition(new Point(viewPort.getViewPosition().x + reste, viewPort.getViewPosition().y));
                    }
                }
            }
        });
        this._butGoLeft = new JButton(ResIcoCore.getImageIcon("BUT_LEFT"));
        this._butGoLeft.setFocusPainted(false);
        this._butGoLeft.setMargin(new Insets(5, 0, 5, 0));
        this._butGoRight = new JButton(ResIcoCore.getImageIcon("BUT_RIGHT"));
        this._butGoRight.setFocusPainted(false);
        this._butGoRight.setMargin(new Insets(5, 0, 5, 0));
        this._butGoLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JViewport viewPort = CHorizontalScrollBox.this._scrollIcones.getViewport();
                int reste = viewPort.getViewPosition().x;
                if (reste >= 250) {
                    viewPort.setViewPosition(new Point(viewPort.getViewPosition().x - 250, viewPort.getViewPosition().y));
                } else if (reste > 0) {
                    viewPort.setViewPosition(new Point(viewPort.getViewPosition().x - reste, viewPort.getViewPosition().y));
                }
            }
        });
        this._butGoRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JViewport viewPort = CHorizontalScrollBox.this._scrollIcones.getViewport();
                int reste = viewPort.getViewSize().width - (viewPort.getViewPosition().x + viewPort.getExtentSize().width);
                if (reste >= 250) {
                    viewPort.setViewPosition(new Point(viewPort.getViewPosition().x + 250, viewPort.getViewPosition().y));
                } else if (reste > 0) {
                    viewPort.setViewPosition(new Point(viewPort.getViewPosition().x + reste, viewPort.getViewPosition().y));
                }
            }
        });
        this.add((Component)this._butGoLeft, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._scrollIcones, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._butGoRight, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (!this._bFirstPreferred) {
            this._bFirstPreferred = true;
            int marge = (this._ctrlIcones.getPreferredSize().height - this._butGoLeft.getIcon().getIconHeight()) / 2;
            if (marge > 0) {
                this._butGoLeft.setMargin(new Insets(marge, 0, marge, 0));
                this._butGoRight.setMargin(new Insets(marge, 0, marge, 0));
            }
        }
        return size;
    }
}

