/*
 * Decompiled with CFR 0.152.
 */
package com.xigole.util.sql;

import com.xigole.util.sql.outputformatter.JisqlFormatter;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class Jisql {
    private static final String sybaseJConnect6DriverName = "com.sybase.jdbc3.jdbc.SybDriver";
    private static final String sybaseJConnect5DriverName = "com.sybase.jdbc2.jdbc.SybDriver";
    private static final String sybaseJConnect4DriverName = "com.sybase.jdbc.SybDriver";
    private static final String oracleThinDriverName = "oracle.jdbc.driver.OracleDriver";
    private static final String db2AppDriverName = "COM.ibm.db2.jdbc.app.DB2Driver";
    private static final String db2NetDriverName = "COM.ibm.db2.jdbc.net.DB2Driver";
    private static final String cloudscapeDriverName = "COM.cloudscape.core.JDBCDriver";
    private static final String msqlDriverName = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    private static final String pointbaseDriverName = "com.pointbase.jdbc.jdbcUniversalDriver";
    private static final String postgresqlDriverName = "org.postgresql.Driver";
    private static final String mySQLConnectJDriverName = "com.mysql.jdbc.Driver";
    private static final String mySQLCauchoDriverName = "com.caucho.jdbc.mysql.Driver";
    private static final String defaultFormatterClassName = "com.xigole.util.sql.outputformatter.DefaultFormatter";
    private static final String csvFormatterClassName = "com.xigole.util.sql.outputformatter.CSVFormatter";
    private static final String xmlFormatterClassName = "com.xigole.util.sql.outputformatter.XMLFormatter";
    private String driverName = null;
    private String connectString = null;
    private String userName = null;
    private String password = null;
    private String passwordFileName = null;
    private String formatterClassName = "com.xigole.util.sql.outputformatter.DefaultFormatter";
    private JisqlFormatter formatter = null;
    private Connection connection = null;
    private boolean printDebug = false;
    private boolean printDriverDetails = false;
    private Driver driver = null;
    private Properties props = null;
    private String inputFileName = null;
    private String commandTerminator = "go";
    private String inputQuery = null;

    public static void main(String[] argv) {
        Jisql jisql = new Jisql();
        try {
            jisql.parseArgs(argv);
        }
        catch (Throwable t) {
            t.printStackTrace();
            jisql.usage();
            System.exit(1);
        }
        try {
            jisql.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        try {
            this.driver = (Driver)Class.forName(this.driverName).newInstance();
            this.props = new Properties();
            this.props.put("user", this.userName);
            if (this.password != null) {
                this.props.put("password", this.password);
            }
            this.connection = DriverManager.getConnection(this.connectString, this.props);
            if (this.printDriverDetails) {
                this.printDriverInfo();
            } else {
                this.doIsql();
            }
        }
        catch (SQLException sqle) {
            this.printAllExceptions(sqle);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Cannot find the driver class \"" + this.driverName + "\" in the current classpath.");
        }
        catch (InstantiationException ie) {
            System.err.println("Cannot instantiate the driver class \"" + this.driverName + "\"");
            ie.printStackTrace(System.err);
        }
        catch (IllegalAccessException iae) {
            System.err.println("Cannot instantiate the driver class \"" + this.driverName + "\" because of an IllegalAccessException");
            iae.printStackTrace(System.err);
        }
        finally {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    public void doIsql() throws SQLException {
        BufferedReader reader = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ResultSetMetaData resultSetMetaData = null;
        StringBuffer query = null;
        if (this.inputFileName != null) {
            try {
                reader = new BufferedReader(new FileReader(this.inputFileName));
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("Unable to open \"" + this.inputFileName + "\"");
                fnfe.printStackTrace(System.err);
                return;
            }
        } else {
            reader = new BufferedReader(new InputStreamReader(System.in));
        }
        this.printAllExceptions(this.connection.getWarnings());
        statement = this.connection.createStatement();
        this.connection.clearWarnings();
        while (true) {
            int linecount = 1;
            query = new StringBuffer();
            try {
                if (this.inputFileName == null && this.inputQuery == null) {
                    System.out.print("\nEnter a query:\n");
                }
                while (true) {
                    if (this.inputFileName == null && this.inputQuery == null) {
                        System.out.print(linecount++ + " > ");
                        System.out.flush();
                    }
                    String line = null;
                    line = this.inputQuery == null ? reader.readLine() : this.inputQuery.toString();
                    if (line == null || line.equalsIgnoreCase("quit") || line.equalsIgnoreCase("exit")) {
                        return;
                    }
                    if (line.equals("reset")) {
                        query = new StringBuffer();
                        break;
                    }
                    if (line.trim().equalsIgnoreCase(this.commandTerminator) || line.trim().endsWith(this.commandTerminator)) {
                        if (!line.trim().endsWith(this.commandTerminator)) break;
                        line = line.substring(0, line.length() - this.commandTerminator.length());
                        query.append("\n");
                        query.append(line);
                        break;
                    }
                    query.append("\n");
                    query.append(line);
                }
                if (query.toString().length() == 0) continue;
                if (this.printDebug) {
                    System.out.println("executing: " + query.toString());
                }
                boolean moreResults = statement.execute(query.toString());
                int rowsAffected = 0;
                do {
                    this.printAllExceptions(statement.getWarnings());
                    statement.clearWarnings();
                    if (moreResults) {
                        resultSet = statement.getResultSet();
                        this.printAllExceptions(resultSet.getWarnings());
                        resultSet.clearWarnings();
                        resultSetMetaData = resultSet.getMetaData();
                        this.formatter.formatHeader(System.out, resultSetMetaData);
                        this.formatter.formatData(System.out, resultSet, resultSetMetaData);
                        this.formatter.formatFooter(System.out, resultSetMetaData);
                        int rowsSelected = statement.getUpdateCount();
                        if (rowsSelected >= 0) {
                            System.out.println(rowsSelected + " rows affected.");
                        }
                    } else {
                        rowsAffected = statement.getUpdateCount();
                        this.printAllExceptions(statement.getWarnings());
                        statement.clearWarnings();
                        if (rowsAffected >= 0) {
                            System.out.println(rowsAffected + " rows affected.");
                        }
                    }
                    try {
                        moreResults = statement.getMoreResults();
                    }
                    catch (NullPointerException npe) {
                        moreResults = false;
                    }
                } while (moreResults || rowsAffected != -1);
            }
            catch (SQLException sqle) {
                this.printAllExceptions(sqle);
                statement.cancel();
                statement.clearWarnings();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            if (this.inputQuery != null) break;
        }
    }

    private void printDriverInfo() throws SQLException {
        System.out.println("driver.getMajorVersion() is " + this.driver.getMajorVersion());
        System.out.println("driver.getMinorVersion() is " + this.driver.getMinorVersion());
        System.out.println("driver is " + (this.driver.jdbcCompliant() ? "" : "not ") + "JDBC compliant");
        DriverPropertyInfo[] info = this.driver.getPropertyInfo(this.connectString, this.props);
        for (int i = 0; i < info.length; ++i) {
            System.out.println("driver property named \"" + info[i].name + "\"");
            if (info[i].choices != null) {
                System.out.println("choices:");
                for (int j = 0; j < info[i].choices.length; ++j) {
                    System.out.println("\tchoice " + j + ": \"" + info[i].choices[j] + "\"");
                }
            }
            System.out.println("description: \"" + info[i].description + "\"");
            System.out.println("required parameter?: \"" + info[i].required + "\"");
            System.out.println("current value: \"" + info[i].value + "\"\n");
        }
        DatabaseMetaData metaData = this.connection.getMetaData();
        System.out.println("metaData.getDatabaseProductName(): \"" + metaData.getDatabaseProductName() + "\"");
        System.out.println("metaData.getDatabaseProductVersion(): \"" + metaData.getDatabaseProductVersion() + "\"");
        System.out.println("metaData.getDriverName(): \"" + metaData.getDriverName() + "\"");
        System.out.println("metaData.getDriverVersion(): \"" + metaData.getDriverVersion() + "\"");
    }

    public void parseArgs(String[] argv) throws Throwable {
        for (int argumentIndex = 0; argumentIndex < argv.length; ++argumentIndex) {
            if (!argv[argumentIndex].equals("-formatter")) continue;
            this.formatterClassName = argv[argumentIndex + 1];
            break;
        }
        if (this.formatterClassName.compareToIgnoreCase("csv") == 0) {
            this.formatterClassName = csvFormatterClassName;
        } else if (this.formatterClassName.compareToIgnoreCase("xml") == 0) {
            this.formatterClassName = xmlFormatterClassName;
        } else if (this.formatterClassName.compareToIgnoreCase("default") == 0) {
            this.formatterClassName = defaultFormatterClassName;
        }
        this.formatter = (JisqlFormatter)Class.forName(this.formatterClassName).newInstance();
        OptionParser parser = new OptionParser();
        parser.posixlyCorrect(false);
        parser.accepts("c").withRequiredArg().ofType(String.class);
        parser.accepts("cstring").withRequiredArg().ofType(String.class);
        parser.accepts("debug");
        parser.accepts("driver").withRequiredArg().ofType(String.class);
        parser.accepts("driverinfo");
        parser.accepts("formatter").withRequiredArg().ofType(String.class);
        parser.accepts("help");
        parser.accepts("input").withRequiredArg().ofType(String.class);
        parser.accepts("password").withOptionalArg().ofType(String.class);
        parser.accepts("p").withOptionalArg().ofType(String.class);
        parser.accepts("pf").withRequiredArg().ofType(String.class);
        parser.accepts("query").withRequiredArg().ofType(String.class);
        parser.accepts("user").withRequiredArg().ofType(String.class);
        parser.accepts("u").withRequiredArg().ofType(String.class);
        this.formatter.setSupportedOptions(parser);
        OptionSet options = parser.parse(argv);
        if (options.has("help")) {
            this.usage();
            System.exit(1);
        }
        if (options.has("driver")) {
            this.driverName = (String)options.valueOf("driver");
            if (this.driverName.compareToIgnoreCase("jconnect4") == 0) {
                this.driverName = sybaseJConnect4DriverName;
            } else if (this.driverName.compareToIgnoreCase("jconnect5") == 0) {
                this.driverName = sybaseJConnect5DriverName;
            } else if (this.driverName.compareToIgnoreCase("jconnect6") == 0) {
                this.driverName = sybaseJConnect6DriverName;
            } else if (this.driverName.compareToIgnoreCase("oraclethin") == 0) {
                this.driverName = oracleThinDriverName;
            } else if (this.driverName.compareToIgnoreCase("db2app") == 0) {
                this.driverName = db2AppDriverName;
            } else if (this.driverName.compareToIgnoreCase("db2net") == 0) {
                this.driverName = db2NetDriverName;
            } else if (this.driverName.compareToIgnoreCase("cloudscape") == 0) {
                this.driverName = cloudscapeDriverName;
            } else if (this.driverName.compareToIgnoreCase("mssql") == 0) {
                this.driverName = msqlDriverName;
            } else if (this.driverName.compareToIgnoreCase("pointbase") == 0) {
                this.driverName = pointbaseDriverName;
            } else if (this.driverName.compareToIgnoreCase("postgresql") == 0) {
                this.driverName = postgresqlDriverName;
            } else if (this.driverName.compareToIgnoreCase("mysqlconj") == 0) {
                this.driverName = mySQLConnectJDriverName;
            } else if (this.driverName.compareToIgnoreCase("mysqlcaucho") == 0) {
                this.driverName = mySQLCauchoDriverName;
            }
        }
        this.connectString = (String)options.valueOf("cstring");
        if (options.has("c")) {
            this.commandTerminator = (String)options.valueOf("c");
        }
        if (options.has("debug")) {
            this.printDebug = true;
        }
        if (options.has("user")) {
            this.userName = (String)options.valueOf("user");
        } else if (options.has("u")) {
            this.userName = (String)options.valueOf("u");
        }
        if (options.has("password")) {
            this.password = (String)options.valueOf("password");
        } else if (options.has("p")) {
            this.password = (String)options.valueOf("p");
        }
        if (options.has("driverinfo")) {
            this.printDriverDetails = true;
        }
        if (options.has("input")) {
            this.inputFileName = (String)options.valueOf("input");
        }
        if (options.has("pf")) {
            this.passwordFileName = (String)options.valueOf("pf");
        }
        if (options.has("query")) {
            this.inputQuery = (String)options.valueOf("query");
        }
        if (this.driverName == null) {
            throw new Exception("driver name must exist");
        }
        if (this.connectString == null) {
            throw new Exception("connect string must exist");
        }
        if (this.userName == null) {
            throw new Exception("user name must exist");
        }
        if (this.password == null && this.passwordFileName == null) {
            Console console = System.console();
            this.password = new String(console.readPassword("Password (hit enter for no password): ", new Object[0]));
        } else if (this.password == null) {
            File passwordFile = null;
            BufferedReader reader = null;
            passwordFile = new File(this.passwordFileName);
            if (!passwordFile.exists()) {
                throw new Exception("the password file \"" + this.passwordFileName + "\" does not exist");
            }
            if (!passwordFile.isFile()) {
                throw new Exception("the password file \"" + this.passwordFileName + "\" is not a normal file");
            }
            if (!passwordFile.canRead()) {
                throw new Exception("the password file \"" + this.passwordFileName + "\" is not readable");
            }
            try {
                reader = new BufferedReader(new FileReader(passwordFile));
                this.password = reader.readLine().trim();
            }
            catch (Exception e) {
                throw new Exception("An error occured reading the password file", e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
        this.formatter.consumeOptions(options);
    }

    private void printAllExceptions(SQLException sqle) {
        while (sqle != null) {
            System.err.println("SQLException : SQL state: " + sqle.getSQLState() + " " + sqle.toString() + " ErrorCode: " + sqle.getErrorCode());
            sqle = sqle.getNextException();
        }
    }

    private void usage() {
        System.err.println();
        System.err.println("Jisql v2.0.11.443 (built Sep 07, 2011 at 09:46:07 AM MDT) copyright (c) 2011 Scott Dunbar (scott@xigole.com)");
        System.err.println("usage: java " + this.getClass().getName() + " -driver driver -cstring connect_string -user|-u username -password|-p password [-pf password_file] " + "[-c command_term] [-input file_name] [-debug] [-driverinfo] [-formatter formatter]");
        System.err.println("where:");
        System.err.println("\t-driver specifies the JDBC driver to use.  There are several builtin shortcuts - see the docs for details.");
        System.err.println("\t-cstring specifies the connection string to use.  These are driver specific.");
        System.err.println("\t-user specifies a user name to log into a database server with.");
        System.err.println("\t-password specifies the user name to log into a database server with.");
        System.err.println("\t-pf specifies the name of a file that contains the password to log into a database server with.");
        System.err.println("\t    The first line of file should contain the password and nothing else.");
        System.err.println("\t-c specifies the command terminator.  The default is \"" + this.commandTerminator + "\"");
        System.err.println("\t-input specifies a file name to read commands from.");
        System.err.println("\t-query specifies an optional single query to run instead of interacting with the command line or a file.");
        System.err.println("\t       Note that the command must include a command terminator or the command will hang");
        System.err.println("\t-debug prints to stdout (System.out) debugging information");
        System.err.println("\t-driverinfo prints to stdout (System.out) detailed driver information and then exits");
        System.err.println("\t-formatter specifies either a class name or a pre-configured output formatter.  See the docs for details.");
        if (this.formatter != null) {
            System.err.println("Additional command line arguments of the " + this.formatter.getClass().getName() + " class are");
            this.formatter.usage(System.err);
        }
        System.err.println();
    }
}

