/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.others;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOProperty;
import com.dassault.cecilia.main.admin.others.LicensesPanel;
import com.dassault.cecilia.main.admin.others.LicensesTableModel;
import com.dassault.cecilia.main.admin.others.PropertiesPanel;
import com.dassault.cecilia.main.admin.others.SessionTableModel;
import com.dassault.cecilia.main.admin.others.SessionsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class OtherMainPanel
extends JPanel {
    DAOFactory _daoFactory;
    CAppl _application;
    PropertiesPanel _ctrlProperties;
    LicensesPanel _ctrlLicenses;
    SessionsPanel _ctrlSessions;

    public OtherMainPanel(DAOFactory daoFactory, CAppl application) {
        super(new BorderLayout());
        this._daoFactory = daoFactory;
        this._application = application;
        this.make();
    }

    protected void make() {
        this._ctrlProperties = new PropertiesPanel();
        this._ctrlLicenses = new LicensesPanel(this._application, this._daoFactory.createLicenseDAO(), new LicensesTableModel());
        this._ctrlSessions = new SessionsPanel(this._application, new SessionTableModel());
        JPanel titlePropertiesPanel = new JPanel(new GridBagLayout());
        titlePropertiesPanel.add((Component)this._ctrlProperties, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        titlePropertiesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_INFORMATIONS"))));
        JPanel titleLicensesPanel = new JPanel(new GridBagLayout());
        titleLicensesPanel.add((Component)this._ctrlLicenses, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        titleLicensesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_LICENSE"))));
        JPanel titleSessionsPanel = new JPanel(new GridBagLayout());
        titleSessionsPanel.add((Component)this._ctrlSessions, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        titleSessionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResMsgVoc.getString("VOC_SESSIONS"))));
        JSplitPane split1 = new JSplitPane(1, titlePropertiesPanel, titleSessionsPanel);
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DA) {
            JSplitPane split2 = new JSplitPane(0, split1, titleLicensesPanel);
            split2.setResizeWeight(0.66);
            this.add((Component)split2, "Center");
        } else {
            this.add((Component)split1, "Center");
        }
    }

    public void refresh() {
        DAOProperty daoProperty = this._daoFactory.createPropertyDAO();
        this._ctrlProperties.setProperties(daoProperty.findAll());
        this._ctrlLicenses.refresh();
        this._ctrlSessions.refresh();
    }
}

