/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.main.admin.patchs;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.admin.CApplAdmin;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import com.dassault.cecilia.main.admin.patchs.AbstractCorrectorWithSimpleMsg;
import com.dassault.cecilia.main.admin.patchs.CorrectionObjects;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CorrectorObjects
extends AbstractCorrectorWithSimpleMsg {
    CApplAdmin _appl;
    Set<DBFolder> _rewriteFolders;

    public CorrectorObjects(CApplAdmin appl, Component c) {
        super(c);
        this._appl = appl;
    }

    @Override
    protected String getTitle() {
        return ResMsgAdmin.getString("PATCH_VERIFYOBJECT_TITLE");
    }

    @Override
    protected void firstDo() {
        CECFactory daoFactory = this._appl.getDAOFactory();
        LinkedHashMap<DBFolder, StringBuilder> errorFolders = new LinkedHashMap<DBFolder, StringBuilder>();
        this._rewriteFolders = new LinkedHashSet<DBFolder>();
        this.findUnreadeableObjects_rec(daoFactory.createFolderDAO().getRootID("ROOT"), daoFactory, errorFolders, this._rewriteFolders);
        this.treatError(errorFolders);
    }

    @Override
    protected void patch(List<DBFolder> dbFolders) {
        CorrectionObjects cmd = new CorrectionObjects(this._appl, this.getSource(), dbFolders, this._rewriteFolders);
        cmd.realiseDo();
    }

    private void findUnreadeableObjects_rec(DBFolder dbFolder, CECFactory cecFactory, Map<DBFolder, StringBuilder> errorFolders, Set<DBFolder> rewriteFolders) {
        if (dbFolder.getObject() != null) {
            switch (dbFolder.getFamily()) {
                case BTP_AUTHOR: 
                case BTP_APPLICATION: 
                case BTP_SUBSTANTIATION: {
                    break;
                }
                default: {
                    DBWrap dbWrap = cecFactory.findOrCreateWrap(dbFolder);
                    if (dbWrap == null) {
                        this.appendError(dbFolder, errorFolders, "Unreadeable object");
                        break;
                    }
                    this.verifyRelations(dbWrap, dbFolder, cecFactory, errorFolders, rewriteFolders);
                }
            }
        }
        if (dbFolder.isVersion()) {
            return;
        }
        List<DBFolder> dbChildren = dbFolder.getChildren();
        if (dbChildren == null) {
            dbChildren = cecFactory.createFolderDAO().findChildren(dbFolder);
        }
        if (dbChildren == null) {
            return;
        }
        for (DBFolder dbChild : dbChildren) {
            this.findUnreadeableObjects_rec(dbChild, cecFactory, errorFolders, rewriteFolders);
        }
    }

    private void verifyRelations(DBWrap dbWrap, DBFolder dbFolder, CECFactory cecFactory, Map<DBFolder, StringBuilder> errorFolders, Set<DBFolder> rewriteFolders) {
        DBRelation objRelation;
        Iterator<DBRelation> iterObjRelation;
        StringBuilder missingRelation = new StringBuilder();
        StringBuilder badRelation = new StringBuilder();
        StringBuilder diffRelation = new StringBuilder();
        int rewriteIfPossible = 0;
        Collection<DBRelation> objRelations = dbWrap.getUseRelations();
        Collection<DBRelation> dbRelations = cecFactory.createRelationDAO().getDestinationRelations(dbFolder);
        if (objRelations != null && !objRelations.isEmpty()) {
            iterObjRelation = objRelations.iterator();
            while (iterObjRelation.hasNext()) {
                objRelation = iterObjRelation.next();
                if (!dbRelations.remove(objRelation)) continue;
                iterObjRelation.remove();
            }
        }
        if (objRelations != null && !objRelations.isEmpty()) {
            iterObjRelation = objRelations.iterator();
            block1: while (iterObjRelation.hasNext()) {
                objRelation = iterObjRelation.next();
                Iterator<DBRelation> iterDBRelation = dbRelations.iterator();
                while (iterDBRelation.hasNext()) {
                    DBRelation dbRelation = iterDBRelation.next();
                    if (!objRelation.getDestination().equals(dbRelation.getDestination())) continue;
                    this.appendRelation(diffRelation, objRelation);
                    diffRelation.append(" != [").append(dbRelation.getTypeSource()).append(" => ").append(dbRelation.getTypeDestination()).append("]");
                    iterDBRelation.remove();
                    iterObjRelation.remove();
                    rewriteIfPossible = 2;
                    continue block1;
                }
            }
        }
        if (objRelations != null && !objRelations.isEmpty()) {
            for (DBRelation dbRelation : objRelations) {
                if (rewriteIfPossible != 2) {
                    rewriteIfPossible = dbRelation.getTypeDestination() == "DSF_V" ? 1 : 2;
                }
                this.appendRelation(missingRelation, dbRelation);
            }
        }
        if (!dbRelations.isEmpty()) {
            for (DBRelation dbRelation : dbRelations) {
                if (rewriteIfPossible != 2) {
                    rewriteIfPossible = dbRelation.getTypeDestination() == "DSF_V" ? 1 : 2;
                }
                this.appendRelation(badRelation, dbRelation);
            }
        }
        if (missingRelation.length() > 0) {
            this.appendError(dbFolder, errorFolders, "Missing relations:\n" + missingRelation.toString());
        }
        if (diffRelation.length() > 0) {
            this.appendError(dbFolder, errorFolders, "Diff relations:\n" + diffRelation.toString());
        }
        if (badRelation.length() > 0) {
            this.appendError(dbFolder, errorFolders, "Bad relations:\n" + badRelation.toString());
        }
        if (rewriteIfPossible == 1) {
            rewriteFolders.add(dbFolder);
        }
    }

    private void appendRelation(StringBuilder buffer, DBRelation dbRelation) {
        if (buffer.length() > 0) {
            buffer.append("\n");
        }
        buffer.append("\t").append(dbRelation.getDestination().getRefPath());
        buffer.append(" [").append(dbRelation.getTypeSource()).append(" => ").append(dbRelation.getTypeDestination()).append("]");
    }
}

