/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.id;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.codat.CodatID;
import net.jxta.id.ID;
import net.jxta.id.jxta.IDFormat;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.util.ClassFactory;
import sun.net.www.protocol.urn.Handler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IDFactory
extends ClassFactory<String, Instantiator> {
    private static final transient Logger LOG = Logger.getLogger(IDFactory.class.getName());
    private final Map<String, Instantiator> idFormats = new HashMap<String, Instantiator>();
    private final String idNewInstances;
    private static final IDFactory factory = new IDFactory();

    private IDFactory() {
        this.registerAssoc("net.jxta.id.jxta.IDFormat");
        this.registerAssoc("net.jxta.impl.id.unknown.IDFormat");
        this.registerProviders(ID.class.getName());
        try {
            ResourceBundle jxtaRsrcs = ResourceBundle.getBundle("net.jxta.impl.config");
            this.idNewInstances = jxtaRsrcs.getString("IDNewInstances").trim();
        }
        catch (MissingResourceException notFound) {
            IllegalStateException failure = new IllegalStateException("Could not initialize ID defaults", notFound);
            LOG.log(Level.SEVERE, "Cound not initialize IDFactory", failure);
            throw failure;
        }
    }

    @Override
    protected Map<String, Instantiator> getAssocTable() {
        return this.idFormats;
    }

    @Override
    protected Class<String> getClassForKey() {
        return String.class;
    }

    @Override
    protected Class<Instantiator> getClassOfInstantiators() {
        return Instantiator.class;
    }

    @Override
    public boolean registerAssoc(String className) {
        boolean registeredSomething = false;
        try {
            Field instantiatorField;
            Class<?> idClass;
            try {
                idClass = Class.forName(className);
                if (null == idClass) {
                    throw new ClassNotFoundException("forName() result was null");
                }
            }
            catch (ClassNotFoundException notThere) {
                LOG.severe("Could not find class named : " + className);
                return false;
            }
            catch (NoClassDefFoundError notThere) {
                LOG.severe("Could not find class named : " + className);
                return false;
            }
            try {
                instantiatorField = idClass.getField("INSTANTIATOR");
                if (null == instantiatorField) {
                    throw new NoSuchFieldException("getField() result was null for field 'INSTANTIATOR'");
                }
            }
            catch (NoSuchFieldException notThere) {
                LOG.severe("Could not find INSTANTIATOR field in class named : " + className);
                return false;
            }
            if (!Instantiator.class.isAssignableFrom(instantiatorField.getType())) {
                throw new ClassCastException("INSTANTIATOR is not of type " + Instantiator.class.getName());
            }
            Instantiator instantiator = (Instantiator)instantiatorField.get(null);
            if (null == instantiator) {
                LOG.severe("INSTANTIATOR field is null for class  : " + className);
                return false;
            }
            String idFormat = instantiator.getSupportedIDFormat();
            registeredSomething = this.registerAssoc(idFormat, instantiator);
        }
        catch (Exception failed) {
            LOG.log(Level.SEVERE, "Failed to register class : " + className, failed);
        }
        return registeredSomething;
    }

    public static String getDefaultIDFormat() {
        return IDFactory.factory.idNewInstances;
    }

    public static ID fromURI(URI source) throws URISyntaxException {
        Instantiator instantiator;
        ID result = null;
        if (!"urn".equalsIgnoreCase(source.getScheme())) {
            throw new URISyntaxException(source.toString(), "URI scheme was not as expected.");
        }
        String decoded = source.getSchemeSpecificPart();
        int colonAt = decoded.indexOf(58);
        if (-1 == colonAt) {
            throw new URISyntaxException(source.toString(), "URN namespace was missing.");
        }
        if (!"jxta".equalsIgnoreCase(decoded.substring(0, colonAt))) {
            throw new URISyntaxException(source.toString(), "URN namespace was not as expected. (jxta!=" + decoded.substring(0, colonAt) + ")");
        }
        int dashAt = (decoded = decoded.substring(colonAt + 1)).indexOf(45);
        if (-1 == dashAt) {
            throw new URISyntaxException(source.toString(), "URN jxta namespace IDFormat was missing.");
        }
        String format = decoded.substring(0, dashAt);
        try {
            instantiator = (Instantiator)factory.getInstantiator(format);
        }
        catch (NoSuchElementException itsUnknown) {
            instantiator = (Instantiator)factory.getInstantiator("unknown");
        }
        result = instantiator.fromURNNamespaceSpecificPart(decoded);
        return result.intern();
    }

    @Deprecated
    public static ID fromURL(URL source) throws MalformedURLException, UnknownServiceException {
        Instantiator instantiator;
        ID result = null;
        if (!"urn".equalsIgnoreCase(source.getProtocol())) {
            throw new UnknownServiceException("URI protocol type was not as expected.");
        }
        String encoded = source.getFile();
        String decoded = Handler.decodeURN(encoded);
        int colonAt = decoded.indexOf(58);
        if (-1 == colonAt) {
            throw new MalformedURLException("URN namespace was missing.");
        }
        if (!"jxta".equalsIgnoreCase(decoded.substring(0, colonAt))) {
            throw new MalformedURLException("URN namespace was not as expected. (jxta!=" + decoded.substring(0, colonAt) + ")");
        }
        int dashAt = (decoded = decoded.substring(colonAt + 1)).indexOf(45);
        if (-1 == dashAt) {
            throw new UnknownServiceException("URN Encodingtype was missing.");
        }
        decoded = decoded.substring(0, dashAt);
        try {
            instantiator = (Instantiator)factory.getInstantiator(decoded);
        }
        catch (NoSuchElementException itsUnknown) {
            instantiator = (Instantiator)factory.getInstantiator("unknown");
        }
        result = instantiator.fromURL(source);
        return result.intern();
    }

    public static CodatID newCodatID(PeerGroupID groupID) {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newCodatID(groupID).intern();
    }

    public static CodatID newCodatID(PeerGroupID groupID, byte[] seed) {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newCodatID(groupID, seed).intern();
    }

    public static CodatID newCodatID(PeerGroupID groupID, InputStream in) throws IOException {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newCodatID(groupID, in).intern();
    }

    public static CodatID newCodatID(PeerGroupID groupID, byte[] seed, InputStream in) throws IOException {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newCodatID(groupID, seed, in).intern();
    }

    public static PeerID newPeerID(PeerGroupID groupID) {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newPeerID(groupID).intern();
    }

    public static PeerID newPeerID(PeerGroupID groupID, byte[] seed) {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newPeerID(groupID, seed).intern();
    }

    public static PeerGroupID newPeerGroupID() {
        return IDFactory.newPeerGroupID(IDFactory.factory.idNewInstances).intern();
    }

    public static PeerGroupID newPeerGroupID(String idformat) {
        Instantiator instantiator = (Instantiator)factory.getInstantiator(idformat);
        return instantiator.newPeerGroupID().intern();
    }

    public static PeerGroupID newPeerGroupID(byte[] seed) {
        return IDFactory.newPeerGroupID(IDFactory.factory.idNewInstances, seed).intern();
    }

    public static PeerGroupID newPeerGroupID(String idformat, byte[] seed) {
        Instantiator instantiator = (Instantiator)factory.getInstantiator(idformat);
        return instantiator.newPeerGroupID(seed).intern();
    }

    public static PeerGroupID newPeerGroupID(PeerGroupID parent) {
        String useFormat = parent.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newPeerGroupID(parent).intern();
    }

    public static PeerGroupID newPeerGroupID(PeerGroupID parent, byte[] seed) {
        String useFormat = parent.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newPeerGroupID(parent, seed).intern();
    }

    public static PipeID newPipeID(PeerGroupID groupID) {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newPipeID(groupID).intern();
    }

    public static PipeID newPipeID(PeerGroupID groupID, byte[] seed) {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newPipeID(groupID, seed).intern();
    }

    public static ModuleClassID newModuleClassID() {
        return IDFactory.newModuleClassID(IDFactory.factory.idNewInstances).intern();
    }

    public static ModuleClassID newModuleClassID(String idformat) {
        Instantiator instantiator = (Instantiator)factory.getInstantiator(idformat);
        return instantiator.newModuleClassID().intern();
    }

    public static ModuleClassID newModuleClassID(ModuleClassID baseClass) {
        String useFormat = baseClass.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newModuleClassID(baseClass).intern();
    }

    public static ModuleSpecID newModuleSpecID(ModuleClassID baseClass) {
        String useFormat = baseClass.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newModuleSpecID(baseClass).intern();
    }

    @Deprecated
    public static URL jxtaURL(String protocol, String host, String file) throws MalformedURLException {
        return new URL(protocol, host, -1, file, Handler.handler);
    }

    @Deprecated
    public static URL jxtaURL(String uri) throws MalformedURLException {
        String file = "jxta:";
        URL urlCnxt = IDFactory.jxtaURL("urn", "", "jxta:");
        return new URL(urlCnxt, uri);
    }

    @Deprecated
    public static interface URIInstantiator
    extends Instantiator {
    }

    public static interface Instantiator {
        public String getSupportedIDFormat();

        @Deprecated
        public ID fromURL(URL var1) throws MalformedURLException, UnknownServiceException;

        public ID fromURI(URI var1) throws URISyntaxException;

        public ID fromURNNamespaceSpecificPart(String var1) throws URISyntaxException;

        public CodatID newCodatID(PeerGroupID var1);

        public CodatID newCodatID(PeerGroupID var1, byte[] var2);

        public CodatID newCodatID(PeerGroupID var1, InputStream var2) throws IOException;

        public CodatID newCodatID(PeerGroupID var1, byte[] var2, InputStream var3) throws IOException;

        public PeerID newPeerID(PeerGroupID var1);

        public PeerID newPeerID(PeerGroupID var1, byte[] var2);

        public PeerGroupID newPeerGroupID();

        public PeerGroupID newPeerGroupID(byte[] var1);

        public PeerGroupID newPeerGroupID(PeerGroupID var1);

        public PeerGroupID newPeerGroupID(PeerGroupID var1, byte[] var2);

        public PipeID newPipeID(PeerGroupID var1);

        public PipeID newPipeID(PeerGroupID var1, byte[] var2);

        public ModuleClassID newModuleClassID();

        public ModuleClassID newModuleClassID(ModuleClassID var1);

        public ModuleSpecID newModuleSpecID(ModuleClassID var1);
    }
}

