/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.impl.document.LiteXMLElement;
import net.jxta.impl.document.TextDocumentCommon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteXMLDocument
extends LiteXMLElement
implements XMLDocument<LiteXMLElement> {
    public static final StructuredDocumentFactory.TextInstantiator INSTANTIATOR = new Instantiator();
    final StringBuilder docContent;
    private final MimeMediaType mimeType;

    LiteXMLDocument(MimeMediaType mimeType, String type) {
        this(mimeType, type, "");
    }

    LiteXMLDocument(MimeMediaType mimeType, String type, String textValue) {
        super(null, null);
        this.parent = this;
        this.mimeType = mimeType;
        this.docContent = new StringBuilder();
        for (int eachChar = type.length() - 1; eachChar >= 0; --eachChar) {
            if (!Character.isWhitespace(type.charAt(eachChar))) continue;
            throw new IllegalArgumentException("Root tag may not contain spaces");
        }
        if (null == textValue) {
            textValue = "";
        }
        StringBuilder seedDoc = new StringBuilder(textValue.length() + 3 * type.length() + 128);
        seedDoc.append("<?xml version=\"1.0\"");
        String charset = mimeType.getParameter("charset");
        if (charset != null) {
            seedDoc.append(" encoding=\"");
            seedDoc.append(charset);
            seedDoc.append("\"");
        }
        seedDoc.append("?>\n");
        seedDoc.append("<!DOCTYPE ");
        seedDoc.append(type);
        seedDoc.append(">\n");
        seedDoc.append('<');
        seedDoc.append(type);
        seedDoc.append('>');
        seedDoc.append(textValue);
        seedDoc.append("</");
        seedDoc.append(type);
        seedDoc.append('>');
        try {
            this.init(new StringReader(seedDoc.toString()));
        }
        catch (IOException caught) {
            throw new UndeclaredThrowableException(caught);
        }
    }

    LiteXMLDocument(MimeMediaType mimeType, InputStream in) throws IOException {
        super(null, null);
        this.parent = this;
        this.mimeType = mimeType;
        this.docContent = new StringBuilder();
        String charset = mimeType.getParameter("charset");
        if (charset == null) {
            this.init(new InputStreamReader(in));
        } else {
            this.init(new InputStreamReader(in, charset));
        }
    }

    LiteXMLDocument(MimeMediaType mimeType, Reader in) throws IOException {
        super(null, null);
        this.parent = this;
        this.mimeType = mimeType;
        this.docContent = new StringBuilder();
        this.init(in);
    }

    @Override
    public String toString() {
        try {
            StringWriter stringOut = new StringWriter();
            this.sendToWriter(stringOut);
            stringOut.close();
            return stringOut.toString();
        }
        catch (IOException caught) {
            throw new UndeclaredThrowableException(caught);
        }
    }

    @Override
    public MimeMediaType getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getFileExtension() {
        return TextDocumentCommon.Utils.getExtensionForMime(INSTANTIATOR.getSupportedFileExtensions(), this.getMimeType());
    }

    @Override
    public LiteXMLElement createElement(Object key) {
        return this.createElement(key, null);
    }

    @Override
    public LiteXMLElement createElement(Object key, Object val) {
        if (!(key instanceof String)) {
            throw new ClassCastException(key.getClass().getName() + " not supported by createElement as key.");
        }
        if (null != val && !(val instanceof String)) {
            throw new ClassCastException(val.getClass().getName() + " not supported by createElement as value.");
        }
        return this.createElement((String)key, (String)val);
    }

    @Override
    public LiteXMLElement createElement(String name) {
        return this.createElement(name, null);
    }

    @Override
    public LiteXMLElement createElement(String name, String val) {
        return new LiteXMLElement(this, name, val);
    }

    protected LiteXMLElement createElement(LiteXMLElement.tagRange loc) {
        return new LiteXMLElement(this, loc);
    }

    @Override
    public Reader getReader() {
        return new StringReader(this.toString());
    }

    @Override
    public LiteXMLDocument getRoot() {
        return this;
    }

    @Override
    public InputStream getStream() throws IOException {
        String charset = this.mimeType.getParameter("charset");
        if (charset == null) {
            return new ByteArrayInputStream(this.toString().getBytes());
        }
        return new ByteArrayInputStream(this.toString().getBytes(charset));
    }

    @Override
    public void sendToWriter(Writer writer) throws IOException {
        String charset = this.mimeType.getParameter("charset");
        if (charset == null) {
            writer.write("<?xml version=\"1.0\"?>\n");
        } else {
            writer.write("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>\n");
        }
        LiteXMLElement.tagRange result = this.getDocType(this.docContent, true);
        if (result.isValid()) {
            writer.write(this.docContent.substring(result.startTag.start, result.startTag.end + 1));
            writer.write(10);
        }
        this.printNice(writer, 0, true);
    }

    @Override
    public void sendToStream(OutputStream stream) throws IOException {
        String charset = this.mimeType.getParameter("charset");
        OutputStreamWriter osw = charset == null ? new OutputStreamWriter(stream) : new OutputStreamWriter(stream, charset);
        BufferedWriter out = new BufferedWriter(osw);
        this.sendToWriter(out);
        ((Writer)out).flush();
    }

    protected void init(Reader in) throws IOException {
        int readCount;
        this.loc = new LiteXMLElement.tagRange();
        char[] smallBuffer = new char[512];
        while ((readCount = in.read(smallBuffer)) >= 0) {
            if (readCount <= 0) continue;
            this.docContent.append(smallBuffer, 0, readCount);
        }
        this.loc.startTag.start = 0;
        this.loc.startTag.end = this.docContent.indexOf(">");
        this.loc.body.start = this.loc.startTag.end + 1;
        this.loc.endTag.start = this.loc.body.end = this.docContent.length() - 1;
        this.loc.endTag.end = this.loc.body.end;
        LiteXMLElement.tagRange docType = this.getDocType(this.getDocument().docContent, false);
        this.loc = docType.isValid() ? this.getTagRanges(this.getDocument().docContent, this.docContent.substring(docType.body.start, docType.body.end + 1), docType.endTag) : this.getTagRanges(this.getDocument().docContent, null, this.loc.body);
        if (!this.loc.isValid()) {
            throw new RuntimeException("Parsing error in source document.");
        }
        if (!this.loc.startTag.equals(this.loc.endTag)) {
            this.addChildTags(this.loc.body, this);
        }
    }

    protected LiteXMLElement.tagRange getDocType(StringBuilder source, boolean wholeElement) {
        String xmldoctype = "!DOCTYPE";
        int start = 0;
        int end = this.getDocument().docContent.length() - 1;
        LiteXMLElement.tagRange ranges = this.getTagRanges(source, "!DOCTYPE", new LiteXMLElement.charRange(start, end));
        if (!ranges.startTag.isValid()) {
            return ranges;
        }
        ranges.endTag.start = ranges.body.start;
        ranges.endTag.end = ranges.body.end;
        if (wholeElement) {
            ranges.body.start = ranges.startTag.end + 1;
            ranges.body.end = ranges.endTag.start - 1;
        } else {
            char possibleEnd;
            ranges.body.start = ranges.startTag.start + 1 + "!DOCTYPE".length() - 1 + 1;
            ranges.startTag.end = ranges.body.start - 1;
            while (ranges.body.start < end && Character.isWhitespace(source.charAt(ranges.body.start))) {
                ++ranges.body.start;
            }
            ranges.body.end = ranges.body.start;
            while (ranges.body.end + 1 < end && !Character.isWhitespace(possibleEnd = source.charAt(ranges.body.end + 1)) && '/' != possibleEnd && '>' != possibleEnd) {
                ++ranges.body.end;
            }
        }
        return ranges;
    }

    @Override
    LiteXMLDocument getDocument() {
        return this;
    }

    private static final class Instantiator
    implements StructuredDocumentFactory.TextInstantiator {
        private static final MimeMediaType[] myTypes = new MimeMediaType[]{MimeMediaType.XML_DEFAULTENCODING, MimeMediaType.valueOf("Text/x-Xml"), MimeMediaType.valueOf("Application/Xml"), MimeMediaType.valueOf("Application/x-Xml")};
        private static final StructuredDocumentFactory.Instantiator.ExtensionMapping[] myExtensions = new StructuredDocumentFactory.Instantiator.ExtensionMapping[]{new StructuredDocumentFactory.Instantiator.ExtensionMapping("xml", myTypes[0]), new StructuredDocumentFactory.Instantiator.ExtensionMapping("xml", null)};

        public MimeMediaType[] getSupportedMimeTypes() {
            return myTypes;
        }

        public StructuredDocumentFactory.Instantiator.ExtensionMapping[] getSupportedFileExtensions() {
            return myExtensions;
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, String doctype) {
            return new LiteXMLDocument(mimeType, doctype);
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, String doctype, String value) {
            return new LiteXMLDocument(mimeType, doctype, value);
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, InputStream source) throws IOException {
            return new LiteXMLDocument(mimeType, source);
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, Reader source) throws IOException {
            return new LiteXMLDocument(mimeType, source);
        }
    }
}

