/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.impl.endpoint.tcp.TcpMessenger;
import net.jxta.impl.endpoint.tcp.TcpTransport;
import net.jxta.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomingUnicastServer
implements Runnable {
    private static final Logger LOG = Logger.getLogger(IncomingUnicastServer.class.getName());
    private final TcpTransport transport;
    private final InetAddress serverBindLocalInterface;
    private final int serverBindStartLocalPort;
    private int serverBindPreferedLocalPort;
    private final int serverBindEndLocalPort;
    private ServerSocket serverSocket;
    private volatile boolean closed = false;
    private Thread acceptThread = null;
    private Selector acceptSelector = null;
    private ServerSocketChannel serverSocChannel = null;

    public IncomingUnicastServer(TcpTransport owner, InetAddress serverInterface, int preferedPort, int startPort, int endPort) throws IOException, SecurityException {
        this.transport = owner;
        this.serverBindLocalInterface = serverInterface;
        this.serverBindPreferedLocalPort = preferedPort;
        this.serverBindStartLocalPort = startPort;
        this.serverBindEndLocalPort = endPort;
        this.openServerSocket();
    }

    public synchronized boolean start() {
        if (this.acceptThread != null) {
            return false;
        }
        this.acceptThread = new Thread(this.transport.group.getHomeThreadGroup(), this, "TCP Transport ServerSocket accept for " + this.transport.getPublicAddress());
        this.acceptThread.setDaemon(true);
        this.acceptThread.start();
        return true;
    }

    public synchronized void stop() {
        block6: {
            block5: {
                this.closed = true;
                Thread temp = this.acceptThread;
                if (null != temp) {
                    temp.interrupt();
                }
                try {
                    this.serverSocket.close();
                }
                catch (IOException ignored) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block5;
                    LOG.log(Level.SEVERE, "IO error occured while closing server socket", ignored);
                }
            }
            try {
                this.acceptSelector.close();
            }
            catch (IOException io) {
                if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block6;
                LOG.log(Level.SEVERE, "IO error occured while closing Selectors", io);
            }
        }
    }

    synchronized InetSocketAddress getLocalSocketAddress() {
        ServerSocket localSocket = this.serverSocket;
        if (null != localSocket) {
            return (InetSocketAddress)localSocket.getLocalSocketAddress();
        }
        return null;
    }

    int getStartPort() {
        return this.serverBindStartLocalPort;
    }

    int getEndPort() {
        return this.serverBindEndLocalPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block40: {
            IncomingUnicastServer incomingUnicastServer;
            try {
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Server is ready to accept connections");
                }
                while (!this.closed) {
                    try {
                        if (null == this.serverSocChannel || !this.serverSocChannel.isOpen()) {
                            this.openServerSocket();
                            if (null == this.serverSocChannel) {
                                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break;
                                LOG.warning("Failed to open Server Channel");
                                break;
                            }
                        }
                        this.acceptSelector.select();
                        Iterator<SelectionKey> it = this.acceptSelector.selectedKeys().iterator();
                        while (it.hasNext()) {
                            ServerSocketChannel nextReady;
                            SocketChannel inputSocket;
                            SelectionKey key = it.next();
                            it.remove();
                            if (!key.isAcceptable() || (inputSocket = (nextReady = (ServerSocketChannel)key.channel()).accept()) == null || inputSocket.socket() == null) continue;
                            MessengerBuilder builder = new MessengerBuilder(inputSocket, this.transport);
                            try {
                                this.transport.executor.execute(builder);
                                this.transport.incrementConnectionsAccepted();
                            }
                            catch (RejectedExecutionException re) {
                                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                                LOG.log(Level.FINE, MessageFormat.format("Executor rejected task : {0}", builder.toString()), re);
                            }
                        }
                    }
                    catch (ClosedSelectorException cse) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Accept Selector closed");
                        }
                        if (!this.closed) continue;
                        break;
                    }
                    catch (InterruptedIOException woken) {
                        if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("Accept Thread woken");
                    }
                    catch (IOException e1) {
                        if (this.closed) break;
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                        LOG.log(Level.WARNING, "[1] ServerSocket.accept() failed on " + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort(), e1);
                    }
                    catch (SecurityException e2) {
                        if (this.closed) break;
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                        LOG.log(Level.WARNING, "[2] ServerSocket.accept() failed on " + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort(), e2);
                    }
                }
                Object var8_12 = null;
                incomingUnicastServer = this;
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                IncomingUnicastServer incomingUnicastServer2 = this;
                synchronized (incomingUnicastServer2) {
                    block39: {
                        this.closed = true;
                        ServerSocket temp = this.serverSocket;
                        this.serverSocket = null;
                        if (null != temp) {
                            try {
                                temp.close();
                            }
                            catch (IOException ignored) {
                                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block39;
                                LOG.log(Level.FINE, "Exception occurred while closing server socket", ignored);
                            }
                        }
                    }
                    this.acceptThread = null;
                }
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Server has been shut down.");
                }
                throw throwable;
            }
            synchronized (incomingUnicastServer) {
                block35: {
                    this.closed = true;
                    ServerSocket temp = this.serverSocket;
                    this.serverSocket = null;
                    if (null != temp) {
                        try {
                            temp.close();
                        }
                        catch (IOException ignored) {
                            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block35;
                            LOG.log(Level.FINE, "Exception occurred while closing server socket", ignored);
                        }
                    }
                }
                this.acceptThread = null;
            }
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Server has been shut down.");
            }
            break block40;
            {
                catch (Throwable all) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
                    }
                    Object var8_13 = null;
                    IncomingUnicastServer incomingUnicastServer3 = this;
                    synchronized (incomingUnicastServer3) {
                        block37: {
                            this.closed = true;
                            ServerSocket temp = this.serverSocket;
                            this.serverSocket = null;
                            if (null != temp) {
                                try {
                                    temp.close();
                                }
                                catch (IOException ignored) {
                                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block37;
                                    LOG.log(Level.FINE, "Exception occurred while closing server socket", ignored);
                                }
                            }
                        }
                        this.acceptThread = null;
                    }
                    if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                        LOG.info("Server has been shut down.");
                    }
                }
            }
        }
    }

    public List<Integer> rangeCheckShuffle(int start, int end) {
        if (start < 1 || start > 65535) {
            throw new IllegalArgumentException("Invalid start port");
        }
        if (end < 1 || end > 65535 || end < start) {
            throw new IllegalArgumentException("Invalid end port");
        }
        ArrayList<Integer> inRange = new ArrayList<Integer>();
        for (int eachInRange = start; eachInRange < end; ++eachInRange) {
            inRange.add(eachInRange);
        }
        Collections.shuffle(inRange);
        return inRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void openServerSocket() throws IOException, SecurityException {
        this.serverSocket = null;
        while (true) {
            try {
                block17: {
                    IncomingUnicastServer incomingUnicastServer = this;
                    synchronized (incomingUnicastServer) {
                        this.acceptSelector = SelectorProvider.provider().openSelector();
                        this.serverSocChannel = ServerSocketChannel.open();
                        if (-1 != this.serverBindPreferedLocalPort) {
                            InetSocketAddress bindAddress = new InetSocketAddress(this.serverBindLocalInterface, this.serverBindPreferedLocalPort);
                            this.serverSocket = this.serverSocChannel.socket();
                            int useBufferSize = Math.max(65536, this.serverSocket.getReceiveBufferSize());
                            this.serverSocket.setReceiveBufferSize(useBufferSize);
                            this.serverSocket.bind(bindAddress, 50);
                        } else {
                            List<Integer> rangeList = this.rangeCheckShuffle(this.serverBindStartLocalPort, this.serverBindEndLocalPort);
                            while (!rangeList.isEmpty()) {
                                int tryPort = rangeList.remove(0);
                                if (tryPort > this.serverBindEndLocalPort) continue;
                                try {
                                    InetSocketAddress bindAddress = new InetSocketAddress(this.serverBindLocalInterface, tryPort);
                                    this.serverSocket = this.serverSocChannel.socket();
                                    int useBufferSize = Math.max(65536, this.serverSocket.getReceiveBufferSize());
                                    this.serverSocket.setReceiveBufferSize(useBufferSize);
                                    this.serverSocket.bind(bindAddress, 50);
                                    if (!Logging.SHOW_INFO || !LOG.isLoggable(Level.INFO)) continue;
                                    LOG.info("ServerSocketChannel bound to " + bindAddress + ":" + tryPort);
                                }
                                catch (SocketException failed) {
                                }
                                catch (Error err) {}
                            }
                        }
                    }
                    try {
                        this.serverSocChannel.configureBlocking(false);
                        this.serverSocChannel.register(this.acceptSelector, 16);
                    }
                    catch (ClosedChannelException cce) {
                        if (!Logging.SHOW_FINER || !LOG.isLoggable(Level.FINER)) break block17;
                        LOG.log(Level.FINER, "Channel closed.", cce);
                    }
                }
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Server will accept connections at " + this.serverSocket.getLocalSocketAddress());
                }
                return;
            }
            catch (BindException e0) {
                if (-1 != this.serverBindStartLocalPort) {
                    this.serverBindPreferedLocalPort = 0 == this.serverBindStartLocalPort ? 0 : -1;
                    continue;
                }
                this.closed = true;
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Cannot bind ServerSocket on " + this.serverBindLocalInterface + ":" + this.serverBindPreferedLocalPort, e0);
                }
                return;
            }
            break;
        }
    }

    private static class MessengerBuilder
    implements Runnable {
        private SocketChannel inputSocket;
        private TcpTransport transport;
        TcpMessenger newMessenger;

        MessengerBuilder(SocketChannel inputSocket, TcpTransport transport) {
            assert (inputSocket.socket() != null);
            this.inputSocket = inputSocket;
            this.transport = transport;
        }

        public void run() {
            block5: {
                try {
                    if (this.inputSocket != null && this.inputSocket.isConnected()) {
                        this.newMessenger = new TcpMessenger(this.inputSocket, this.transport);
                    }
                }
                catch (IOException io) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Messenger creation failure", io);
                    }
                }
                catch (Throwable all) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.WARNING)) break block5;
                    LOG.log(Level.SEVERE, "Uncaught Throwable", all);
                }
            }
        }
    }
}

