/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import net.jxta.document.Attributable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.protocol.PeerInfoResponseMessage;

public class PeerInfoResponseMsg
extends PeerInfoResponseMessage {
    public PeerInfoResponseMsg() {
    }

    @Deprecated
    public PeerInfoResponseMsg(PeerID spid, PeerID tpid, long uptime, long timestamp) {
        this.setSourcePid(spid);
        this.setTargetPid(tpid);
        this.setUptime(uptime);
        this.setTimestamp(timestamp);
    }

    public PeerInfoResponseMsg(Element root) {
        this.initialize(root);
    }

    private void initialize(Element root) {
        if (!TextElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        this.setSourcePid(null);
        this.setTargetPid(null);
        this.setUptime(0L);
        this.setTimestamp(0L);
        TextElement doc = (TextElement)root;
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            Enumeration elems;
            ID id;
            URI peerid;
            TextElement element2 = (TextElement)elements.nextElement();
            String elementName = element2.getName();
            if (elementName.equals("sourcePid")) {
                try {
                    peerid = new URI(element2.getTextValue());
                    id = IDFactory.fromURI(peerid);
                    if (!(id instanceof PeerID)) {
                        throw new IllegalArgumentException("Bad ID in advertisement, not a PeerID");
                    }
                    this.setSourcePid((PeerID)id);
                    continue;
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Bad peerid ID in advertisement");
                }
            }
            if (elementName.equals("targetPid")) {
                try {
                    peerid = new URI(element2.getTextValue());
                    id = (PeerID)IDFactory.fromURI(peerid);
                    this.setTargetPid((PeerID)id);
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Bad peerid ID in advertisement");
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("Bad ID in advertisement, not a PeerID");
                }
            }
            if (elementName.equals("uptime")) {
                this.setUptime(Long.parseLong(element2.getTextValue()));
                continue;
            }
            if (elementName.equals("timestamp")) {
                this.setTimestamp(Long.parseLong(element2.getTextValue()));
                continue;
            }
            if (!elementName.equals("response") || !(elems = element2.getChildren()).hasMoreElements()) continue;
            this.setResponse(StructuredDocumentUtils.copyAsDocument((Element)elems.nextElement()));
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, PeerInfoResponseMsg.getMessageType());
        if (doc instanceof Attributable) {
            ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Object e = doc.createElement("sourcePid", this.getSourcePid().toString());
        doc.appendChild(e);
        e = doc.createElement("targetPid", this.getTargetPid().toString());
        doc.appendChild(e);
        Element response = this.getResponse();
        if (null != response) {
            e = doc.createElement("response");
            doc.appendChild(e);
            StructuredDocumentUtils.copyElements(doc, e, response);
        }
        e = doc.createElement("uptime", String.valueOf(this.getUptime()));
        doc.appendChild(e);
        e = doc.createElement("timestamp", String.valueOf(this.getTimestamp()));
        doc.appendChild(e);
        return doc;
    }
}

