/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.logging.Logging;
import net.jxta.util.SimpleSelectable;
import net.jxta.util.SimpleSelector;

public abstract class AbstractSimpleSelectable
implements SimpleSelectable {
    private static final transient Logger LOG = Logger.getLogger(AbstractSimpleSelectable.class.getName());
    public final SimpleSelectable.IdentityReference identityReference = new SimpleSelectable.IdentityReference(this);
    private final SimpleSelectable srcObject;
    private final Map<SimpleSelectable, Object> myListeners = new WeakHashMap<SimpleSelectable, Object>(2);

    public AbstractSimpleSelectable() {
        this.srcObject = this;
    }

    public AbstractSimpleSelectable(SimpleSelectable srcObject) {
        this.srcObject = srcObject;
    }

    public SimpleSelectable.IdentityReference getIdentityReference() {
        return this.identityReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean haveListeners() {
        Map<SimpleSelectable, Object> map = this.myListeners;
        synchronized (map) {
            return !this.myListeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerListener(SimpleSelectable selectable) {
        Map<SimpleSelectable, Object> map = this.myListeners;
        synchronized (map) {
            this.myListeners.put(selectable, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterListener(SimpleSelectable selectable) {
        Map<SimpleSelectable, Object> map = this.myListeners;
        synchronized (map) {
            this.myListeners.remove(selectable);
        }
    }

    public void register(SimpleSelector simpleSelector) {
        this.registerListener(simpleSelector);
        simpleSelector.itemChanged(this);
    }

    public void unregister(SimpleSelector simpleSelector) {
        this.unregisterListener(simpleSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean notifyChange() {
        ArrayList<SimpleSelectable> listeners;
        Map<SimpleSelectable, Object> map = this.myListeners;
        synchronized (map) {
            listeners = new ArrayList<SimpleSelectable>(this.myListeners.keySet());
        }
        for (SimpleSelectable listener : listeners) {
            try {
                listener.itemChanged(this.srcObject);
            }
            catch (Throwable all) {
                if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) continue;
                LOG.log(Level.SEVERE, "Uncaught Throwable in listener " + listener, all);
            }
        }
        return !listeners.isEmpty();
    }
}

