/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.inference.ban;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.inference.ban.IEngine;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public abstract class IEngineStatic
extends IEngine
implements UnitValued {
    boolean _result;

    @Override
    public void freeResult() {
    }

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void endValid() {
        super.endValid();
        this._src.endValid();
    }

    protected abstract void writeCmdExtern(Writer var1, File var2, File var3, String var4) throws IOException;

    protected abstract boolean launchEngine(File var1, File var2, String var3) throws StepperException;

    @Override
    public void execute() {
        if (this.isExtern()) {
            this.executeExtern();
        } else {
            this.executeStatic();
        }
    }

    protected void executeStatic() {
        this._result = false;
        File src = this._src.getSrcFile();
        File dst = this._dst.getDstFile();
        String model = this.getModel();
        try {
            this._result = this.launchEngine(src, dst, model);
        }
        catch (StepperException e) {
            if (this.failOnError()) {
                throw new BanProcessException(e);
            }
            this.log(e.getMessage(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeExtern() {
        File src = this._src.getSrcFile();
        File dst = this._dst.getDstFile();
        String model = this.getModel();
        File fileCmd = null;
        try {
            OutputStreamWriter writerCmd = null;
            try {
                fileCmd = this.createTempFile("InfCmd", ".xmi");
                writerCmd = new FileWriter(fileCmd);
                this.writeCmdExtern(writerCmd, src, dst, model);
                writerCmd.close();
            }
            catch (IOException e) {
                if (this.failOnError()) {
                    throw new BanProcessException(e);
                }
                this.log(e.getMessage(), 0);
            }
            finally {
                if (writerCmd != null) {
                    try {
                        writerCmd.close();
                    }
                    catch (IOException e) {
                        this.log(e.getMessage(), 0);
                    }
                }
            }
            this.launchProcess(fileCmd);
        }
        finally {
            if (fileCmd != null && !fileCmd.delete()) {
                this.log("Not delete file : " + fileCmd.getAbsolutePath(), 1);
                fileCmd.deleteOnExit();
            }
        }
    }
}

