/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepper.ban;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.type.Param;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StepSimul
extends Unit
implements UnitValued {
    protected Object _result;
    String _stepperId;
    String _action;
    List<Param> _params = new ArrayList<Param>();
    String _failOnError;

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void freeResult() {
    }

    public void setStepper(String value) {
        this._stepperId = value;
    }

    protected Stepper getStepper() {
        String id = this.expanse(this._stepperId);
        if (!this.isSimpleID(id)) {
            throw this.errorComplexId("stepper", id, this._stepperId);
        }
        Object obj = this.getProcess().getIdObject(id);
        if (obj == null) {
            throw new BanProcessException("Stepper '" + this._stepperId + "' unknow");
        }
        if (!(obj instanceof Stepper)) {
            throw new BanProcessException("Object with id '" + this._stepperId + "' is not stepper");
        }
        return (Stepper)obj;
    }

    public void setAction(String value) {
        this._action = value;
    }

    public Param createParam() {
        Param param = new Param();
        this._params.add(param);
        return param;
    }

    public void setFailonerror(String value) {
        this._failOnError = value;
    }

    public void endValid() {
        if (this._stepperId == null) {
            throw new BanProcessException("No attribut 'stepper' define");
        }
        if (this._action == null) {
            throw new BanProcessException("No attribut 'action' define");
        }
    }

    Map<String, String> recupParams() {
        return Param.mapParams(this._params);
    }

    protected int getParam(Map<String, String> params, String name) {
        String idx = params.get(name);
        if (idx == null) {
            this.log("No '" + name + "' in StepSimul action", 1);
            return 0;
        }
        try {
            return Integer.parseInt(idx);
        }
        catch (NumberFormatException e) {
            this.log("'" + name + "' parameter is not integer", 1);
            return 0;
        }
    }

    protected int getParamIdx(Map<String, String> params) {
        return this.getParam(params, "idx");
    }

    @Override
    public void execute() {
        Stepper stepper = this.getStepper();
        Map<String, String> params = this.recupParams();
        String action = this.expanse(this._action);
        boolean failOnError = true;
        if (this._failOnError != null) {
            failOnError = this.castBool(this.expanse(this._failOnError), "failonerror");
        }
        if (action.equals("getNbrTransition")) {
            this._result = stepper.getNbrTransition();
        } else if (action.equals("getNameOfTransition")) {
            this._result = stepper.getNameOfTransition(this.getParamIdx(params));
        } else if (action.equals("getDescOfTransition")) {
            this._result = stepper.getDescOfTransition(this.getParamIdx(params));
        } else if (action.equals("isValidTransition")) {
            try {
                this._result = stepper.isValidTransition(this.getParamIdx(params));
            }
            catch (StepperException e) {
                if (failOnError) {
                    throw new BanProcessException(e);
                }
                this.log(e.getMessage(), 0);
                this._result = false;
            }
        } else if (action.equals("getNbrState")) {
            this._result = stepper.getNbrState();
        } else if (action.equals("getNameOfState")) {
            this._result = stepper.getNameOfState(this.getParamIdx(params));
        } else if (action.equals("getValueOfState")) {
            this._result = stepper.getValueOfState(this.getParamIdx(params));
        } else if (action.equals("getValueStringOfState")) {
            this._result = stepper.getValueStringOfState(this.getParamIdx(params));
        } else if (action.equals("getNbrFlow")) {
            this._result = stepper.getNbrFlow();
        } else if (action.equals("getNameOfFlow")) {
            this._result = stepper.getNameOfFlow(this.getParamIdx(params));
        } else if (action.equals("getValueOfFlow")) {
            this._result = stepper.getValueOfFlow(this.getParamIdx(params));
        } else if (action.equals("getValueStringOfFlow")) {
            this._result = stepper.getValueStringOfFlow(this.getParamIdx(params));
        } else if (action.equals("getCurrentTime")) {
            this._result = stepper.getCurrentTime();
        } else if (action.equals("getCurrentCycle")) {
            this._result = stepper.getCurrentCycle();
        } else if (action.equals("goInitialState")) {
            try {
                this._result = stepper.goInitialState();
            }
            catch (StepperException e) {
                if (failOnError) {
                    throw new BanProcessException(e);
                }
                this.log(e.getMessage(), 0);
                this._result = false;
            }
        } else if (action.equals("goForward")) {
            try {
                this._result = stepper.goForward(this.getParamIdx(params));
            }
            catch (StepperException e) {
                if (failOnError) {
                    throw new BanProcessException(e);
                }
                this.log(e.getMessage(), 0);
                this._result = false;
            }
        } else if (action.equals("goBackward")) {
            try {
                this._result = stepper.goBackward(this.getParam(params, "nbr"));
            }
            catch (StepperException e) {
                if (failOnError) {
                    throw new BanProcessException(e);
                }
                this.log(e.getMessage(), 0);
                this._result = false;
            }
        } else if (action.equals("setValueOfState")) {
            int idx = this.getParamIdx(params);
            String value = params.get("value");
            if (value != null && value.length() > 0) {
                try {
                    this._result = stepper.setValueOfState(idx, value);
                }
                catch (StepperException e) {
                    if (failOnError) {
                        throw new BanProcessException(e);
                    }
                    this.log(e.getMessage(), 0);
                    this._result = false;
                }
            } else {
                this._result = false;
            }
        } else if (action.equals("setInitOfState")) {
            int idx = this.getParamIdx(params);
            String value = params.get("value");
            this._result = value != null && value.length() > 0 ? Boolean.valueOf(stepper.setInitOfState(idx, value)) : Boolean.valueOf(false);
        } else {
            throw new BanProcessException("Attribute 'action' unknow : " + action + "[<= " + this._action + "]");
        }
    }
}

