/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepper.ban;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.type.Param;
import com.dassault.cecilia.lib.ban.util.UtilFileSrc;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.inference.ReaderCompilerInference;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.ReaderCompilerJava1;
import com.dassault.cecilia.lib.mbsa.stepper.BanStepper;
import com.dassault.cecilia.lib.mbsa.stepper.CompilReader;
import com.dassault.cecilia.lib.mbsa.translator.simul.ReaderCompilerTranslate;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFCompilReader;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Stepper
extends Unit {
    UtilFileSrc _src = new UtilFileSrc();
    private String _id;
    String _name;
    String _class;
    private String _create;
    List<Param> _params = new ArrayList<Param>();

    public void setSrcfile(String value) {
        this._src.setFile("srcfile", value);
    }

    public void setSrcref(String value) {
        this._src.setRef("srcref", value);
    }

    public void setText(String value) {
        this._src.setText(value);
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._src.setProcess(process);
    }

    public void setId(String value) {
        if (this._id != null) {
            this.log("Attribute 'id' already define : " + this._id + " => " + value, 1);
        }
        this._id = value;
    }

    private void verifyKey() {
        if (this._name != null) {
            throw new BanProcessException("Attribute 'name' already define : " + this._name);
        }
        if (this._class != null) {
            throw new BanProcessException("Attribute 'class' already define : " + this._class);
        }
    }

    public void setName(String value) {
        this.verifyKey();
        this._name = value;
    }

    public void setClass(String value) {
        this.verifyKey();
        this._class = value;
    }

    void verifyReader() {
        if (this._name == null && this._class == null) {
            throw new BanProcessException("No attribut 'name' or 'class' define");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Class<? extends CompilReader> configureReader() {
        Class result = null;
        if (this._name != null) {
            String name = this.expanse(this._name);
            if (name.equalsIgnoreCase("Translate")) {
                return ReaderCompilerTranslate.class;
            }
            if (name.equalsIgnoreCase("Java1")) {
                return ReaderCompilerJava1.class;
            }
            if (name.equalsIgnoreCase("JavaF")) {
                return JFCompilReader.class;
            }
            if (!name.equalsIgnoreCase("Inference")) throw new BanProcessException("CompilReader named [" + name + "] unknow");
            return ReaderCompilerInference.class;
        }
        if (this._class == null) return result;
        String cl = this.expanse(this._class);
        ClassLoader loader = this.getProcess().getClassLoader();
        try {
            result = loader.loadClass(cl);
        }
        catch (ClassNotFoundException e) {
            throw new BanProcessException("Class [" + cl + "] not found");
        }
        if (!CompilReader.class.isAssignableFrom(result)) throw new BanProcessException("Class [" + cl + "] is not CompilReader");
        if (!Modifier.isAbstract(result.getModifiers())) return result;
        throw new BanProcessException("Class [" + cl + "] is not CompilReader");
    }

    public void setCreate(String value) {
        this._create = value;
    }

    public Param createParam() {
        Param param = new Param();
        this._params.add(param);
        return param;
    }

    public void endValid() {
        if (this._id == null) {
            throw new BanProcessException("No attribut 'id' define");
        }
        this.verifyReader();
        this._src.endValid();
    }

    Map<String, String> recupParams() {
        return Param.mapParams(this._params);
    }

    @Override
    public void execute() {
        String id = this.expanse(this._id);
        if (!this.isSimpleID(id)) {
            throw this.errorComplexId("id", id, this._id);
        }
        boolean create = true;
        if (this._create != null) {
            create = this.castBool(this.expanse(this._create), "create");
        }
        File src = this._src.getSrcFile();
        Class<? extends CompilReader> clReader = this.configureReader();
        try {
            CompilReader reader = clReader.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            BanStepper stepper = new BanStepper();
            stepper.setBanEntry(this.getBanEntry());
            Map<String, String> params = this.recupParams();
            stepper.configure(src, reader, params);
            this.getProcess().setIdObject(id, stepper, 2);
            if (create && !stepper.createStepper()) {
                this.log("Stepper configure with warning\n" + params, 1);
            }
        }
        catch (StepperException e) {
            throw new BanProcessException(e);
        }
        catch (Exception e) {
            throw new BanProcessException("Class [" + this._class + "] not instantiate", e);
        }
    }
}

