/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.EventReader;
import com.dassault.cecilia.lib.mbsa.translator.model.ANumber;
import com.dassault.cecilia.lib.mbsa.translator.model.AttributeUser;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Event
extends Data
implements AttributeUser,
EventReader,
Externalizable {
    private String _name;
    private char _basic = '\u0001';
    private Map<String, ANumber> _attributes;
    Map<String, Object> _simulTools = null;

    public Event() {
    }

    public Event(String name) {
        this();
        this._name = name;
    }

    public Data instance(Node parent, String inst) {
        Event res = new Event(inst.length() > 0 ? inst + "." + this.getName() : this.getName());
        res._basic = this._basic;
        res.instance(this);
        return res;
    }

    @Override
    public String getName() {
        return this._name;
    }

    protected void setName(String name) {
        this._name = name;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        return this._name.equals(((Event)obj)._name);
    }

    @Override
    public String getNamedType() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(super.getNamedType());
        sb.append("(");
        sb.append(this._name);
        sb.append(")");
        return sb.toString();
    }

    public boolean isBasic() {
        return this._basic == '\u0001';
    }

    public void noBasic() {
        this._basic = '\u0000';
    }

    @Override
    public void printOTools(IndentWriter out, int frm) throws IOException {
        out.addData(this);
        String name = this.getName();
        if (frm == 4 && name.indexOf(46) != -1) {
            out.write(name.replaceAll("\\.", "^^"));
        } else {
            out.write(name);
        }
    }

    @Override
    public void addAttribute(String name, ANumber value) {
        if (this._attributes == null) {
            this._attributes = new HashMap<String, ANumber>();
        }
        this._attributes.put(name, value);
    }

    @Override
    public ANumber getAttribute(String name) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(name);
    }

    @Override
    public Map<String, ANumber> getAttributes() {
        if (this._attributes == null) {
            return null;
        }
        return Collections.unmodifiableMap(this._attributes);
    }

    @Override
    public Set<String> getNamedAttributes() {
        if (this._attributes == null) {
            return null;
        }
        return Collections.unmodifiableSet(this._attributes.keySet());
    }

    @Override
    public Object getValueOfAttribute(String key) {
        ANumber result = this.getAttribute(key);
        if (result == null) {
            return null;
        }
        return result.createDefaultJavaResult();
    }

    public void putSimulTool(String key, Object value) {
        if (this._simulTools == null) {
            this._simulTools = new HashMap<String, Object>(5);
        }
        this._simulTools.put(key, value);
    }

    public int getPriority() {
        if (this._simulTools == null) {
            return 0;
        }
        Object prio = this._simulTools.get("priority");
        if (prio == null) {
            return 0;
        }
        return (Integer)prio;
    }

    public boolean isStochastic() {
        if (this._simulTools == null) {
            return true;
        }
        Object delay = this._simulTools.get("simul-delay");
        if (delay == null) {
            return true;
        }
        return Double.isInfinite((Double)delay);
    }

    public double computeDelay(double currentTime) {
        if (this._simulTools == null) {
            return Double.POSITIVE_INFINITY;
        }
        Object delay = this._simulTools.get("simul-delay");
        if (delay == null) {
            return Double.POSITIVE_INFINITY;
        }
        return (Double)delay;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._name);
        out.writeBoolean(this._simulTools != null);
        if (this._simulTools != null) {
            out.writeObject(this._simulTools);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._name = (String)in.readObject();
        boolean bReadSimulTool = in.readBoolean();
        if (bReadSimulTool) {
            this._simulTools = (Map)in.readObject();
        }
    }
}

