/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprOp;
import com.dassault.cecilia.lib.mbsa.translator.model.Flow;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class Link
extends Domain {
    protected static final int INVERSE_OUT = 1;
    protected static final int INVERSE_IN = 2;
    private ArrayList<Struct> _structs = new ArrayList();
    private ArrayList<Connect> _connects = new ArrayList();

    protected Struct getData(String name) {
        for (Struct data : this._structs) {
            if (!data._flow.getName().equals(name)) continue;
            return data;
        }
        return null;
    }

    public Flow getFlow(String name) {
        Struct st = this.getData(name);
        return st == null ? null : st._flow;
    }

    @Override
    public Iterator<String> getSymbolic() {
        return new SymbolicIterator();
    }

    public void createFlow(Node node, Flow link) throws TranslateException {
        String name = link.getName();
        for (Struct data : this._structs) {
            char orient = link.getOrientation();
            if (orient == '\u0002') {
                if (data.isFlag(1)) {
                    orient = '\u0001';
                }
            } else if (orient == '\u0001') {
                if (data.isFlag(2)) {
                    orient = '\u0002';
                }
            } else {
                assert (orient == '\u0003');
                assert (!data.isFlag(2));
                assert (!data.isFlag(1));
            }
            Flow flow = new Flow(name + "^" + data._flow.getName(), data._flow.getDomain(), orient);
            flow.setPosition(data._flow, "Sub Flow Link");
            node.addFlow(flow);
        }
    }

    public String printAssert(String in, String out, String indent) {
        StringBuffer sb = new StringBuffer();
        for (Connect c : this._connects) {
            sb.append(indent);
            sb.append(c._inverse ? out : in);
            sb.append('^');
            sb.append((c._inverse ? c._out : c._in).getName());
            sb.append(" = ");
            sb.append(c._inverse ? in : out);
            sb.append('^');
            sb.append((c._inverse ? c._in : c._out).getName());
            sb.append("\n");
        }
        return sb.toString();
    }

    public Expr instance(String in, String out, Node node) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        for (Connect c : this._connects) {
            Expr arg = node.createExpr((c._inverse ? out : in) + "^" + c._in.getName(), node);
            Expr tmp = node.createExpr((c._inverse ? in : out) + "^" + c._out.getName(), node);
            arg = new ExprOp(ExprOp.Type.EQ, arg, tmp);
            arg.setPosition(this, "Connection Link");
            args.add(arg);
        }
        ExprOp res = new ExprOp(ExprOp.Type.AND, args);
        res.setPosition(this, "Connection Link");
        return res;
    }

    public Expr instanceDirect(String var, String val, int orient, Node node) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        for (Struct data : this._structs) {
            boolean inverse = false;
            if (orient == 1 && data.isFlag(2)) {
                inverse = true;
            }
            if (orient == 2 && data.isFlag(1)) {
                inverse = true;
            }
            Expr arg = node.createExpr((inverse ? val : var) + "^" + data._flow.getName(), node);
            Expr tmp = node.createExpr((inverse ? var : val) + "^" + data._flow.getName(), node);
            arg = new ExprOp(ExprOp.Type.EQ, arg, tmp);
            arg.setPosition(this, "Direct Connection Link");
            args.add(arg);
        }
        ExprOp res = new ExprOp(ExprOp.Type.AND, args);
        res.setPosition(this, "Direct Connection Link");
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return false;
    }

    public void addFlow(Flow flow) throws TranslateException {
        assert (!flow.getDomain().isStructured());
        if (this.getData(flow.getName()) != null) {
            throw new TranslateException(flow, "EXC_FLOW_EXIST", flow.getName());
        }
        this._structs.add(new Struct(flow));
    }

    public void setInverse(String flow) throws TranslateException {
        String flowname = flow.substring(2);
        Struct data = this.getData(flowname);
        if (data == null) {
            throw new TranslateException(this, "EXC_FLOW_UNKNOW", flowname);
        }
        switch (flow.charAt(0)) {
            case 'i': {
                data.setFlag(2);
                break;
            }
            case 'o': {
                data.setFlag(1);
                break;
            }
            default: {
                assert (false) : flow;
                break;
            }
        }
    }

    public void addConnect(String var, String val) throws TranslateException {
        boolean inverse = var.charAt(0) == 'o';
        Struct in = this.getData(var.substring(2));
        if (in == null) {
            throw new TranslateException(this, "EXC_FLOW_UNKNOW", var.substring(2));
        }
        if (inverse ? !in.isFlag(1) : in.isFlag(2)) {
            throw new TranslateException(in._flow, "EXC_LINK_ASSERT_INVERSE", new Object[0]);
        }
        if (inverse ? val.charAt(0) == 'o' : val.charAt(0) == 'i') {
            throw new TranslateException(in._flow, "EXC_LINK_CONNECT_SYNTAX", new Object[0]);
        }
        Struct out = this.getData(val.substring(2));
        if (out == null) {
            throw new TranslateException(this, "EXC_FLOW_UNKNOW", val.substring(2));
        }
        if (inverse ? !out.isFlag(2) : out.isFlag(1)) {
            throw new TranslateException(out._flow, "EXC_LINK_ASSERT_INVERSE", new Object[0]);
        }
        if (!in._flow.getDomain().equals(out._flow.getDomain())) {
            throw new TranslateException(out._flow, "EXC_EXPR_EQUALITY", new Object[0]);
        }
        for (Connect c : this._connects) {
            if (c._in != in._flow || c._inverse != inverse) continue;
            throw new TranslateException(in._flow, "EXC_LINK_FLOW_AFFECT", inverse ? "out^" : "in^", var.substring(2));
        }
        this._connects.add(new Connect(in._flow, out._flow, inverse));
    }

    @Override
    public boolean verifyValueOf(Expr expr) {
        return false;
    }

    @Override
    public boolean verifyValueOf(double value) {
        return false;
    }

    @Override
    public boolean isStructured() {
        return true;
    }

    public boolean withInverse() {
        for (Struct data : this._structs) {
            if (data._flags == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDefLL() {
        return true;
    }

    @Override
    public void printDefLL(IndentWriter out, int frm) throws IOException {
        if (frm != 1) {
            throw new IOException("Not print Link for format != InputFormat!!!");
        }
        out.addData(this);
        out.write("link");
        out.write("\n");
        out.addIndent(1);
        boolean inverse = false;
        if (this._structs.size() > 0) {
            out.addData(this);
            out.write("flow \n");
            out.addIndent(1);
            for (Struct data : this._structs) {
                if (data.isFlag(1) || data.isFlag(2)) {
                    inverse = true;
                }
                out.addData(this);
                out.write(data._flow.getName());
                out.write(":");
                data._flow.getDomain().printOTools(out, frm);
                out.write(";\n");
            }
            out.addIndent(-1);
        }
        if (inverse) {
            out.addData(this);
            out.write("inverse \n");
            out.addIndent(1);
            for (Struct data : this._structs) {
                out.addData(this);
                if (data.isFlag(1)) {
                    out.write("out^");
                    out.write(data._flow.getName());
                    out.write(";\n");
                }
                if (!data.isFlag(2)) continue;
                out.write("in^");
                out.write(data._flow.getName());
                out.write(";\n");
            }
            out.addIndent(-1);
        }
        if (this._connects.size() > 0) {
            out.addData(this);
            out.write("assert \n");
            out.addIndent(1);
            for (Connect c : this._connects) {
                out.addData(this);
                out.write((c._inverse ? "out" : "in") + "^" + c._in.getName());
                out.write(" := ");
                out.write((c._inverse ? "in" : "out") + "^" + c._out.getName());
                out.write(";\n");
            }
            out.addIndent(-1);
        }
        out.addIndent(-1);
        out.addData(this);
        out.write("knil");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("link : ");
        sb.append(this._structs.size());
        sb.append(" => ");
        sb.append(this._connects.size());
        return sb.toString();
    }

    @Override
    public void printDefJava(IndentWriter out) throws IOException {
        throw new IOException("Error translate Link to Java simulator");
    }

    @Override
    public void printDefaultValue(IndentWriter out) throws IOException {
        throw new IOException("Error translate Link to Java simulator");
    }

    @Override
    public int getNbrValue() {
        return -1;
    }

    @Override
    public double getDouble(int idx) {
        return Double.NaN;
    }

    @Override
    public String toString(double value) {
        return "NaN";
    }

    @Override
    public double parse(String strValue) {
        return Double.NaN;
    }

    class Connect {
        public Flow _in;
        public Flow _out;
        public boolean _inverse;

        public Connect(Flow in, Flow out, boolean inverse) {
            this._in = in;
            this._out = out;
            this._inverse = inverse;
        }
    }

    class SymbolicIterator
    implements Iterator<String> {
        Iterator<Struct> _flows = null;
        Iterator<String> _curFlow = null;
        String _res = null;

        public SymbolicIterator() {
            this._flows = Link.this._structs.iterator();
            this.goNext();
        }

        protected void goNext() {
            this._res = null;
            if (this._curFlow == null) {
                this._curFlow = this._flows.next()._flow.getDomain().getSymbolic();
            }
            if (this._curFlow.hasNext()) {
                this._res = this._curFlow.next();
                return;
            }
            this._curFlow = null;
            if (this._flows.hasNext()) {
                this.goNext();
            }
        }

        @Override
        public boolean hasNext() {
            return this._res != null;
        }

        @Override
        public String next() {
            String res = this._res;
            this.goNext();
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class Struct {
        public Flow _flow;
        private int _flags;

        public Struct(Flow flow) {
            this._flow = flow;
            this._flags = 0;
        }

        public boolean isFlag(int mask) {
            int res = this._flags & mask;
            return res == mask;
        }

        public void setFlag(int mask) {
            this._flags |= mask;
        }
    }
}

