/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.seqgen;

import com.dassault.cecilia.core.plugin.AbstractPlugTaskBanWithLog;
import com.dassault.cecilia.core.plugin.AbstractPluginWithStepper;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableProxyModel;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.UtilityPluginProcess;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.ban.BanConnected;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.ban.BanInputStream;
import com.dassault.cecilia.lib.ban.BanLicenseException;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.seqgen.PluginDlgGenFMEA;
import com.dassault.cecilia.plugin.mbsa.seqgen.ResSeqGen;
import java.awt.Component;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class PluginCmdGenFMEA
extends AbstractPluginWithStepper
implements PluginMAction {
    public static final String PROP_GENFMEA_OLDFORMAT = "cecilia.mbsa.plugin.genfmea.OldFormat";
    public static final String OPT_POST_PROCESS = PluginCmdGenFMEA.class.getName() + "#PostProcess";

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResSeqGen.getString("PLUG_CMD_FMEA_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResSeqGen.getString("PLUG_CMD_FMEA_DESC");
        }
        if (key.equals("plugin.shortcut")) {
            return "alt F";
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A3-06.svg"));
        }
        return super.getIcon(key);
    }

    public boolean withOption(Plugable plugable) {
        return false;
    }

    protected PluginDlgGenFMEA createDialog(Plugable launcher) {
        PluginDlgGenFMEA dlg = new PluginDlgGenFMEA(launcher.getWindow());
        dlg.defineOptProcess(this.getOptProcess());
        return dlg;
    }

    public void createSession(Plugable launch, Object parameters) {
        PlugableProxyModel launcher = new PlugableProxyModel(launch);
        IModel model = launcher.getModel("altarica.file");
        if (model == null) {
            return;
        }
        PluginDlgGenFMEA dlg = this.createDialog((Plugable)launcher);
        if (!dlg.DoModal(launch)) {
            return;
        }
        Stepper stepper = null;
        if (parameters instanceof String) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("create.fmodel", "true");
            stepper = this.createStepper((Plugable)launcher, new AbstractPluginWithStepper.InfoStepper((String)parameters, model, params));
        } else {
            stepper = this.createStepper((Plugable)launcher, parameters);
        }
        if (stepper == null) {
            return;
        }
        BanEntry banStepper = this.verifyStepper(stepper);
        if (banStepper == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResSeqGen.getString("ERR_STEPPER"));
            return;
        }
        BanEntry ban = this.createBanEntry((Plugable)launcher, dlg, banStepper);
        if (ban == null) {
            return;
        }
        ban.setIdObject("stepper-id", (Object)stepper);
        this.createTask((Plugable)launcher, model, ban, dlg.getFileResult());
    }

    protected String getTaskName() {
        return "FMEAGen";
    }

    protected String getOptProcess() {
        return OPT_POST_PROCESS;
    }

    protected InputStream getBanCanevaStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream("BanScriptFMEAGen.xml");
    }

    protected final void createTask(Plugable launcher, IModel model, BanEntry ban, File resFile) {
        File logFile = this.createFile(launcher, this.getTaskName(), ".log");
        if (logFile == null) {
            return;
        }
        ban.setUserProperty("log.path", logFile.getAbsolutePath());
        UtilityPluginProcess scriptGenerate = new UtilityPluginProcess(resFile){

            protected File createFile(Plugable launch, String base, String ext) {
                return PluginCmdGenFMEA.this.createFile(launch, base, ext);
            }

            protected String getTitle() {
                return PluginCmdGenFMEA.this.getInfo("plugin.name");
            }

            protected String getPostProcessKey(Plugable launch) {
                return launch.getOption(PluginCmdGenFMEA.this.getOptProcess());
            }
        };
        BanInputStream script = scriptGenerate.createBanScript(launcher, this.getTaskName(), this.getBanCanevaStream(), logFile);
        if (script == null) {
            return;
        }
        AbstractPlugTaskBanWithLog task = new AbstractPlugTaskBanWithLog(model.getUID(), launcher, ban, script, logFile){

            protected String getDesc() {
                return PluginCmdGenFMEA.this.getInfo("plugin.name");
            }

            protected String getName() {
                return PluginCmdGenFMEA.this.getTaskName();
            }

            public Icon getIcon(String key) {
                if (key.equals("ptask.icon")) {
                    return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A3-06.svg"));
                }
                return super.getIcon(key);
            }
        };
        launcher.addTask((PlugTask)task, model.getUID());
    }

    private BanEntry verifyStepper(Stepper stepper) {
        if (!(stepper instanceof BanConnected)) {
            return null;
        }
        BanEntry ban = ((BanConnected)stepper).getBanEntry();
        if (ban == null) {
            return null;
        }
        Object step = ban.getIdObject("stepper-id");
        if (step == null) {
            return null;
        }
        if (!(step instanceof Stepper)) {
            return null;
        }
        Object model = ban.getIdObject("altr-fmodel");
        if (model == null) {
            return null;
        }
        return ban;
    }

    protected BanEntry createBanEntry(Plugable launcher, PluginDlgGenFMEA dlg, BanEntry previous) {
        BanEntry entry = null;
        try {
            entry = new BanEntry(previous);
        }
        catch (BanLicenseException e) {
            Logger.getLogger(PluginCmdGenFMEA.class.getPackage().getName()).log(Level.WARNING, "No licence ban", e);
            return null;
        }
        entry.setUserProperty("fmea.onlychange", Boolean.toString(dlg.isChangeValue()));
        entry.setUserProperty("fmea.select.event", dlg.getSelectEvent());
        entry.setUserProperty("fmea.select.state", dlg.getSelectState());
        entry.setUserProperty("fmea.select.flow", dlg.getSelectFlow());
        entry.setUserProperty("fmea.output", dlg.getFileResult().getAbsolutePath());
        if (Boolean.getBoolean(PROP_GENFMEA_OLDFORMAT)) {
            entry.setUserProperty("fmea.oldformat", "true");
        }
        return entry;
    }
}

