/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.diff;

import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.diff.DiffRecDefine;
import com.dassault.cecilia.lib.util.diff.DiffRecord;
import java.util.ArrayList;
import java.util.List;

public abstract class Diff {
    DiffRecDefine _define;
    boolean _firstRecord = false;
    List<Destination> _destinations = new ArrayList<Destination>(2);

    public Diff(Destination destination) {
        this._define = new DiffRecDefine();
        this.addDestination(destination);
    }

    public Diff() {
        this(null);
    }

    public void addDestination(Destination destination) {
        if (destination != null) {
            this._destinations.add(destination);
        }
    }

    public void removeDestination(Destination destination) {
        if (destination != null) {
            this._destinations.remove(destination);
        }
    }

    public void setDefine(DiffRecDefine define) {
        this._define = define;
    }

    public DiffRecDefine getDefine() {
        return this._define;
    }

    public void addRecord(DiffRecord record) {
        int i;
        if (!this._firstRecord) {
            for (i = 0; i < this._destinations.size(); ++i) {
                this._destinations.get(i).publish(this._define);
            }
            this._firstRecord = true;
        }
        for (i = 0; i < this._destinations.size(); ++i) {
            this._destinations.get(i).publish(record);
        }
    }

    public void close() {
        for (int i = 0; i < this._destinations.size(); ++i) {
            this._destinations.get(i).close();
        }
    }

    public boolean withDiff() {
        return this._firstRecord;
    }
}

