/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.io;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class BasicLexer {
    private static final String CHAR_WHITECAR = "\r\n\t ";
    private static final String CHAR_IDWORD = "-_";
    private static final String CHAR_IDCAR = "-_.^";
    private static final String CHAR_IDALTACAR = "-_";
    static final int BUFFER_SIZE = 1024;
    static char[] BUFFER_EMPTY = new char[512];
    Reader _reader;
    boolean _isReaderEOF = false;
    char[] _buffer = new char[1025];
    int _curpos;
    int _cptLine = 0;

    public BasicLexer(String read) {
        this._reader = new StringReader(read);
        this._curpos = 0;
        this.initBuffer();
    }

    public BasicLexer(Reader read) {
        this._reader = read;
        this._curpos = 0;
        this.initBuffer();
    }

    private void initBuffer() {
        try {
            int nbrRead = this._reader.read(this._buffer, 0, 1024);
            if (nbrRead == -1) {
                this._isReaderEOF = true;
            } else {
                this._buffer[nbrRead] = '\u0000';
            }
        }
        catch (IOException exc) {
            this._isReaderEOF = true;
            this._curpos = 1024;
        }
    }

    public String getBuffer() {
        int curpos;
        for (curpos = this._curpos; curpos < 1024 && this._buffer[curpos] != '\u0000'; ++curpos) {
        }
        return new String(this._buffer, 0, curpos);
    }

    public char readChar() {
        char result;
        if (this._curpos >= 1024 && !this._isReaderEOF) {
            try {
                System.arraycopy(this._buffer, 512, this._buffer, 0, 512);
                System.arraycopy(BUFFER_EMPTY, 0, this._buffer, 512, 512);
                int nbrRead = this._reader.read(this._buffer, 512, 512);
                if (nbrRead == -1) {
                    this._isReaderEOF = true;
                } else {
                    this._curpos = 512;
                }
            }
            catch (IOException exc) {
                this._isReaderEOF = true;
            }
        }
        if (this._curpos >= 1024) {
            return '\u0000';
        }
        if ((result = this._buffer[this._curpos++]) == '\n') {
            ++this._cptLine;
        }
        return result;
    }

    public boolean ungetChar() {
        char result;
        if (this._curpos == 0) {
            return false;
        }
        if ((result = this._buffer[--this._curpos]) == '\n') {
            --this._cptLine;
        }
        return true;
    }

    public char readNextChar() {
        char car = this.readChar();
        while (CHAR_WHITECAR.indexOf(car) != -1) {
            car = this.readChar();
        }
        return car;
    }

    public int getLine() {
        return this._cptLine;
    }

    public String readLine() {
        StringBuilder result = new StringBuilder(64);
        char car = this.readChar();
        while (car != '\u0000' && car != '\r' && car != '\n') {
            result.append(car);
            car = this.readChar();
        }
        while (car != '\u0000' && (car == '\r' || car == '\n')) {
            car = this.readChar();
        }
        this.ungetChar();
        return result.toString();
    }

    public long readNextInteger() {
        char car = this.readNextChar();
        StringBuilder result = new StringBuilder(64);
        while (true) {
            if (car < '0' || car > '9') break;
            result.append(car);
            car = this.readChar();
        }
        this.ungetChar();
        if (result.length() == 0) {
            return Long.MIN_VALUE;
        }
        try {
            return Long.parseLong(result.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return Long.MIN_VALUE;
        }
    }

    protected char readCharNumber(char car) {
        if (car >= '0' && car <= '9') {
            return car;
        }
        if (car == '.' || car == '+' || car == '-' || car == 'e' || car == 'E') {
            return car;
        }
        return '\u0000';
    }

    private double readNextNumber(char car) {
        StringBuilder result = new StringBuilder(64);
        while (true) {
            if ((car = this.readCharNumber(car)) == '\u0000') break;
            result.append(car);
            car = this.readChar();
        }
        this.ungetChar();
        if (result.length() == 0) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(result.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public double readNextNumber() {
        char car = this.readNextChar();
        return this.readNextNumber(car);
    }

    public Double readNextJavaNumber() {
        boolean neg = false;
        char car = this.readNextChar();
        if (car == '-') {
            neg = true;
            car = this.readChar();
        }
        if (car == 'N' || car == 'I') {
            this.ungetChar();
            String word = this.readNextWord(false);
            if (word.isEmpty()) {
                return null;
            }
            switch (car) {
                case 'N': {
                    if (!"NaN".equals(word)) {
                        return null;
                    }
                    if (neg) {
                        return null;
                    }
                    return Double.NaN;
                }
                case 'I': {
                    if (!"Infinity".equals(word)) {
                        return null;
                    }
                    if (neg) {
                        return Double.NEGATIVE_INFINITY;
                    }
                    return Double.POSITIVE_INFINITY;
                }
            }
            return null;
        }
        double result = this.readNextNumber(car);
        if (Double.isNaN(result)) {
            return null;
        }
        if (neg) {
            return -result;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String readNextWord(boolean withDigit) {
        char car = this.readNextChar();
        StringBuilder result = new StringBuilder(64);
        boolean first = true;
        while (true) {
            block6: {
                block9: {
                    block8: {
                        block7: {
                            if (car < 'a' || car > 'z') break block7;
                            result.append(car);
                            break block6;
                        }
                        if (car < 'A' || car > 'Z') break block8;
                        result.append(car);
                        break block6;
                    }
                    if (first) break block9;
                    if (withDigit && car >= '0' && car <= '9') {
                        result.append(car);
                        break block6;
                    } else if ("-_".indexOf(car) != -1) {
                        result.append(car);
                        break block6;
                    } else {
                        this.ungetChar();
                        break;
                    }
                }
                this.ungetChar();
                break;
            }
            first = false;
            car = this.readChar();
        }
        if (result.length() == 0) {
            return "";
        }
        return result.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String readNextIdentify(boolean altarica) {
        char car = this.readNextChar();
        StringBuilder result = new StringBuilder(64);
        if (car == '`' || car == '\'') {
            result.append(car);
            do {
                car = this.readChar();
                result.append(car);
            } while (car != '\'' && car != '\u0000');
            if (result.length() <= 2) {
                return "";
            }
            return result.toString();
        }
        boolean first = true;
        while (true) {
            block9: {
                block12: {
                    block13: {
                        block11: {
                            block10: {
                                if (car < 'a' || car > 'z') break block10;
                                result.append(car);
                                break block9;
                            }
                            if (car < 'A' || car > 'Z') break block11;
                            result.append(car);
                            break block9;
                        }
                        if (first) break block12;
                        if (car < '0' || car > '9') break block13;
                        result.append(car);
                        break block9;
                    }
                    if (!altarica && CHAR_IDCAR.indexOf(car) != -1) {
                        result.append(car);
                        break block9;
                    } else if (altarica && "-_".indexOf(car) != -1) {
                        result.append(car);
                        break block9;
                    } else {
                        this.ungetChar();
                        break;
                    }
                }
                this.ungetChar();
                break;
            }
            first = false;
            car = this.readChar();
        }
        if (result.length() == 0) {
            return "";
        }
        return result.toString();
    }

    private String readUntil_impl(char sep) {
        StringBuilder result = new StringBuilder(64);
        char car = this.readChar();
        while (car != sep && car != '\u0000') {
            result.append(car);
            car = this.readChar();
        }
        return result.toString();
    }

    public String readNextString() {
        if (this.readNextChar() != '\"') {
            return "";
        }
        return this.readUntil_impl('\"');
    }

    public String readUntil(char sep) {
        return this.readUntil_impl(sep);
    }
}

