/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.xmlparser;

import com.dassault.cecilia.lib.util.xmlparser.xmlException;
import com.dassault.cecilia.lib.util.xmlparser.xmlNode;
import com.dassault.cecilia.lib.util.xmlparser.xmlParser;
import com.dassault.cecilia.lib.util.xmlparser.xmlTypeNode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;

public class xmlEcho {
    File _input;
    Writer _output;

    public xmlEcho(File input, Writer output) throws IOException {
        this._input = input;
        this._output = output;
    }

    private void working() throws IOException {
        xmlParser parser = new xmlParser(this._input);
        try {
            boolean stop = false;
            while (!stop) {
                xmlNode node = parser.nextNode();
                if (node.getType() == xmlTypeNode.PROCESS) {
                    this._output.write("<?");
                    this._output.write(node.getValue());
                    this._output.write("?>");
                } else if (node.getType() == xmlTypeNode.OTHER) {
                    this._output.write("<!");
                    this._output.write(node.getValue());
                    this._output.write(">");
                } else if (node.getType() == xmlTypeNode.COMMENT) {
                    this._output.write("<!--");
                    this._output.write(node.getValue());
                    this._output.write("-->");
                } else if (node.getType() == xmlTypeNode.START) {
                    this._output.write("<");
                    this._output.write(node.getValue());
                    for (Map.Entry<String, String> entry : node.getAttribs().entrySet()) {
                        this._output.write(" ");
                        this._output.write(entry.getKey());
                        this._output.write("=");
                        this._output.write(entry.getValue());
                    }
                    this._output.write(">");
                } else if (node.getType() == xmlTypeNode.STOP) {
                    this._output.write("</");
                    this._output.write(node.getValue());
                    this._output.write(">");
                } else if (node.getType() == xmlTypeNode.TEXT) {
                    this._output.write(node.getValue());
                } else if (node.getType() == xmlTypeNode.ENDSTREAM) {
                    stop = true;
                }
                this._output.flush();
            }
        }
        catch (xmlException e) {
            System.err.println("xmlException : " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File input = null;
        if (args.length == 1) {
            try {
                input = new File(args[0]);
                xmlEcho echo = new xmlEcho(input, new OutputStreamWriter((OutputStream)System.out, "ISO-8859-1"));
                echo.working();
            }
            catch (IOException e) {
                System.err.println("IOException : " + e.getMessage());
            }
        } else if (args.length == 2) {
            OutputStreamWriter writer = null;
            try {
                input = new File(args[0]);
                writer = new FileWriter(args[1]);
                xmlEcho echo = new xmlEcho(input, writer);
                echo.working();
            }
            catch (IOException e) {
                System.err.println("IOException : " + e.getMessage());
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            System.err.println("Usage syntax : ... .xmlEcho input-file [output-file]");
        }
    }
}

