/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.batch;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportItem;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportItemDlg;
import com.dassault.cecilia.plugin.faulttree.compute.batch.OptionsWordView;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ExportItemWordPanel
extends JPanel {
    private Window _owner;
    private boolean _withForOneHour;
    private JButton _ctrlPageSetup;
    private int _pageOrientation;
    private int _pageWidth;
    private int _pageHeight;
    private JCheckBox _ctrlForOneHour;

    public ExportItemWordPanel(Window owner, boolean withForOneHour) {
        super(new GridBagLayout());
        this._owner = owner;
        this._withForOneHour = withForOneHour;
        this.create();
    }

    protected void create() {
        int y = 0;
        this.createCtrlPageSetup(y++);
        if (this._withForOneHour) {
            this.createForOneHourCtrl(y);
        }
    }

    protected void createCtrlPageSetup(int y) {
        this._ctrlPageSetup = new JButton(ResCompute.msgFormat("BATCH_EXPORT_TREE_MSG_SETUP", "A4P"));
        this._ctrlPageSetup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrinterJob job = PrinterJob.getPrinterJob();
                PageFormat pageFormat = job.defaultPage();
                pageFormat.setOrientation(ExportItemWordPanel.this._pageOrientation);
                Paper paper = pageFormat.getPaper();
                paper.setSize(ExportItemWordPanel.this._pageWidth, ExportItemWordPanel.this._pageHeight);
                paper.setImageableArea(OptionsWordView.DEFAULT_MARGIN, OptionsWordView.DEFAULT_MARGIN, (double)ExportItemWordPanel.this._pageWidth - 2.0 * OptionsWordView.DEFAULT_MARGIN, (double)ExportItemWordPanel.this._pageHeight - 2.0 * OptionsWordView.DEFAULT_MARGIN);
                pageFormat.setPaper(paper);
                pageFormat = job.pageDialog(pageFormat);
                String format = ExportItem.formatToString((int)pageFormat.getWidth(), (int)pageFormat.getHeight(), pageFormat.getOrientation());
                if (format == null || format.length() == 0) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)ExportItemWordPanel.this._owner), ResMsgCore.getString((String)"KEY_1173"), ResMsgVoc.getString((String)"VOC_WARNING"), 2);
                } else {
                    ExportItemWordPanel.this._pageOrientation = pageFormat.getOrientation();
                    ExportItemWordPanel.this._pageHeight = (int)(pageFormat.getPaper().getImageableHeight() + 2.0 * OptionsWordView.DEFAULT_MARGIN);
                    ExportItemWordPanel.this._pageWidth = (int)(pageFormat.getPaper().getImageableWidth() + 2.0 * OptionsWordView.DEFAULT_MARGIN);
                    ExportItemWordPanel.this._ctrlPageSetup.setText(ResCompute.msgFormat("BATCH_EXPORT_TREE_MSG_SETUP", format));
                    ExportItemWordPanel.this._ctrlPageSetup.repaint();
                }
            }
        });
        this.add((Component)this._ctrlPageSetup, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
    }

    protected void createForOneHourCtrl(int y) {
        this._ctrlForOneHour = new JCheckBox(ResCompute.getString("KEY_0050"));
        this.add((Component)this._ctrlForOneHour, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
    }

    public void configureOptions(OptionsWordView options) {
        options._pageOrientation = this._pageOrientation;
        options._pageWidth = this._pageWidth;
        options._pageHeight = this._pageHeight;
    }

    public void configureDlg(OptionsWordView options) {
        this._pageOrientation = options._pageOrientation;
        this._pageWidth = options._pageWidth;
        this._pageHeight = options._pageHeight;
        String format = ExportItem.formatToString(options._pageWidth, options._pageHeight, options._pageOrientation);
        if (format == null || format.length() == 0) {
            this._pageOrientation = 1;
            this._pageWidth = 595;
            this._pageHeight = 841;
            format = ExportItem.formatToString(this._pageWidth, this._pageHeight, this._pageOrientation);
        }
        this._ctrlPageSetup.setText(ResCompute.msgFormat("BATCH_EXPORT_TREE_MSG_SETUP", format));
    }

    public boolean isForOneHour() {
        if (!this._withForOneHour) {
            throw new IllegalAccessError();
        }
        return this._ctrlForOneHour.isSelected();
    }

    public void setForOneHour(boolean value) {
        if (!this._withForOneHour) {
            throw new IllegalAccessError();
        }
        this._ctrlForOneHour.setSelected(value);
    }

    public static class ExportItemWordDlg
    extends ExportItemDlg {
        private ExportItemWordPanel _panel;

        public ExportItemWordDlg(Window owner, String title) {
            super(owner, title);
        }

        public ExportItemWordDlg(Window owner) {
            this(owner, ResCompute.getString("BATCH_EXPORT_WORD_OPTS_TITLE"));
        }

        @Override
        protected boolean verifyPanel() {
            return true;
        }

        @Override
        protected JPanel createPanel() {
            this._panel = new ExportItemWordPanel(this.getOwner(), true);
            return this._panel;
        }

        public ExportItemWordPanel getPanel() {
            return this._panel;
        }
    }
}

