/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.bddmemory;

import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.plugin.faulttree.compute.bddmemory.OptionsAralia;
import com.dassault.cecilia.plugin.faulttree.compute.bddmemory.OptionsAralia2Panel;
import com.dassault.cecilia.plugin.faulttree.compute.bddmemory.OptionsAralia2Parser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.LinkedHashMap;
import java.util.Map;

public class OptionsAralia2
extends OptionsAralia {
    public static final String OPT_BDDTableMax = "BDD-table maximum";
    public static final String OPT_BDDTableMin = "BDD-table minimum";
    public static final String OPT_BDDTableSize = "BDD-table size";
    public static final String OPT_OpTableMax = "operation-table maximum";
    public static final String OPT_OpTableMin = "operation-table minimum";
    public static final String OPT_OpTableSize = "operation-table size";
    public static final String OPT_PageSize = "page-size";
    public static final String OPT_PageNbr = "maximum-page-number";
    public static final String OPT_RatioP = "enlargement-ratio";
    public static final String OPT_RatioM = "reduction-ratio";
    public static final String OPT_GCPeriod = "garbage-collector-period";

    @Override
    public void readUserConfig(String parameters) {
        this._userOptions.clear();
        OptionsAralia2Parser parser = new OptionsAralia2Parser(parameters, this._userOptions);
        parser.run();
    }

    @Override
    public String generateConfigurations(boolean save) {
        Map<String, String> configs = this.getConfigOptions(this._config);
        StringBuffer parameters = new StringBuffer();
        if (save) {
            for (String key : configs.keySet()) {
                parameters.append("set " + key + " " + configs.get(key) + ";\n");
            }
        } else {
            parameters.append("configure BDD-table {\n");
            parameters.append("\tminimum ").append(configs.get(OPT_BDDTableMin)).append("\n");
            parameters.append("\tmaximum ").append(configs.get(OPT_BDDTableMax)).append("\n");
            parameters.append("\tsize ").append(configs.get(OPT_BDDTableSize)).append("\n");
            parameters.append("\tmaximum-page-number ").append(configs.get(OPT_PageNbr)).append("\n");
            parameters.append("\tpage-size ").append(configs.get(OPT_PageSize)).append("\n");
            parameters.append("\tenlargement-ratio ").append(configs.get(OPT_RatioP)).append("\n");
            parameters.append("\treduction-ratio ").append(configs.get(OPT_RatioM)).append("\n");
            parameters.append("\tgarbage-period ").append(configs.get(OPT_GCPeriod)).append("\n");
            parameters.append("};\n\n");
            parameters.append("configure operation-table {\n");
            parameters.append("\tminimum ").append(configs.get(OPT_OpTableMin)).append("\n");
            parameters.append("\tmaximum ").append(configs.get(OPT_OpTableMax)).append("\n");
            parameters.append("\tsize ").append(configs.get(OPT_OpTableSize)).append("\n");
            parameters.append("};\n\n");
        }
        return parameters.toString();
    }

    @Override
    protected Map<String, String> getConfigOptions(OptionsAralia.Type typeConfig) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        switch (typeConfig) {
            case CFG1: {
                map.put(OPT_BDDTableMax, "16777213");
                map.put(OPT_BDDTableMin, "1023");
                map.put(OPT_BDDTableSize, "4194301");
                map.put(OPT_OpTableMax, "16777213");
                map.put(OPT_OpTableMin, "1023");
                map.put(OPT_OpTableSize, "4194301");
                map.put(OPT_PageSize, "131072");
                map.put(OPT_PageNbr, "350");
                map.put(OPT_RatioP, "0.25");
                map.put(OPT_RatioM, "0.01");
                map.put(OPT_GCPeriod, "2147483647");
                break;
            }
            case CFG2: {
                map.put(OPT_BDDTableMax, "50331493");
                map.put(OPT_BDDTableMin, "1023");
                map.put(OPT_BDDTableSize, "12582893");
                map.put(OPT_OpTableMax, "50331493");
                map.put(OPT_OpTableMin, "1023");
                map.put(OPT_OpTableSize, "12582893");
                map.put(OPT_PageSize, "131072");
                map.put(OPT_PageNbr, "1050");
                map.put(OPT_RatioP, "0.25");
                map.put(OPT_RatioM, "0.01");
                map.put(OPT_GCPeriod, "2147483647");
                break;
            }
            case CFG3: {
                map.put(OPT_BDDTableMax, "100663291");
                map.put(OPT_BDDTableMin, "1023");
                map.put(OPT_BDDTableSize, "25165813");
                map.put(OPT_OpTableMax, "100663291");
                map.put(OPT_OpTableMin, "1023");
                map.put(OPT_OpTableSize, "25165813");
                map.put(OPT_PageSize, "131072");
                map.put(OPT_PageNbr, "2100");
                map.put(OPT_RatioP, "0.25");
                map.put(OPT_RatioM, "0.01");
                map.put(OPT_GCPeriod, "2147483647");
                break;
            }
            case CFGUser: {
                return this._userOptions;
            }
        }
        return map;
    }

    @Override
    public boolean changeWithDialog(Window owner, String title) {
        DlgChange dlg = new DlgChange(owner, title);
        dlg._options.configurate(this);
        dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf((Component)owner));
        dlg.setVisible(true);
        if (dlg.getResult()) {
            this._config = dlg._options.getTypeConfig();
            if (this._config == OptionsAralia.Type.CFGUser) {
                this._userOptions = dlg._options.getUserConfig();
            }
            return true;
        }
        return false;
    }

    class DlgChange
    extends JDialogCecilia {
        OptionsAralia2Panel _options;

        DlgChange(Window owner, String title) {
            super(owner, title, true);
            this._options = new OptionsAralia2Panel();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this._options, "Center");
            this.getContentPane().add((Component)this.createButPanel(true), "South");
            this.init();
            this.pack();
            this.setResizable(false);
        }

        protected boolean verifyParameters() {
            return this._options.validateData();
        }
    }
}

