/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.lib.util.TestUtility;
import com.dassault.cecilia.plugin.faulttree.compute.compute.AverageRiskCompute;
import org.junit.Assert;
import org.junit.Test;

public class AverageRiskComputeMarkovTest
extends TestUtility {
    @Test
    public void test1Fault() {
        AverageRiskCompute helper = AverageRiskCompute.create(AverageRiskCompute.Type.Markov1);
        Assert.assertEquals((double)0.2902862877947975, (double)helper.computeOneFailures(0.001, 730.0), (double)0.0);
        Assert.assertEquals((double)0.990000000000001, (double)helper.computeOneFailures(0.001, 100000.0), (double)0.0);
        Assert.assertEquals((double)4.999999998333334E-10, (double)helper.computeOneFailures(1.0E-10, 10.0), (double)0.0);
    }

    @Test
    public void test2Fault() {
        AverageRiskCompute helper = AverageRiskCompute.create(AverageRiskCompute.Type.Markov1);
        Assert.assertEquals((double)0.0045051452887852495, (double)helper.computeTwoFailures(0.001, 730.0, 1.0E-5, 2920.0), (double)0.0);
        Assert.assertEquals((double)1.2910106294933457E-7, (double)helper.computeTwoFailures(0.001, 1.0, 5.0E-5, 10.0), (double)0.0);
        Assert.assertEquals((double)1.2851254012588913E-5, (double)helper.computeTwoFailures(0.001, 10.0, 5.0E-5, 100.0), (double)0.0);
        Assert.assertEquals((double)0.0012281180280853867, (double)helper.computeTwoFailures(0.001, 100.0, 5.0E-5, 1000.0), (double)0.0);
        Assert.assertEquals((double)0.08042140691523697, (double)helper.computeTwoFailures(0.001, 1000.0, 5.0E-5, 10000.0), (double)0.0);
        Assert.assertEquals((double)3.3308344995834555E-7, (double)helper.computeTwoFailures(0.001, 1.0, 0.001, 1.0), (double)0.0);
        Assert.assertEquals((double)3.308449584560374E-5, (double)helper.computeTwoFailures(0.001, 10.0, 0.001, 10.0), (double)0.0);
        Assert.assertEquals((double)0.00309459532928217, (double)helper.computeTwoFailures(0.001, 100.0, 0.001, 100.0), (double)0.0);
        Assert.assertEquals((double)0.16809124072457926, (double)helper.computeTwoFailures(0.001, 1000.0, 0.001, 1000.0), (double)0.0);
        Assert.assertEquals((double)1.740035987298171E-5, (double)helper.computeTwoFailures(0.001, 10.0, 3.0E-4, 20.0), (double)0.0);
        Assert.assertEquals((double)0.03322454391316249, (double)helper.computeTwoFailures(0.001, 500.0, 3.0E-4, 1000.0), (double)0.0);
        Assert.assertEquals((double)3.6123519490627624E-4, (double)helper.computeTwoFailures(0.001, 100.0, 3.0E-7, 50000.0), (double)0.0);
    }

    @Test
    public void test3Fault() {
        AverageRiskCompute helper = AverageRiskCompute.create(AverageRiskCompute.Type.Markov1);
        Assert.assertEquals((double)0.004505145281946388, (double)helper.computeThreeFailures(0.001, 730.0, 1.0E-5, 2920.0, 1.0, 2920.0), (double)0.0);
        Assert.assertEquals((double)2.0823971509611387E-12, (double)helper.computeThreeFailures(0.001, 1.0, 5.0E-5, 2.0, 5.0E-5, 2.0), (double)0.0);
        Assert.assertEquals((double)2.073996289370827E-9, (double)helper.computeThreeFailures(0.001, 10.0, 5.0E-5, 20.0, 5.0E-5, 20.0), (double)0.0);
        Assert.assertEquals((double)1.992385736520019E-6, (double)helper.computeThreeFailures(0.001, 100.0, 5.0E-5, 200.0, 5.0E-5, 200.0), (double)0.0);
        Assert.assertEquals((double)0.0013699556237947053, (double)helper.computeThreeFailures(0.001, 1000.0, 5.0E-5, 2000.0, 5.0E-5, 2000.0), (double)0.0);
        Assert.assertEquals((double)2.497002082262353E-10, (double)helper.computeThreeFailures(0.001, 1.0, 0.001, 1.0, 0.001, 1.0), (double)0.0);
        Assert.assertEquals((double)2.470207266368006E-7, (double)helper.computeThreeFailures(0.001, 10.0, 0.001, 10.0, 0.001, 10.0), (double)0.0);
        Assert.assertEquals((double)2.2198051478553515E-4, (double)helper.computeThreeFailures(0.001, 100.0, 0.001, 100.0, 0.001, 100.0), (double)0.0);
        Assert.assertEquals((double)0.08389775478202904, (double)helper.computeThreeFailures(0.001, 1000.0, 0.001, 1000.0, 0.001, 1000.0), (double)0.0);
        Assert.assertEquals((double)2.110891202159907E-8, (double)helper.computeThreeFailures(0.001, 10.0, 3.0E-4, 20.0, 5.0E-5, 40.0), (double)0.0);
        Assert.assertEquals((double)0.0019249415000686565, (double)helper.computeThreeFailures(0.001, 500.0, 3.0E-4, 1000.0, 5.0E-5, 2000.0), (double)0.0);
        Assert.assertEquals((double)1.871660433635797E-6, (double)helper.computeThreeFailures(0.001, 100.0, 2.0E-6, 5000.0, 3.0E-7, 50000.0), (double)0.0);
    }

    @Test
    public void test2FaultExclusive() {
        AverageRiskCompute helper = AverageRiskCompute.create(AverageRiskCompute.Type.Markov1);
        Assert.assertEquals((double)3.880240308604346E-6, (double)helper.computeTwoFailuresExcluded(1.0, 0.001, 730.0, 1.0E-5, 2920.0), (double)0.0);
        Assert.assertEquals((double)1.2868983547167366E-7, (double)helper.computeTwoFailuresExcluded(1.0, 0.001, 1.0, 5.0E-5, 10.0), (double)0.0);
        Assert.assertEquals((double)1.317766817502862E-6, (double)helper.computeTwoFailuresExcluded(1.0, 0.001, 10.0, 5.0E-5, 100.0), (double)0.0);
        Assert.assertEquals((double)9.829162077430224E-6, (double)helper.computeTwoFailuresExcluded(1.0, 0.001, 100.0, 5.0E-5, 1000.0), (double)0.0);
        Assert.assertEquals((double)2.2868227143088208E-5, (double)helper.computeTwoFailuresExcluded(1.0, 0.001, 1000.0, 5.0E-5, 10000.0), (double)0.0);
        Assert.assertEquals((double)3.3308344995834555E-7, (double)helper.computeTwoFailuresExcluded(1.0, 0.001, 1.0, 0.001, 1.0), (double)0.0);
        Assert.assertEquals((double)4.786167224314924E-6, (double)helper.computeTwoFailuresExcluded(1.0, 0.001, 10.0, 0.001, 10.0), (double)0.0);
        Assert.assertEquals((double)4.520817140681865E-5, (double)helper.computeTwoFailuresExcluded(1.0, 0.001, 100.0, 0.001, 100.0), (double)0.0);
        Assert.assertEquals((double)2.276551250180415E-4, (double)helper.computeTwoFailuresExcluded(1.0, 0.001, 1000.0, 0.001, 1000.0), (double)0.0);
        Assert.assertEquals((double)2.1765076513162433E-6, (double)helper.computeTwoFailuresExcluded(1.0, 0.001, 10.0, 3.0E-4, 20.0), (double)0.0);
        Assert.assertEquals((double)7.045319327005427E-5, (double)helper.computeTwoFailuresExcluded(1.0, 0.001, 500.0, 3.0E-4, 1000.0), (double)0.0);
        Assert.assertEquals((double)1.470820768317459E-7, (double)helper.computeTwoFailuresExcluded(1.0, 0.001, 100.0, 3.0E-7, 50000.0), (double)0.0);
        Assert.assertEquals((double)4.95023247034072E-11, (double)helper.computeTwoFailuresExcluded(1.0, 1.0E-10, 10.0, 0.001, 100000.0), (double)0.0);
    }

    @Test
    public void test3FaultExclusive() {
        AverageRiskCompute helper = AverageRiskCompute.create(AverageRiskCompute.Type.Markov1);
        Assert.assertEquals((double)3.880240281494033E-6, (double)helper.computeThreeFailuresExcluded(1.0, 0.001, 730.0, 1.0E-5, 2920.0, 1.0, 2920.0), (double)0.0);
        Assert.assertEquals((double)2.0817727027579937E-12, (double)helper.computeThreeFailuresExcluded(1.0, 0.001, 1.0, 5.0E-5, 2.0, 5.0E-5, 2.0), (double)0.0);
        Assert.assertEquals((double)2.997225649232081E-10, (double)helper.computeThreeFailuresExcluded(1.0, 0.001, 10.0, 5.0E-5, 20.0, 5.0E-5, 20.0), (double)0.0);
        Assert.assertEquals((double)2.8813814388989524E-8, (double)helper.computeThreeFailuresExcluded(1.0, 0.001, 100.0, 5.0E-5, 200.0, 5.0E-5, 200.0), (double)0.0);
        Assert.assertEquals((double)1.5701380444570418E-6, (double)helper.computeThreeFailuresExcluded(1.0, 0.001, 1000.0, 5.0E-5, 2000.0, 5.0E-5, 2000.0), (double)0.0);
        Assert.assertEquals((double)2.497002082262353E-10, (double)helper.computeThreeFailuresExcluded(1.0, 0.001, 1.0, 0.001, 1.0, 0.001, 1.0), (double)0.0);
        Assert.assertEquals((double)4.680564824524791E-8, (double)helper.computeThreeFailuresExcluded(1.0, 0.001, 10.0, 0.001, 10.0, 0.001, 10.0), (double)0.0);
        Assert.assertEquals((double)4.288639561626973E-6, (double)helper.computeThreeFailuresExcluded(1.0, 0.001, 100.0, 0.001, 100.0, 0.001, 100.0), (double)0.0);
        Assert.assertEquals((double)1.3110572122061048E-4, (double)helper.computeThreeFailuresExcluded(1.0, 0.001, 1000.0, 0.001, 1000.0, 0.001, 1000.0), (double)0.0);
        Assert.assertEquals((double)2.8810440685705495E-9, (double)helper.computeThreeFailuresExcluded(1.0, 0.001, 10.0, 3.0E-4, 20.0, 5.0E-5, 40.0), (double)0.0);
        Assert.assertEquals((double)4.291687534068048E-6, (double)helper.computeThreeFailuresExcluded(1.0, 0.001, 500.0, 3.0E-4, 1000.0, 5.0E-5, 2000.0), (double)0.0);
        Assert.assertEquals((double)6.303559785140063E-9, (double)helper.computeThreeFailuresExcluded(1.0, 0.001, 100.0, 2.0E-6, 5000.0, 3.0E-7, 50000.0), (double)0.0);
    }

    @Test
    public void testDecimal() {
        AverageRiskCompute helper = AverageRiskCompute.create(AverageRiskCompute.Type.Markov1);
        Assert.assertEquals((double)1.199132461256927E-8, (double)helper.computeTwoFailures(1.0E-6, 20.0, 3.0E-8, 80000.0), (double)0.0);
        Assert.assertEquals((double)1.199132461256927E-8, (double)helper.computeTwoFailures(1.0E-5, 2.0, 3.0E-7, 8000.0), (double)0.0);
        Assert.assertEquals((double)1.1990805362977808E-8, (double)helper.computeTwoFailures(1.0E-5, 2.0000001, 3.0E-7, 8000.0), (double)0.0);
        Assert.assertEquals((double)1.1990331820196447E-8, (double)helper.computeTwoFailures(1.0E-5, 2.000001, 3.0E-7, 8000.0), (double)0.0);
        Assert.assertEquals((double)1.1990386161365887E-8, (double)helper.computeTwoFailures(1.0E-5, 2.00001, 3.0E-7, 8000.0), (double)0.0);
        Assert.assertEquals((double)1.199095944259639E-8, (double)helper.computeTwoFailures(1.0E-5, 2.0001, 3.0E-7, 8000.0), (double)0.0);
        Assert.assertEquals((double)1.199632044491548E-8, (double)helper.computeTwoFailures(1.0E-5, 2.001, 3.0E-7, 8000.0), (double)0.0);
        Assert.assertEquals((double)1.2146522208621369E-8, (double)helper.computeTwoFailures(1.0E-5, 2.01, 3.0E-7, 8000.0), (double)0.0);
        Assert.assertEquals((double)1.2589840412718207E-8, (double)helper.computeTwoFailures(1.0E-5, 2.1, 3.0E-7, 8000.0), (double)0.0);
    }

    @Test
    public void testFormulaeDeveloppedNaN() {
        AverageRiskCompute helper = AverageRiskCompute.create(AverageRiskCompute.Type.FormulaeDevelopped);
        System.out.println("6.0E-5, 2.33, 2.2E-4, 2.33             ; " + helper.computeTwoFailures(6.0E-5, 2.33, 2.2E-4, 2.33));
        System.out.println("6.0E-6, 2.33, 2.2E-7, 2.33             ; " + helper.computeTwoFailures(6.0E-6, 2.33, 2.2E-7, 2.33));
        System.out.println("1e-8, 2.330, 1e-8, 2.330, 1e-8, 2.330  ; " + helper.computeThreeFailures(1.0E-8, 2.33, 1.0E-8, 2.33, 1.0E-8, 2.33));
    }
}

