/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.plugin.faulttree.compute.compute.AverageRiskCompute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class AverageRiskComputeProxy
extends AverageRiskCompute {
    private static Logger _LOG = Logger.getLogger(AverageRiskComputeProxy.class.getPackage().getName());
    AverageRiskCompute _delegate;
    public static final String PROP_AVGRSK_TYPE = "cecilia.ft.compute.AverageRisk";
    public static final String PROP_AVGRSK_REINIT = "cecilia.ft.compute.AverageRiskReinit";
    public static final String PROP_AVGRSK_NOHASH = "cecilia.ft.compute.AverageRiskNoHash";
    public static final int PROP_DEF_AVGRSK_NANNBR = 10;
    public static final String PROP_AVGRSK_NANNBR = "cecilia.ft.compute.AverageRiskNaNNbr";
    public static final int PROP_DEF_AVGRSK_TIMENBR = 10;
    public static final String PROP_AVGRSK_TIMENBR = "cecilia.ft.compute.AverageRiskTimeNbr";
    public static final long PROP_DEF_AVGRSK_TIMELIMIT = 1000000L;
    public static final String PROP_AVGRSK_TIMELIMIT = "cecilia.ft.compute.AverageRiskTimeLimit";
    Map<ResultKey, ResultValue> _mapResult;
    ResultKey _keyResult;
    ResultValue _longResult;
    private int _naN_Count = 0;
    private int _naN_Limit = 10;
    AverageRiskCompute.Type _type;

    public AverageRiskComputeProxy() {
        this.init();
    }

    public void init() {
        String strCompute = System.getProperty(PROP_AVGRSK_TYPE, AverageRiskCompute.Type.Markov1.toString());
        this._type = AverageRiskCompute.Type.valueOf(strCompute);
        if (this._type == null) {
            this._type = AverageRiskCompute.Type.Markov1;
        }
        this._delegate = AverageRiskComputeProxy.create(this._type);
        if (Boolean.getBoolean(PROP_AVGRSK_NOHASH)) {
            this._mapResult = null;
            this._keyResult = null;
            this._longResult = null;
        } else {
            this._mapResult = new HashMap<ResultKey, ResultValue>(1023, 0.75f);
            this._keyResult = new ResultKey(new double[0]);
            this._longResult = null;
        }
        this._naN_Count = 0;
        this._naN_Limit = Integer.getInteger(PROP_AVGRSK_NANNBR, 10);
    }

    public Object getLongResult() {
        return this._longResult;
    }

    public String printLongCompute(int nbr, long limit) {
        if (this._mapResult == null) {
            return "";
        }
        ArrayList<ResultValue> results = new ArrayList<ResultValue>(this._mapResult.values());
        Collections.sort(results);
        nbr = nbr < 0 ? results.size() : Math.min(nbr, results.size());
        StringBuffer sb = new StringBuffer(nbr * 256);
        for (int i = 0; i < nbr; ++i) {
            ResultValue result = results.get(i);
            if (limit > 0L && result._timeToCompute < limit) continue;
            sb.append(result.toString()).append("\n");
        }
        return sb.toString();
    }

    private String printCurrentResult(double result, double ... params) {
        StringBuffer log = new StringBuffer();
        log.append("AverageRiskCompute(").append((Object)this._type).append(") return ").append(result).append(" with {");
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                log.append(", ");
            }
            log.append(params[i]);
        }
        log.append("}");
        return log.toString();
    }

    @Override
    public double computeOneFailures(double l1, double T1) {
        double result = this._delegate.computeOneFailures(l1, T1);
        if (!(result >= 0.0) && this._naN_Count < this._naN_Limit) {
            _LOG.info(this.printCurrentResult(result, l1, T1));
            ++this._naN_Count;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double computeTwoFailures(double l1, double T1, double l2, double T2) {
        if (T1 > T2) {
            double tmp = T2;
            T2 = T1;
            T1 = tmp;
            tmp = l2;
            l2 = l1;
            l1 = tmp;
        }
        if (this._mapResult != null) {
            ResultValue value = null;
            ResultKey resultKey = this._keyResult;
            synchronized (resultKey) {
                this._keyResult.setParameters(l1, T1, l2, T2);
                value = this._mapResult.get(this._keyResult);
            }
            if (value == null) {
                long time = System.nanoTime();
                double result = this._delegate.computeTwoFailures(l1, T1, l2, T2);
                time = System.nanoTime() - time;
                value = new ResultValue(new ResultKey(l1, T1, l2, T2), result, time);
                this._mapResult.put(value._params, value);
                if (this._longResult == null || this._longResult._timeToCompute < time) {
                    this._longResult = value;
                }
                if (!(result >= 0.0) && this._naN_Count < this._naN_Limit) {
                    _LOG.info(this.printCurrentResult(result, l1, T1, l2, T2));
                    ++this._naN_Count;
                }
            }
            return value._result;
        }
        double result = this._delegate.computeTwoFailures(l1, T1, l2, T2);
        if (!(result >= 0.0) && this._naN_Count < this._naN_Limit) {
            _LOG.info(this.printCurrentResult(result, l1, T1, l2, T2));
            ++this._naN_Count;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double computeTwoFailuresExcluded(double tm, double l1, double T1, double l2, double T2) {
        if (T1 > T2) {
            double tmp = T2;
            T2 = T1;
            T1 = tmp;
            tmp = l2;
            l2 = l1;
            l1 = tmp;
        }
        if (this._mapResult != null) {
            ResultValue value = null;
            ResultKey resultKey = this._keyResult;
            synchronized (resultKey) {
                this._keyResult.setParameters(tm, l1, T1, l2, T2);
                value = this._mapResult.get(this._keyResult);
            }
            if (value == null) {
                long time = System.nanoTime();
                double result = this._delegate.computeTwoFailuresExcluded(tm, l1, T1, l2, T2);
                time = System.nanoTime() - time;
                value = new ResultValue(new ResultKey(tm, l1, T1, l2, T2), result, time);
                this._mapResult.put(value._params, value);
                if (this._longResult == null || this._longResult._timeToCompute < time) {
                    this._longResult = value;
                }
                if (!(result >= 0.0) && this._naN_Count < this._naN_Limit) {
                    _LOG.info(this.printCurrentResult(result, tm, l1, T1, l2, T2));
                    ++this._naN_Count;
                }
            }
            return value._result;
        }
        double result = this._delegate.computeTwoFailuresExcluded(tm, l1, T1, l2, T2);
        if (!(result >= 0.0) && this._naN_Count < this._naN_Limit) {
            _LOG.info(this.printCurrentResult(result, tm, l1, T1, l2, T2));
            ++this._naN_Count;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double computeThreeFailures(double l1, double T1, double l2, double T2, double l3, double T3) {
        if (T1 <= T2) {
            if (!(T2 <= T3)) {
                if (T1 <= T3) {
                    double tmp = T2;
                    T2 = T3;
                    T3 = tmp;
                    tmp = l2;
                    l2 = l3;
                    l3 = tmp;
                } else {
                    double tmp = T1;
                    T1 = T3;
                    T3 = T2;
                    T2 = tmp;
                    tmp = l1;
                    l1 = l3;
                    l3 = l2;
                    l2 = tmp;
                }
            }
        } else if (T1 <= T3) {
            double tmp = T2;
            T2 = T1;
            T1 = tmp;
            tmp = l2;
            l2 = l1;
            l1 = tmp;
        } else if (T2 <= T3) {
            double tmp = T1;
            T1 = T2;
            T2 = T3;
            T3 = tmp;
            tmp = l1;
            l1 = l2;
            l2 = l3;
            l3 = tmp;
        } else {
            double tmp = T3;
            T3 = T1;
            T1 = tmp;
            tmp = l3;
            l3 = l1;
            l1 = tmp;
        }
        if (this._mapResult != null) {
            ResultValue value = null;
            ResultKey resultKey = this._keyResult;
            synchronized (resultKey) {
                this._keyResult.setParameters(l1, T1, l2, T2, l3, T3);
                value = this._mapResult.get(this._keyResult);
            }
            if (value == null) {
                long time = System.nanoTime();
                double result = this._delegate.computeThreeFailures(l1, T1, l2, T2, l3, T3);
                time = System.nanoTime() - time;
                value = new ResultValue(new ResultKey(l1, T1, l2, T2, l3, T3), result, time);
                this._mapResult.put(value._params, value);
                if (this._longResult == null || this._longResult._timeToCompute < time) {
                    this._longResult = value;
                }
                if (!(result >= 0.0) && this._naN_Count < this._naN_Limit) {
                    _LOG.info(this.printCurrentResult(result, l1, T1, l2, T2, l3, T3));
                    ++this._naN_Count;
                }
            }
            return value._result;
        }
        double result = this._delegate.computeThreeFailures(l1, T1, l2, T2, l3, T3);
        if (!(result >= 0.0) && this._naN_Count < this._naN_Limit) {
            _LOG.info(this.printCurrentResult(result, l1, T1, l2, T2, l3, T3));
            ++this._naN_Count;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double computeThreeFailuresExcluded(double tm, double l1, double T1, double l2, double T2, double l3, double T3) {
        if (T1 <= T2) {
            if (!(T2 <= T3)) {
                if (T1 <= T3) {
                    double tmp = T2;
                    T2 = T3;
                    T3 = tmp;
                    tmp = l2;
                    l2 = l3;
                    l3 = tmp;
                } else {
                    double tmp = T1;
                    T1 = T3;
                    T3 = T2;
                    T2 = tmp;
                    tmp = l1;
                    l1 = l3;
                    l3 = l2;
                    l2 = tmp;
                }
            }
        } else if (T1 <= T3) {
            double tmp = T2;
            T2 = T1;
            T1 = tmp;
            tmp = l2;
            l2 = l1;
            l1 = tmp;
        } else if (T2 <= T3) {
            double tmp = T1;
            T1 = T2;
            T2 = T3;
            T3 = tmp;
            tmp = l1;
            l1 = l2;
            l2 = l3;
            l3 = tmp;
        } else {
            double tmp = T3;
            T3 = T1;
            T1 = tmp;
            tmp = l3;
            l3 = l1;
            l1 = tmp;
        }
        if (this._mapResult != null) {
            ResultValue value = null;
            ResultKey resultKey = this._keyResult;
            synchronized (resultKey) {
                this._keyResult.setParameters(tm, l1, T1, l2, T2, l3, T3);
                value = this._mapResult.get(this._keyResult);
            }
            if (value == null) {
                long time = System.nanoTime();
                double result = this._delegate.computeThreeFailuresExcluded(tm, l1, T1, l2, T2, l3, T3);
                time = System.nanoTime() - time;
                value = new ResultValue(new ResultKey(tm, l1, T1, l2, T2, l3, T3), result, time);
                this._mapResult.put(value._params, value);
                if (this._longResult == null || this._longResult._timeToCompute < time) {
                    this._longResult = value;
                }
                if (!(result >= 0.0) && this._naN_Count < this._naN_Limit) {
                    _LOG.info(this.printCurrentResult(result, tm, l1, T1, l2, T2, l3, T3));
                    ++this._naN_Count;
                }
            }
            return value._result;
        }
        double result = this._delegate.computeThreeFailuresExcluded(tm, l1, T1, l2, T2, l3, T3);
        if (!(result >= 0.0) && this._naN_Count < this._naN_Limit) {
            _LOG.info(this.printCurrentResult(result, tm, l1, T1, l2, T2, l3, T3));
            ++this._naN_Count;
        }
        return result;
    }

    static class ResultValue
    implements Comparable<ResultValue> {
        ResultKey _params;
        double _result;
        long _timeToCompute;

        public ResultValue(ResultKey params, double result, long time) {
            this._params = params;
            this._result = result;
            this._timeToCompute = time;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(512);
            sb.append("{");
            for (int i = 0; i < this._params._params.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this._params._params[i]);
            }
            sb.append("} => ");
            sb.append(this._result);
            sb.append(" : ");
            sb.append(this._timeToCompute);
            return sb.toString();
        }

        @Override
        public int compareTo(ResultValue o) {
            return -Double.compare(this._timeToCompute, o._timeToCompute);
        }
    }

    static class ResultKey {
        double[] _params;

        public ResultKey(double ... params) {
            this._params = params;
        }

        public void setParameters(double ... params) {
            this._params = params;
        }

        public int hashCode() {
            int hash = this._params.length;
            for (int i = 0; i < this._params.length; ++i) {
                long bits = Double.doubleToLongBits(this._params[i]);
                hash = hash * 7 + (int)(bits ^ bits >>> 32);
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof ResultKey) {
                ResultKey other = (ResultKey)obj;
                if (this._params.length != other._params.length) {
                    return false;
                }
                for (int i = 0; i < this._params.length; ++i) {
                    if (this._params[i] == other._params[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

