/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.Util;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.DBKTableModel;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanAttrAvg;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.ParamCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.export.Export;
import com.dassault.cecilia.plugin.faulttree.compute.pref.PrintExportMCS;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborDefaultRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public abstract class ExportAbstract
implements Export {
    private static Logger _LOG = Logger.getLogger(ExportAbstract.class.getPackage().getName());
    protected BooleanStore _store;
    protected PrintExportMCS _prefs;
    protected ParamCompute _parameters;
    protected boolean _forOneHour;
    protected ArborRenderer _renderer;
    Map<TypeConvert, Map<String, String>> _anonymousMap;

    protected ExportAbstract(BooleanStore store, ParamCompute parameters, PrintExportMCS prefs) {
        this._store = store;
        this._prefs = prefs;
        this._parameters = parameters;
        this._forOneHour = false;
        this._renderer = new ArborDefaultRenderer();
        if (this._prefs.getBooleanValue("Content.AnonymizeSelect")) {
            this.prepareAnonymous();
        }
    }

    public ExportAbstract setRenderer(ArborRenderer renderer, boolean forOneHour) {
        this._renderer = renderer;
        this._forOneHour = forOneHour;
        return this;
    }

    public boolean processWord(String fileName) {
        try {
            String outputPath = fileName.substring(0, fileName.lastIndexOf(File.separator));
            String fileNameSort = fileName.substring(fileName.lastIndexOf(File.separator) + 1, fileName.length());
            StringBuffer buffer = new StringBuffer(1024);
            buffer.append(System.getProperty("cecilia.export.wordxml.java", "java.exe -Xms128m -Xmx1024m"));
            buffer.append(" -DDataPath=");
            buffer.append(System.getProperty("cecilia.export.wordxml.path", "./core/plugins/docbook".replace('/', File.separatorChar)));
            buffer.append(" -DOutputPath=\"").append(outputPath).append("\"");
            buffer.append(" -DFileName=\"").append(fileNameSort).append("\"");
            buffer.append(" ");
            buffer.append(System.getProperty("cecilia.export.wordxml.jar", "-jar ./core/plugins/WordXml.jar".replace('/', File.separatorChar)));
            _LOG.finest("ExportAbstract::processWord cmdWord=\n" + buffer.toString());
            final Process p = Runtime.getRuntime().exec(buffer.toString());
            new Thread("Export:processWord - Out"){

                @Override
                public void run() {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            _LOG.fine(line);
                        }
                    }
                    catch (IOException e) {
                        _LOG.log(Level.FINEST, "", e);
                    }
                }
            }.start();
            new Thread("Export:processWord - Err"){

                @Override
                public void run() {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            _LOG.warning(line);
                        }
                    }
                    catch (IOException e) {
                        _LOG.log(Level.FINEST, "", e);
                    }
                }
            }.start();
            try {
                int result = p.waitFor();
                if (result == 0) {
                    return true;
                }
            }
            catch (InterruptedException e) {
                _LOG.log(Level.WARNING, "Interrupt ProcessWord", e);
            }
        }
        catch (IOException e) {
            _LOG.log(Level.WARNING, "IOException ProcessWord", e);
        }
        return false;
    }

    protected String exportOneAttribute(Attr attr) {
        StringBuffer text = new StringBuffer();
        text.append("'").append(this.convertName(attr.getKey().getName(), TypeConvert.ATTR)).append("'");
        if (attr.getKey().getType() != AttrType.ALIAS) {
            text.append("=[");
            if (attr.getKey().getType() == AttrType.NUMBER) {
                String value = attr.getValue().toString();
                try {
                    double dvalue = Double.parseDouble(value);
                    text.append(this._renderer.formatNumber(dvalue));
                }
                catch (NumberFormatException e) {
                    _LOG.log(Level.INFO, "Number attribute '" + attr.getKey().getName() + "' is not double", e);
                    text.append(value);
                }
            } else {
                text.append(attr.getValue());
            }
            text.append("]");
        }
        return text.toString();
    }

    protected int countMCSColumns() {
        int skipCols = 1;
        if (this._prefs.getBooleanValue("Fields.Number")) {
            ++skipCols;
        }
        if (this._prefs.getBooleanValue("Fields.Occurence")) {
            ++skipCols;
        }
        if (this._prefs.getBooleanValue("Fields.Comment")) {
            ++skipCols;
        }
        if (this._prefs.getBooleanValue("Fields.Law")) {
            ++skipCols;
        }
        if (this._prefs.getBooleanValue("Fields.Inspected")) {
            ++skipCols;
        }
        if (this._prefs.getBooleanValue("Fields.InflightTested")) {
            ++skipCols;
        }
        if (this._prefs.getBooleanValue("Fields.Properties")) {
            ++skipCols;
        }
        if (this._prefs.getBooleanValue("Fields.BTP")) {
            ++skipCols;
        }
        if (this._prefs.getBooleanValue("Fields.FMEA")) {
            ++skipCols;
        }
        return skipCols;
    }

    protected void exportScribeComment(SrbInputStream out, String comment) {
        char[] text = comment.toCharArray();
        for (int i = 0; i < comment.length(); ++i) {
            if (text[i] == '\n') continue;
            out.concat("" + text[i]);
        }
    }

    protected void exportScribeComment(SrbInputStream out, String comment, String format) {
        char[] text = comment.toCharArray();
        for (int i = 0; i < comment.length(); ++i) {
            if (text[i] != '\n') {
                out.concat("" + text[i]);
                continue;
            }
            if (i == comment.length() - 1) continue;
            out.concat(format);
        }
    }

    protected void exportScribeInline(SrbInputStream outScribe, String ress, String value) {
        if (value != null && !value.isEmpty()) {
            outScribe.concat(ress);
            if (ress.length() < 12) {
                outScribe.concat("@:@");
            } else {
                outScribe.concat(":");
            }
            outScribe.concat("<HP2>");
            outScribe.concat(value);
            outScribe.concat("<EHP2>\n");
            outScribe.concat(".br \n");
        }
    }

    protected void exportScribeBegining(SrbInputStream outScribe) {
        String warning;
        double averageFlightDuration;
        if (!this._prefs.getBooleanValue("Content.QAnalysis")) {
            return;
        }
        outScribe.concat("<H1>" + ResCompute.getString("KEY_0408") + "\n");
        outScribe.concat("<UL>\n");
        outScribe.concat("<LI>" + ResCompute.getString("KEY_0496") + "\n");
        outScribe.concat(".br \n");
        outScribe.concat(ResCompute.getString("DLG_RESULT_INFO_PROJECT") + "@:@<HP2>" + this._store.getInfo(BooleanStore.INFO_PROJECT));
        outScribe.concat("<EHP2>\n");
        outScribe.concat(".br \n");
        outScribe.concat(ResCompute.getString("DLG_RESULT_INFO_SYSTEM") + "@:@<HP2>" + this._store.getInfo(BooleanStore.INFO_SYSTEM));
        outScribe.concat("<EHP2>\n");
        outScribe.concat(".br \n");
        outScribe.concat(ResCompute.getString("DLG_RESULT_INFO_TREE") + "@:@<HP2>" + this._store.getInfo(BooleanStore.INFO_TREE));
        String version = this._store.getInfo(BooleanStore.INFO_VERSION);
        if (version != null && version.length() > 0) {
            outScribe.concat(" (" + version + ")");
        }
        outScribe.concat("<EHP2>\n");
        outScribe.concat(".br \n");
        String comment = this._store.getInfo(BooleanStore.INFO_TREE_COMMENT);
        if (comment != null && comment.length() > 0) {
            outScribe.concat("@@");
            this.exportScribeComment(outScribe, comment, "\n.br \n@@");
            outScribe.concat("\n");
            outScribe.concat(".br \n");
        }
        if ((comment = this._store.getInfo(BooleanStore.INFO_VERSION_COMMENT)) != null && comment.length() > 0) {
            outScribe.concat("@@");
            this.exportScribeComment(outScribe, comment, "\n.br \n@@");
            outScribe.concat("\n");
            outScribe.concat(".br \n");
        }
        String modelMBSA = this._store.getInfo(BooleanStore.INFO_MODEL_MBSA);
        String initialConfMBSA = this._store.getInfo(BooleanStore.INFO_INITIAL_CONF_MBSA);
        String targetMBSA = this._store.getInfo(BooleanStore.INFO_TARGET_MBSA);
        if (modelMBSA != null || initialConfMBSA != null || targetMBSA != null) {
            outScribe.concat("<LI>" + ResCompute.getString("DLG_RESULT_INFO_MBSA") + "\n");
            outScribe.concat(".br \n");
            this.exportScribeInline(outScribe, ResCompute.getString("DLG_RESULT_INFO_MODEL_MBSA"), modelMBSA);
            this.exportScribeInline(outScribe, ResCompute.getString("DLG_RESULT_INFO_INITIAL_CONF_MBSA"), initialConfMBSA);
            this.exportScribeInline(outScribe, ResCompute.getString("DLG_RESULT_INFO_TARGET_MBSA"), targetMBSA);
        }
        String createDate = this._store.getInfo(BooleanStore.INFO_VERSION_CREATE_DATE);
        String createBy = this._store.getInfo(BooleanStore.INFO_VERSION_CREATE_BY);
        String modifyDate = this._store.getInfo(BooleanStore.INFO_VERSION_MODIFY_DATE);
        String modifyBy = this._store.getInfo(BooleanStore.INFO_VERSION_MODIFY_BY);
        if (createDate != null && modifyDate != null && modifyBy != null) {
            outScribe.concat("<LI>" + ResMsgVoc.getString((String)"VOC_DATES") + "\n");
            outScribe.concat(".br \n");
            if (createBy != null) {
                outScribe.concat(ResMsgVoc.getString((String)"VOC_CREATION") + "@:@<HP2>" + ResMsgCore.msgFormat((String)"MSG_DATE_BY_USER", (Object[])new Object[]{createDate, createBy}) + "<EHP2>\n");
            } else {
                outScribe.concat(ResMsgVoc.getString((String)"VOC_CREATION") + "@:@<HP2>" + createDate + "<EHP2>\n");
            }
            outScribe.concat(".br \n");
            outScribe.concat(ResMsgVoc.getString((String)"VOC_MODIFICATION") + "@:@<HP2>" + ResMsgCore.msgFormat((String)"MSG_DATE_BY_USER", (Object[])new Object[]{modifyDate, modifyBy}) + "<EHP2>\n");
            outScribe.concat(".br \n");
        }
        BooleanNode root = this._store.getRoot();
        outScribe.concat("<LI>" + ResCompute.getString("KEY_0409") + "\n");
        outScribe.concat(".br \n");
        outScribe.concat(ResMsgVoc.getString((String)"VOC_NAME") + "@:@<HP2>" + this.convertName(root.getName(), TypeConvert.ROOT) + "<EHP2>\n");
        outScribe.concat(".br \n");
        String comment2 = this.convertComment((String)root.getInfo(Evt.KeyInfo.COMMENT, this._renderer));
        if (comment2 != null && comment2.length() > 0) {
            outScribe.concat("@@");
            this.exportScribeComment(outScribe, comment2, "\n.br \n@@");
            outScribe.concat("\n");
            outScribe.concat(".br \n");
        }
        this.exportScribeProbabilityRoot(outScribe, root);
        this.exportScribeComputeInformations(outScribe);
        outScribe.concat(".br \n");
        outScribe.concat("<LI>" + ResMsgVoc.getString((String)"VOC_FLIGHT_PHASE") + "\n");
        outScribe.concat(".br \n");
        if (((ParamComputeAbstract)this._parameters).getPostTreatmentAtRisk().booleanValue()) {
            outScribe.concat(ResMsgVoc.getString((String)"VOC_DURATION") + "@:@<HP2>" + this._renderer.formatMissionTime(((ParamComputeAbstract)this._parameters).getSpecificTime()) + "<EHP2> \n");
            outScribe.concat(".br \n");
            outScribe.concat(ResCompute.getString("PTF_EXPORT_PREVIOUS_TIME") + "@:@<HP2>" + this._renderer.formatMissionTime(this._parameters.getMissionTime()) + "<EHP2> \n");
            outScribe.concat(".br \n");
        } else {
            outScribe.concat(ResMsgVoc.getString((String)"VOC_DURATION") + "@:@<HP2>" + this._renderer.formatMissionTime(this._parameters.getMissionTime()) + "<EHP2> " + (this._forOneHour ? ResMsgArbor.getString((String)"KEY_0837") : "") + "\n");
            outScribe.concat(".br \n");
        }
        outScribe.concat(ResMsgArbor.getString((String)"KEY_0413") + "@:@<HP2> <EHP2>\n");
        outScribe.concat(".br \n");
        if (this._forOneHour && !Double.isNaN(averageFlightDuration = this._store.getAverageFlightDuration()) && averageFlightDuration > 0.0) {
            outScribe.concat("<LI>" + ResMsgObj.getString((String)"DLG_AVERAGEFLIGHT_EXPORT") + "\n");
            outScribe.concat(".br \n");
            outScribe.concat(ResMsgVoc.getString((String)"VOC_DURATION") + "@:@<HP2>" + this._renderer.formatMissionTime(averageFlightDuration) + "<EHP2>\n");
            outScribe.concat(".br \n");
        }
        if ((warning = this.convertWarning(this._store.getWarning())).length() > 0) {
            outScribe.concat("<LI>" + ResMsgVoc.getString((String)"VOC_WARNINGS") + "\n");
            outScribe.concat(".br \n");
            outScribe.concat("@@");
            this.exportScribeComment(outScribe, warning, "\n.br \n@@");
            outScribe.concat("\n");
            outScribe.concat(".br \n");
        }
        outScribe.concat("<EUL>\n");
        outScribe.concat(".sk 1\n");
    }

    protected abstract void exportScribeProbabilityRoot(SrbInputStream var1, BooleanNode var2);

    protected void exportScribeProbability(SrbInputStream outScribe, double prb) {
        if (prb != -1.0) {
            String computeParameter = "";
            TypeProbability typePr = this._parameters.getTypeProbability();
            switch (typePr) {
                case NONE: {
                    break;
                }
                case ARP1: 
                case ARP2: {
                    Collection<BooleanAttrAvg> attributeAverage = this._store.getAttributeAverage();
                    if (attributeAverage != null && attributeAverage.size() > 0) {
                        BooleanAttrAvg attAvg = attributeAverage.iterator().next();
                        StringBuffer buffer = new StringBuffer(1024);
                        buffer.append(" (").append(typePr.getLabel());
                        buffer.append(" (").append(this.convertName(attAvg.getAttributeKey().getName(), TypeConvert.ATTR)).append(")");
                        buffer.append(")");
                        computeParameter = buffer.toString();
                        break;
                    }
                }
                default: {
                    computeParameter = new StringBuffer(typePr.getLabel().length() + 5).append(" (").append(typePr.getLabel()).append(")").toString();
                }
            }
            outScribe.concat(ResMsgVoc.getString((String)"VOC_PROBABILITY") + "@:@<HP2>" + this._renderer.formatProbability(prb) + computeParameter + "<EHP2>\n");
        } else {
            outScribe.concat(ResMsgVoc.getString((String)"VOC_PROBABILITY") + "@:@<HP2>-<EHP2>\n");
        }
    }

    protected abstract void exportScribeComputeInformations(SrbInputStream var1);

    protected void exportScribeDSFConfiguration(SrbInputStream outScribe) {
        if (this._store.getDsfs().isEmpty()) {
            return;
        }
        outScribe.concat("<H1>" + ResCompute.getString("KEY_5003") + "\n");
        outScribe.concat("<TABLEAU>\n");
        outScribe.concat("<TABTIT>" + ResCompute.getString("KEY_5007") + "\n");
        outScribe.concat("<TABCOL>" + ResCompute.getString("KEY_5004") + "\n");
        outScribe.concat("<TABCOL>" + ResCompute.getString("KEY_5005") + "\n");
        outScribe.concat("<TABCOL>" + ResCompute.getString("KEY_5006") + "\n");
        outScribe.concat("<TABDEF CWIDTH = '40 40 8'   ALIGN = 'C C C'>\n");
        for (Map.Entry<String, Boolean> entryDsf : this._store.getDsfs().entrySet()) {
            String path = entryDsf.getKey();
            int posVersion = path.length();
            if (path.endsWith(")")) {
                posVersion = path.lastIndexOf(40);
            }
            int posTree = path.lastIndexOf(47, posVersion);
            String name = path.substring(posTree + 1, posVersion);
            outScribe.concat("<C>" + name + "\n");
            outScribe.concat("<C>" + path + "\n");
            if (entryDsf.getValue().booleanValue()) {
                outScribe.concat("<C>BTP\n");
                continue;
            }
            outScribe.concat("<C>ST\n");
        }
        outScribe.concat("<ETABLEAU>\n");
    }

    protected void exportScribeMCSEnd(SrbInputStream outScribe) {
        this.exportScribeMCSReminder(outScribe);
        this.exportScribeMCSToC(outScribe);
    }

    protected void exportScribeMCSReminderAdditionnalInformations(SrbInputStream outScribe) {
    }

    protected void exportScribeMCSReminder(SrbInputStream outScribe) {
        if (!this._prefs.getBooleanValue("Content.Reminder")) {
            return;
        }
        outScribe.concat("<H1>" + ResCompute.getString("KEY_0461") + "\n");
        outScribe.concat("<UL>\n");
        outScribe.concat("<LI>" + ResCompute.getString("KEY_0444") + " : \n");
        outScribe.concat(".br \n");
        outScribe.concat(".sk 1\n");
        outScribe.concat("U @:@" + ResCompute.getString("KEY_0445") + "\n");
        outScribe.concat(".br \n");
        outScribe.concat("ST@:@" + ResCompute.getString("KEY_0446") + "\n");
        outScribe.concat(".br \n");
        outScribe.concat("EI@:@" + ResCompute.getString("KEY_0447") + "\n");
        outScribe.concat(".br \n");
        outScribe.concat("ITE@:@" + ResCompute.getString("KEY_0448") + "\n");
        outScribe.concat(".br \n");
        outScribe.concat("GSR@:@" + ResCompute.getString("KEY_0449") + "\n");
        outScribe.concat(".br \n");
        outScribe.concat("DSF@:@" + ResCompute.getString("KEY_5008") + "\n");
        outScribe.concat(".br \n");
        outScribe.concat("<LI>" + ResCompute.getString("KEY_0452") + " " + ResCompute.getString("KEY_0410") + "\n");
        outScribe.concat(".br \n");
        outScribe.concat(".sk 1\n");
        outScribe.concat("<LI>" + ResCompute.getString("KEY_0453") + " :\n");
        outScribe.concat(".br \n");
        outScribe.concat(".sk 1\n");
        outScribe.concat("mo@:@" + ResCompute.getString("KEY_0454") + "\n");
        outScribe.concat(".br \n");
        outScribe.concat("d @:@" + ResCompute.getString("KEY_0455") + "\n");
        outScribe.concat(".br \n");
        outScribe.concat("h @:@" + ResCompute.getString("KEY_0456") + "\n");
        outScribe.concat(".br \n");
        outScribe.concat("mn@:@" + ResCompute.getString("KEY_0457") + "\n");
        outScribe.concat(".br \n");
        outScribe.concat("s @:@" + ResCompute.getString("KEY_0458") + "\n");
        outScribe.concat(".br \n");
        outScribe.concat(".sk 1\n");
        this.exportScribeMCSReminderAdditionnalInformations(outScribe);
        outScribe.concat("<EUL>\n");
    }

    protected void exportScribeMCSToC(SrbInputStream outScribe) {
        if (this._prefs.getBooleanValue("Content.TableOfContents")) {
            outScribe.concat("<EGDOC>1\n");
        } else {
            outScribe.concat("<EGDOC>0\n");
        }
    }

    protected List<String> getDBookTabHeader(PrintExportMCS prefs) {
        ArrayList<String> columns = new ArrayList<String>();
        if (prefs.getBooleanValue("Fields.Number")) {
            columns.add(ResMsgVoc.getString((String)"VOC_NUMBER"));
        }
        if (prefs.getBooleanValue("Fields.Occurence")) {
            columns.add(ResMsgVoc.getString((String)"VOC_OCCURRENCE"));
        }
        columns.add(ResMsgVoc.getString((String)"VOC_NAME"));
        if (prefs.getBooleanValue("Fields.Comment")) {
            columns.add(ResMsgVoc.getString((String)"VOC_COMMENT"));
        }
        if (prefs.getBooleanValue("Fields.Law")) {
            columns.add(ResMsgVoc.getString((String)"VOC_LAW"));
        }
        if (prefs.getBooleanValue("Fields.Inspected")) {
            columns.add(ResMsgVoc.getString((String)"VOC_PERIODICITY"));
        }
        if (prefs.getBooleanValue("Fields.InflightTested")) {
            columns.add(ResMsgVoc.getString((String)"VOC_EXPORURE_TIME"));
        }
        if (prefs.getBooleanValue("Fields.Properties")) {
            columns.add(ResMsgVoc.getString((String)"VOC_PROPERTIES"));
        }
        if (prefs.getBooleanValue("Fields.BTP")) {
            columns.add(ResMsgVoc.getString((String)"VOC_FRB"));
        }
        if (prefs.getBooleanValue("Fields.FMEA")) {
            columns.add(ResMsgVoc.getString((String)"VOC_FMEA"));
        }
        if (prefs.getBooleanValue("Fields.Attributes")) {
            columns.add(ResMsgVoc.getString((String)"VOC_ATTRIBUTES"));
        }
        return columns;
    }

    protected void printDBookComment(List<String> row, String comment) {
        String s = "";
        char[] text = comment.toCharArray();
        for (int i = 0; i < comment.length(); ++i) {
            if (text[i] == '\n') continue;
            s = s + text[i];
        }
        row.add(s);
    }

    protected void printInline(DBKOutput xmlWriter, String title, String value) throws IOException {
        if (value != null && !value.isEmpty()) {
            xmlWriter.write("<para>", false);
            xmlWriter.write(new StringBuilder(1024).append(title).append(" : ").append(value).toString(), true);
            xmlWriter.write("</para>\n", false);
        }
    }

    protected void exportDocBookBegining(DBKOutput xmlWriter) throws IOException {
        String warning;
        double averageFlightDuration;
        StringBuilder buffer;
        String commentVersion;
        if (!this._prefs.getBooleanValue("Content.QAnalysis")) {
            return;
        }
        xmlWriter.writeSection(1, ResCompute.getString("KEY_0408"));
        xmlWriter.writeSection(2, ResCompute.getString("KEY_0496"));
        this.printInline(xmlWriter, ResCompute.getString("DLG_RESULT_INFO_PROJECT"), this._store.getInfo(BooleanStore.INFO_PROJECT));
        this.printInline(xmlWriter, ResCompute.getString("DLG_RESULT_INFO_SYSTEM"), this._store.getInfo(BooleanStore.INFO_SYSTEM));
        String version = this._store.getInfo(BooleanStore.INFO_VERSION);
        if (version == null) {
            version = "";
        } else if (!version.isEmpty()) {
            version = " (" + version + ")";
        }
        this.printInline(xmlWriter, ResCompute.getString("DLG_RESULT_INFO_TREE"), this._store.getInfo(BooleanStore.INFO_TREE) + version);
        String commentTree = this._store.getInfo(BooleanStore.INFO_TREE_COMMENT);
        if (commentTree != null && commentTree.isEmpty()) {
            commentTree = null;
        }
        if ((commentVersion = this._store.getInfo(BooleanStore.INFO_VERSION_COMMENT)) != null && commentVersion.isEmpty()) {
            commentVersion = null;
        }
        if (commentTree != null && commentVersion != null) {
            xmlWriter.write("<para>", false);
            buffer = new StringBuilder(commentTree.length() + 256);
            buffer.append(ResMsgVoc.msgFormat((String)"FRM_COMMENT_OF", (Object[])new Object[]{ResMsgVoc.getString((String)"VOC_TREE")}));
            xmlWriter.write(buffer.append(" : ").append(commentTree).toString(), true);
            xmlWriter.write("</para>\n", false);
            xmlWriter.write("<para>", false);
            buffer = new StringBuilder(commentVersion.length() + 256);
            buffer.append(ResMsgVoc.msgFormat((String)"FRM_COMMENT_OF", (Object[])new Object[]{ResMsgVoc.getString((String)"VOC_VERSION")}));
            xmlWriter.write(buffer.append(" : ").append(commentVersion).toString(), true);
            xmlWriter.write("</para>\n", false);
        } else if (commentTree != null) {
            xmlWriter.write("<para>", false);
            buffer = new StringBuilder(commentTree.length() + 256);
            buffer.append(ResMsgVoc.getString((String)"VOC_COMMENT")).append(" : ").append(commentTree);
            xmlWriter.write(buffer.toString(), true);
            xmlWriter.write("</para>\n", false);
        } else if (commentVersion != null) {
            xmlWriter.write("<para>", false);
            buffer = new StringBuilder(commentVersion.length() + 256);
            buffer.append(ResMsgVoc.getString((String)"VOC_COMMENT")).append(" : ").append(commentVersion);
            xmlWriter.write(buffer.toString(), true);
            xmlWriter.write("</para>\n", false);
        }
        xmlWriter.writeEndSection(2);
        String modelMBSA = this._store.getInfo(BooleanStore.INFO_MODEL_MBSA);
        String initialConfMBSA = this._store.getInfo(BooleanStore.INFO_INITIAL_CONF_MBSA);
        String targetMBSA = this._store.getInfo(BooleanStore.INFO_TARGET_MBSA);
        if (modelMBSA != null || initialConfMBSA != null || targetMBSA != null) {
            xmlWriter.writeSection(2, ResCompute.getString("DLG_RESULT_INFO_MBSA"));
            this.printInline(xmlWriter, ResCompute.getString("DLG_RESULT_INFO_MODEL_MBSA"), modelMBSA);
            this.printInline(xmlWriter, ResCompute.getString("DLG_RESULT_INFO_INITIAL_CONF_MBSA"), initialConfMBSA);
            this.printInline(xmlWriter, ResCompute.getString("DLG_RESULT_INFO_TARGET_MBSA"), targetMBSA);
            xmlWriter.writeEndSection(2);
        }
        String createDate = this._store.getInfo(BooleanStore.INFO_VERSION_CREATE_DATE);
        String createBy = this._store.getInfo(BooleanStore.INFO_VERSION_CREATE_BY);
        String modifyDate = this._store.getInfo(BooleanStore.INFO_VERSION_MODIFY_DATE);
        String modifyBy = this._store.getInfo(BooleanStore.INFO_VERSION_MODIFY_BY);
        if (createDate != null && createBy != null || modifyDate != null && modifyBy != null) {
            xmlWriter.writeSection(2, ResMsgVoc.getString((String)"VOC_DATES"));
            if (createDate != null) {
                xmlWriter.write("<para>", false);
                if (createBy != null) {
                    xmlWriter.write(ResMsgVoc.getString((String)"VOC_CREATION") + " : " + ResMsgCore.msgFormat((String)"MSG_DATE_BY_USER", (Object[])new Object[]{createDate, createBy}), true);
                } else {
                    xmlWriter.write(ResMsgVoc.getString((String)"VOC_CREATION") + " : " + createDate, true);
                }
                xmlWriter.write("</para>\n", false);
            }
            if (modifyDate != null && modifyBy != null) {
                this.printInline(xmlWriter, ResMsgVoc.getString((String)"VOC_MODIFICATION"), ResMsgCore.msgFormat((String)"MSG_DATE_BY_USER", (Object[])new Object[]{modifyDate, modifyBy}));
            }
            xmlWriter.writeEndSection(2);
        }
        BooleanNode root = this._store.getRoot();
        xmlWriter.writeSection(2, ResCompute.getString("KEY_0409"));
        this.printInline(xmlWriter, ResMsgVoc.getString((String)"VOC_NAME"), this.convertName(root.getName(), TypeConvert.ROOT));
        String comment = this.convertComment((String)root.getInfo(Evt.KeyInfo.COMMENT, this._renderer));
        if (comment != null && comment.length() > 0) {
            xmlWriter.write("<para>", false);
            StringBuilder buffer2 = new StringBuilder(comment.length() + 256);
            buffer2.append(ResMsgVoc.getString((String)"VOC_COMMENT")).append(" : ").append(comment);
            xmlWriter.write(buffer2.toString(), true);
            xmlWriter.write("</para>\n", false);
        }
        this.exportDocBookProbabilityRoot(xmlWriter, root);
        this.exportDocBookComputeInformations(xmlWriter);
        xmlWriter.writeEndSection(2);
        xmlWriter.writeSection(2, ResMsgVoc.getString((String)"VOC_FLIGHT_PHASE"));
        if (((ParamComputeAbstract)this._parameters).getPostTreatmentAtRisk().booleanValue()) {
            this.printInline(xmlWriter, ResMsgVoc.getString((String)"VOC_DURATION"), this._renderer.formatMissionTime(((ParamComputeAbstract)this._parameters).getSpecificTime()));
            this.printInline(xmlWriter, ResCompute.getString("PTF_EXPORT_PREVIOUS_TIME"), this._renderer.formatMissionTime(this._parameters.getMissionTime()));
        } else {
            this.printInline(xmlWriter, ResMsgVoc.getString((String)"VOC_DURATION"), this._renderer.formatMissionTime(this._parameters.getMissionTime()) + (this._forOneHour ? ResMsgArbor.getString((String)"KEY_0837") : ""));
        }
        this.printInline(xmlWriter, ResMsgArbor.getString((String)"KEY_0413"), " ");
        xmlWriter.writeEndSection(2);
        if (this._forOneHour && !Double.isNaN(averageFlightDuration = this._store.getAverageFlightDuration()) && averageFlightDuration > 0.0) {
            xmlWriter.writeSection(2, ResMsgObj.getString((String)"DLG_AVERAGEFLIGHT_EXPORT"));
            this.printInline(xmlWriter, ResMsgVoc.getString((String)"VOC_DURATION"), this._renderer.formatMissionTime(averageFlightDuration));
            xmlWriter.writeEndSection(2);
        }
        if ((warning = this.convertWarning(this._store.getWarning())).length() > 0) {
            xmlWriter.writeSection(2, ResMsgVoc.getString((String)"VOC_WARNINGS"));
            xmlWriter.write("<para>", false);
            xmlWriter.write(warning, true);
            xmlWriter.write("</para>", false);
            xmlWriter.writeEndSection(2);
        }
        xmlWriter.writeEndSection(1);
    }

    protected abstract void exportDocBookProbabilityRoot(DBKOutput var1, BooleanNode var2) throws IOException;

    protected void exportDocBookProbability(DBKOutput xmlWriter, double prb) throws IOException {
        if (prb != -1.0) {
            xmlWriter.write("<para>", false);
            String computeParameter = "";
            TypeProbability typePr = this._parameters.getTypeProbability();
            switch (typePr) {
                case NONE: {
                    break;
                }
                case ARP1: 
                case ARP2: {
                    Collection<BooleanAttrAvg> attributeAverage = this._store.getAttributeAverage();
                    if (attributeAverage != null && attributeAverage.size() > 0) {
                        BooleanAttrAvg attAvg = attributeAverage.iterator().next();
                        StringBuffer buffer = new StringBuffer(1024);
                        buffer.append(" (").append(typePr.getLabel());
                        buffer.append(" (").append(this.convertName(attAvg.getAttributeKey().getName(), TypeConvert.ATTR)).append(")");
                        buffer.append(")");
                        computeParameter = buffer.toString();
                        break;
                    }
                }
                default: {
                    computeParameter = new StringBuffer(typePr.getLabel().length() + 5).append(" (").append(typePr.getLabel()).append(")").toString();
                }
            }
            xmlWriter.write(ResMsgVoc.getString((String)"VOC_PROBABILITY") + " : " + this._renderer.formatProbability(prb) + computeParameter, true);
            xmlWriter.write("</para>\n", false);
        } else {
            xmlWriter.write("<para>", false);
            xmlWriter.write(ResMsgVoc.getString((String)"VOC_PROBABILITY") + " : - ", true);
            xmlWriter.write("</para>\n", false);
        }
    }

    protected abstract void exportDocBookComputeInformations(DBKOutput var1) throws IOException;

    protected void exportDocBookDSFConfiguration(DBKOutput xmlWriter) throws IOException {
        if (this._store.getDsfs().isEmpty()) {
            return;
        }
        xmlWriter.writeSection(1, ResCompute.getString("KEY_5003"));
        ArrayList dsfRows = new ArrayList();
        for (Map.Entry<String, Boolean> entryDsf : this._store.getDsfs().entrySet()) {
            String path = entryDsf.getKey();
            int posVersion = path.length();
            if (path.endsWith(")")) {
                posVersion = path.lastIndexOf(40);
            }
            int posTree = path.lastIndexOf(47, posVersion);
            String name = path.substring(posTree + 1, posVersion);
            ArrayList<String> row = new ArrayList<String>();
            row.add(name);
            row.add(path);
            if (entryDsf.getValue().booleanValue()) {
                row.add("BTP");
            } else {
                row.add("ST");
            }
            dsfRows.add(row);
        }
        ArrayList<String> listDfs = new ArrayList<String>();
        listDfs.add(ResCompute.getString("KEY_5004"));
        listDfs.add(ResCompute.getString("KEY_5005"));
        listDfs.add(ResCompute.getString("KEY_5006"));
        DBKTableModel tableModel = new DBKTableModel(dsfRows, listDfs, DBKTableModel.DataType.OBJECTS);
        xmlWriter.insertTable(tableModel);
        xmlWriter.writeEndSection(1);
    }

    protected void exportDocBookEnd(DBKOutput xmlWriter) throws IOException {
        this.exportDocBookMCSReminder(xmlWriter);
    }

    protected void exportDocBookMCSReminderAdditionnalInformations(DBKOutput xmlWriter) throws IOException {
    }

    protected void exportDocBookMCSReminder(DBKOutput xmlWriter) throws IOException {
        if (!this._prefs.getBooleanValue("Content.Reminder")) {
            return;
        }
        xmlWriter.writeSection(1, ResCompute.getString("KEY_0461"));
        xmlWriter.write("<para>", false);
        xmlWriter.write(ResCompute.getString("KEY_0444") + " : ", true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("<para>", false);
        xmlWriter.write("U   : " + ResCompute.getString("KEY_0445"), true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("<para>", false);
        xmlWriter.write("ST  : " + ResCompute.getString("KEY_0446"), true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("<para>", false);
        xmlWriter.write("EI  : " + ResCompute.getString("KEY_0447"), true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("<para>", false);
        xmlWriter.write("ITE : " + ResCompute.getString("KEY_0448"), true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("<para>", false);
        xmlWriter.write("GSR : " + ResCompute.getString("KEY_0449"), true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("<para>", false);
        xmlWriter.write("DSF : " + ResCompute.getString("KEY_5008"), true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("<para>", false);
        xmlWriter.write(ResCompute.getString("KEY_0452") + " " + ResCompute.getString("KEY_0410"), true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("<para>", false);
        xmlWriter.write(ResCompute.getString("KEY_0453") + " : ", true);
        xmlWriter.write("</para>", false);
        xmlWriter.write("<para>", false);
        xmlWriter.write("mo : " + ResCompute.getString("KEY_0454"), true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("<para>", false);
        xmlWriter.write("d  : " + ResCompute.getString("KEY_0455"), true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("<para>", false);
        xmlWriter.write("h  : " + ResCompute.getString("KEY_0456"), true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("<para>", false);
        xmlWriter.write("mn : " + ResCompute.getString("KEY_0457"), true);
        xmlWriter.write("</para>\n", false);
        xmlWriter.write("<para>", false);
        xmlWriter.write("s  : " + ResCompute.getString("KEY_0458"), true);
        xmlWriter.write("</para>\n", false);
        this.exportDocBookMCSReminderAdditionnalInformations(xmlWriter);
        xmlWriter.writeEndSection(1);
    }

    protected void exportXMLHeader(Appendable writer, String header) throws IOException {
        Export.Helper.exportXMLDtd(writer);
        writer.append("<EXPORT VERSION='5.1'>\n");
        writer.append("\t<" + header + ">\n");
        writer.append("\t\t<IDENTIFICATION_LIST ");
        double proba = this._store.getRoot().getProbability();
        if (proba != -1.0) {
            writer.append(" PROBABILITY=\"" + this._renderer.formatProbability(proba) + "\"");
        }
        writer.append(" DURATION=\"" + this._parameters.getMissionTimeH() + "\"");
        if (this._forOneHour) {
            writer.append(" ISREDUCETOFLYHOUR=\"true\"");
        }
        writer.append("></IDENTIFICATION_LIST>\n");
        this.exportXMLIdentificationProject(writer, true, "\t\t");
        this.exportXMLIdentificationSystem(writer, true, "\t\t\t");
        this.exportXMLIdentificationTree(writer, true, false, "\t\t\t\t");
    }

    protected void exportXMLIdentificationProject(Appendable writer, boolean header, String indent) throws IOException {
        if (header) {
            writer.append(indent).append("<PROJECT>").append("\n");
        }
        writer.append(indent).append("\t<IDENTIFICATION NAME=\"").append(this._store.getInfo(BooleanStore.INFO_PROJECT)).append("\"");
        writer.append(" VERSION=\"1\"").append(" RELEASE=\"0\"");
        writer.append(" OWNER=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_PROJECT_OWNER))).append("\"");
        writer.append(" GROUP=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_PROJECT_GROUP))).append("\"");
        writer.append(" CREATION_DATE=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_PROJECT_CREATE_DATE))).append("\"");
        writer.append(" UPDATE_DATE=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_PROJECT_CREATE_DATE))).append("\"");
        writer.append(" GROUP_ACCESS=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_PROJECT_ACCESS_GROUP))).append("\"");
        writer.append(" OTHER_ACCESS=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_PROJECT_ACCESS_OTHER))).append("\"");
        writer.append("></IDENTIFICATION>").append("\n");
    }

    protected void exportXMLIdentificationSystem(Appendable writer, boolean header, String indent) throws IOException {
        if (header) {
            writer.append(indent).append("<SYSTEM>").append("\n");
        }
        writer.append(indent).append("\t<IDENTIFICATION NAME=\"").append(this._store.getInfo(BooleanStore.INFO_SYSTEM)).append("\"");
        writer.append(" VERSION=\"1\"").append(" RELEASE=\"0\"");
        writer.append(" OWNER=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_SYSTEM_OWNER))).append("\"");
        writer.append(" GROUP=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_SYSTEM_GROUP))).append("\"");
        writer.append(" GROUP_ACCESS=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_SYSTEM_ACCESS_GROUP))).append("\"");
        writer.append(" OTHER_ACCESS=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_SYSTEM_ACCESS_OTHER))).append("\"");
        writer.append(" CREATION_DATE=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_SYSTEM_CREATE_DATE))).append("\"");
        writer.append(" UPDATE_DATE=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_SYSTEM_CREATE_DATE))).append("\"");
        writer.append("></IDENTIFICATION>").append("\n");
    }

    protected void exportXMLIdentificationTree(Appendable writer, boolean header, boolean withCriticity, String indent) throws IOException {
        if (header) {
            String criticity;
            writer.append(indent).append("<TREE");
            writer.append(" CREATION_DATE=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_TREE_CREATE_DATE))).append("\"");
            if (withCriticity && (criticity = this._store.getInfo(BooleanStore.INFO_CRITICITY)) != null) {
                writer.append(" CRITICITY=\"").append(Util.formatStringForXml((String)criticity)).append("\"");
            }
            writer.append(">\n");
        }
        writer.append(indent).append("\t<IDENTIFICATION NAME=\"").append(this._store.getInfo(BooleanStore.INFO_TREE)).append("\"");
        writer.append(" VERSION=\"1\"").append(" RELEASE=\"0\"");
        writer.append(" OWNER=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_TREE_OWNER))).append("\"");
        writer.append(" GROUP=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_TREE_GROUP))).append("\"");
        writer.append(" GROUP_ACCESS=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_TREE_ACCESS_GROUP))).append("\"");
        writer.append(" OTHER_ACCESS=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_TREE_ACCESS_OTHER))).append("\"");
        writer.append(" CREATION_DATE=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_VERSION_CREATE_DATE))).append("\"");
        writer.append(" UPDATE_DATE=\"").append(Util.formatStringForXml((String)this._store.getInfo(BooleanStore.INFO_VERSION_MODIFY_DATE))).append("\"");
        String comment = this._store.getInfo(BooleanStore.INFO_VERSION_COMMENT);
        if (comment != null && comment.length() > 0) {
            writer.append(" COMMENT=\"").append(Util.formatStringForXml((String)comment)).append("\"");
        }
        writer.append("></IDENTIFICATION>").append("\n");
    }

    protected void exportXMLFooter(Appendable writer, String header) throws IOException {
        writer.append("\t\t\t\t</TREE>\n");
        writer.append("\t\t\t</SYSTEM>\n");
        writer.append("\t\t</PROJECT>\n");
        writer.append("\t</" + header + ">\n");
        writer.append("</EXPORT>\n");
    }

    public static String getCurrentDateAsDDMMYYYY() {
        SimpleDateFormat dateformat = (SimpleDateFormat)DateFormat.getDateInstance(3);
        return dateformat.format(new Date());
    }

    protected void prepareAnonymous() {
        this._anonymousMap = new LinkedHashMap<TypeConvert, Map<String, String>>();
        BooleanNode var = this._store.getRoot();
        this.convertName(var.getName(), TypeConvert.ROOT);
        int nbrLeaves = this._store.getNbrLeaves();
        for (int i = 0; i < nbrLeaves; ++i) {
            this.convertName(this._store.getLeaf(i).getName(), TypeConvert.EVT);
        }
    }

    protected String convertName(String name) {
        return this.convertName(name, TypeConvert.EVT);
    }

    protected String convertName(String name, TypeConvert type) {
        if (this._anonymousMap != null && type != TypeConvert.ATTR) {
            String value;
            Map<String, String> map = this._anonymousMap.get((Object)type);
            if (map == null) {
                map = new LinkedHashMap<String, String>();
                this._anonymousMap.put(type, map);
            }
            if ((value = map.get(name)) == null) {
                value = type._base + (map.size() + 1);
                map.put(name, value);
            }
            return value;
        }
        return name;
    }

    protected String convertComment(String comment) {
        if (this._anonymousMap != null) {
            return "";
        }
        return comment;
    }

    protected String convertWarning(String warning) {
        if (this._anonymousMap == null) {
            return warning;
        }
        if (warning == null) {
            return warning;
        }
        if (warning.isEmpty()) {
            return warning;
        }
        StringBuilder buffer = new StringBuilder(warning.length());
        StringTokenizer stLine = new StringTokenizer(warning, "\n", true);
        while (stLine.hasMoreTokens()) {
            String tok = stLine.nextToken();
            if (tok.startsWith("\n")) {
                buffer.append(tok);
                continue;
            }
            if (tok.startsWith("\t") || tok.startsWith(" \t") || tok.startsWith("  \t")) {
                StringTokenizer stEvt = new StringTokenizer(tok, ",");
                boolean first = true;
                while (stEvt.hasMoreTokens()) {
                    String evt = stEvt.nextToken();
                    buffer.append(first ? " \t" : ", ");
                    first = false;
                    if (evt.endsWith("...")) {
                        buffer.append(evt);
                        continue;
                    }
                    buffer.append(this.convertName(evt.trim()));
                }
                continue;
            }
            buffer.append(tok);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateAnonymousReport(File result, Component ownerComponent) {
        if (this._anonymousMap == null) {
            return;
        }
        if (!this._prefs.getBooleanValue("Content.AnonymizeTrace")) {
            return;
        }
        File reportFile = result;
        try {
            reportFile = new File(result.getParentFile(), result.getName() + ".csv");
            try (Writer output = null;){
                output = new BufferedWriter(new FileWriter(reportFile));
                for (TypeConvert type : this._anonymousMap.keySet()) {
                    for (Map.Entry<String, String> entry : this._anonymousMap.get((Object)type).entrySet()) {
                        output.append(type._csvType).append(";").append(entry.getValue()).append(";").append(entry.getKey()).append("\n");
                    }
                }
                output.flush();
            }
        }
        catch (Exception e) {
            _LOG.log(Level.FINE, "Exception during generate anonymous report", e);
            StringBuffer buffer = new StringBuffer();
            buffer.append(ResMsgCore.getString((String)"FILE_ERROR_SAVE"));
            buffer.append(reportFile).append("\n").append(e.getMessage());
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)ownerComponent), buffer.toString(), JOptionCecilia.getTopTitleOf((Component)ownerComponent), 0);
        }
    }

    public boolean verifyAnonymousReport(File result, Component ownerComponent) {
        if (this._anonymousMap == null) {
            return true;
        }
        if (!this._prefs.getBooleanValue("Content.AnonymizeTrace")) {
            return true;
        }
        File file = new File(result.getParentFile(), result.getName() + ".csv");
        if (!file.exists()) {
            return true;
        }
        int confirmResult = JOptionPane.showConfirmDialog(ownerComponent, ResMsgCore.msgFormat((String)"FILE_MSG_EXIST_FRM", (Object[])new Object[]{file}), JOptionCecilia.getTopTitleOf((Component)ownerComponent), 0);
        if (confirmResult != 0) {
            return false;
        }
        try {
            if (!file.delete()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(ResMsgCore.getString((String)"FILE_ERROR_WRITE_ACCESS"));
                buffer.append("\n").append(file);
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)ownerComponent), buffer.toString(), JOptionCecilia.getTopTitleOf((Component)ownerComponent), 0);
                return false;
            }
        }
        catch (Exception e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(ResMsgCore.getString((String)"FILE_ERROR_WRITE_ACCESS"));
            buffer.append("\n").append(file).append("\n").append(e.getMessage());
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)ownerComponent), buffer.toString(), JOptionCecilia.getTopTitleOf((Component)ownerComponent), 0);
            return false;
        }
        return true;
    }

    protected static enum TypeConvert {
        EVT("E", "FaultTree.Event"),
        ROOT("R", "FaultTree.Root"),
        ATTR("attr", "General.Attribute");

        String _base;
        String _csvType;

        private TypeConvert(String base, String csvType) {
            this._base = base;
            this._csvType = csvType;
        }
    }
}

