/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.swing.DlgPanelTime;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class ArborDefaultRenderer
implements ArborRenderer {
    private DecimalFormat _format = new DecimalFormat("0.000E00", new DecimalFormatSymbols(Locale.ENGLISH));

    @Override
    public Color getColor(ArborRenderer.DisplayColor type) {
        switch (type) {
            case FGExtern: {
                return Color.red;
            }
            case FGCCF: 
            case FGOther: {
                return Color.black;
            }
            case BGNormalSelectedLast: {
                return Color.gray;
            }
            case BGNormalSelected: {
                return Color.lightGray;
            }
            case BGTrue: {
                return Color.green;
            }
            case BGFalse: {
                return Color.red;
            }
            case FGError: {
                return Color.red;
            }
        }
        return Color.white;
    }

    @Override
    public String formatNumber(double value) {
        return this._format.format(value);
    }

    @Override
    public String formatProbability(double value) {
        if (value <= 0.0) {
            return "-";
        }
        if (Double.isNaN(value)) {
            return "-";
        }
        if (value > 1.0) {
            value = 1.0;
        }
        return this._format.format(value);
    }

    @Override
    public double convertProbability(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        if (value > 1.0) {
            return 1.0;
        }
        return value;
    }

    @Override
    public String formatMissionTime(double timeSec) {
        return DlgPanelTime.formatMissionTime((double)timeSec);
    }

    @Override
    public boolean isAltRenderer() {
        return false;
    }
}

