/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBookUtility;
import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.cecilia.pref.PrintPreviewPrefsDlg;
import com.dassault.cecilia.core.cecilia.print.ListProcessorJavaInteractive;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.PlugModel;
import com.dassault.cecilia.core.plugin.PlugPanelExtend;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.pluginmanager.ExtendedPlugable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import com.dassault.cecilia.core.swing.tree.TreeTable;
import com.dassault.cecilia.dbobj.wrap.PageableThread;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.FileUtility;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.CAAItem;
import com.dassault.cecilia.plugin.faulttree.compute.CAASelector;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.export.ExportCAA;
import com.dassault.cecilia.plugin.faulttree.compute.pref.PrintExportMCS;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilter;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSOrdersTable;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSOrdersTableModel;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSOrdersWithFilterTableModel;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSTableCellRendererOrder;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSTableCellRendererProbability;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class CAAItemPanel
extends JPanel
implements PlugPanelExtend,
MCSTablePanel.MCSFilterListener,
PlugModel,
ChangeListener {
    private static Logger _LOG = Logger.getLogger(CAAItemPanel.class.getPackage().getName());
    private static final String PROP_COMPUTE_CAA_WITHOUT_PROBABILITY = "cecilia.ft.compute.CAAWithoutProbability";
    private static final String PROP_COMPUTE_CAA_WITH_LIMITED = "cecilia.ft.compute.CAAWithLimited";
    CAAItem _rootItem;
    CAASelector _caaSelector;
    BooleanResult _originResult;
    ArborRenderer _renderer;
    boolean _withProbability;
    boolean _withCAAProbability;
    Plugable _plugable;
    InfoDatum _idatum;
    ParamComputeMCS _parameters;
    CAATreeModel _caaModel;
    CAATreeTable _caaTree;
    MCSTablePanel _mcsPanel;
    MCSOrdersWithFilterTableModel _mcsOrderModel;
    MCSOrdersTableModel _attrOrderModel;
    MCSFilter _currentFilter;
    private static ImageIcon[] __levelIcons = new ImageIcon[]{null, ResIcoCompute.getImageIcon("CAA_LEVEL_1"), ResIcoCompute.getImageIcon("CAA_LEVEL_2"), ResIcoCompute.getImageIcon("CAA_LEVEL_3"), ResIcoCompute.getImageIcon("CAA_LEVEL_4"), ResIcoCompute.getImageIcon("CAA_LEVEL_X")};
    JCheckBox _ctrlForOneHourReadOnly = null;
    String _title = null;

    public CAAItemPanel(CAAItem rootItem, CAASelector caaSelector, BooleanResult originResult, ArborRenderer renderer, boolean withProbability) {
        super(new BorderLayout());
        this._rootItem = rootItem;
        this._caaSelector = caaSelector;
        this._originResult = originResult;
        this._renderer = renderer;
        this._withProbability = withProbability;
        this._withCAAProbability = withProbability && !Boolean.getBoolean(PROP_COMPUTE_CAA_WITHOUT_PROBABILITY);
        this.create();
    }

    public void setExportUtilities(Plugable plugable, InfoDatum idatum, ParamComputeMCS parameters) {
        this._plugable = plugable;
        this._idatum = idatum;
        this._parameters = parameters;
    }

    private void create() {
        this._caaModel = new CAATreeModel();
        this._caaTree = new CAATreeTable(this._caaModel);
        this._caaTree.getTree().setRowHeight(ResIcoAbstract.getIconSize());
        this._mcsPanel = new MCSTablePanel(this._rootItem.getMCS(), this._renderer, this._withProbability, new TreeMap()){

            @Override
            protected boolean withFilter() {
                return false;
            }

            @Override
            protected boolean withLimited() {
                return Boolean.getBoolean(CAAItemPanel.PROP_COMPUTE_CAA_WITH_LIMITED);
            }
        };
        this._mcsPanel.addFilterListener(this);
        this._mcsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JTabbedPane infoPanel = new JTabbedPane();
        JPanel attributePanel = new JPanel(new GridBagLayout());
        this._attrOrderModel = new MCSOrdersTableModel(this._rootItem);
        this._attrOrderModel.setWithProbability(this._withCAAProbability);
        MCSOrdersTable attrOrderTable = new MCSOrdersTable((TableModel)this._attrOrderModel, this._renderer);
        attributePanel.add((Component)new JScrollPane(attrOrderTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        infoPanel.addTab(ResCompute.getString("CAA_ORDER_ATTRIBUTE"), attributePanel);
        JPanel orderPanel = new JPanel(new GridBagLayout());
        this._mcsOrderModel = new MCSOrdersWithFilterTableModel(this._rootItem.getMCS());
        this._mcsOrderModel.setWithProbability(this._withCAAProbability);
        MCSOrdersTable mcsOrderTable = new MCSOrdersTable((TableModel)this._mcsOrderModel, this._renderer);
        orderPanel.add((Component)new JScrollPane(mcsOrderTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        infoPanel.addTab(ResCompute.getString("CAA_ORDER_EVENT"), orderPanel);
        JSplitPane northSplit = new JSplitPane(1, new JScrollPane((Component)((Object)this._caaTree)), infoPanel);
        northSplit.setDividerLocation(400);
        JSplitPane splitPane = new JSplitPane(0, northSplit, this._mcsPanel);
        splitPane.setDividerLocation(150);
        this.add((Component)splitPane, "Center");
        this._caaTree.setRowSelectionInterval(0, 0);
    }

    @Override
    public void changeTable(MCS mcs, MCSFilter filter) {
        this._currentFilter = filter;
        this._mcsOrderModel.changeTable(mcs, filter);
    }

    public void setCtrlForOneHour(JCheckBox ctrl) {
        if (this._ctrlForOneHourReadOnly != null) {
            this._ctrlForOneHourReadOnly.removeChangeListener(this);
        }
        if (ctrl != null) {
            this._ctrlForOneHourReadOnly = ctrl;
            this._ctrlForOneHourReadOnly.addChangeListener(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this._ctrlForOneHourReadOnly == null) {
            return;
        }
        if (e.getSource() == this._ctrlForOneHourReadOnly) {
            this._caaTree.refreshValues();
            this._mcsOrderModel.fireTableChanged(new TableModelEvent(this._mcsOrderModel));
            this._attrOrderModel.fireTableChanged(new TableModelEvent(this._attrOrderModel));
            this._mcsPanel.refreshRenderer();
        }
    }

    public void trash() {
        if (this._ctrlForOneHourReadOnly != null) {
            this._ctrlForOneHourReadOnly.removeChangeListener(this);
        }
        this._rootItem = null;
        this._caaModel = null;
        this._caaTree = null;
    }

    public Component getPanel() {
        return this;
    }

    synchronized String getTitle() {
        if (this._title == null) {
            String config;
            StringBuffer sb = new StringBuffer();
            sb.append(ResCompute.getString("VOC_C_A_A_"));
            sb.append(" : ");
            BooleanStore store = this._rootItem.getStore();
            sb.append(store.getInfo(BooleanStore.INFO_PROJECT)).append("/");
            sb.append(store.getInfo(BooleanStore.INFO_SYSTEM)).append("/");
            sb.append(store.getInfo(BooleanStore.INFO_TREE)).append("(");
            sb.append(store.getInfo(BooleanStore.INFO_VERSION)).append(")");
            if (!store.getRoot().getName().equals(store.getInfo(BooleanStore.INFO_TREE))) {
                sb.append(" - ").append(store.getRoot().getName());
            }
            if ((config = store.getInfo(BooleanStore.INFO_CONFIGURATION)) != null && !config.equalsIgnoreCase("default")) {
                sb.append(" [").append(config).append("]");
            }
            this._title = sb.toString();
        }
        return this._title;
    }

    public String getInfo(String key) {
        if (key.equals("ppanel.title")) {
            return this.getTitle();
        }
        if (key.equals("ppanel.button")) {
            String config;
            StringBuffer sb = new StringBuffer();
            BooleanStore store = this._rootItem.getStore();
            String treeName = store.getInfo(BooleanStore.INFO_TREE);
            sb.append(treeName).append(";");
            sb.append(store.getInfo(BooleanStore.INFO_VERSION));
            String treeRoot = store.getRoot().getName();
            if (!treeRoot.equals(treeName)) {
                sb.append(" !");
            }
            if ((config = store.getInfo(BooleanStore.INFO_CONFIGURATION)) != null && !config.equalsIgnoreCase("default")) {
                sb.append(" [-]");
            }
            return sb.toString();
        }
        if (key.equals("ppanel.default.width")) {
            return "800";
        }
        if (key.equals("ppanel.default.height")) {
            return "600";
        }
        return key;
    }

    public Icon getIcon(String key) {
        if (key.equals("ppanel.icon")) {
            return ResIcoCompute.getImageIcon("CAA_LEVEL_X");
        }
        return null;
    }

    public boolean isExporting(String format) {
        return format.equalsIgnoreCase("DOCBOOK");
    }

    public File export(String format) {
        if (format.equalsIgnoreCase("DOCBOOK")) {
            return this.export(JChooserFileUtility.Type.DOCBOOK);
        }
        return null;
    }

    public boolean copy() {
        return false;
    }

    public boolean isPrinting() {
        return true;
    }

    public void print() {
        CAppl cAppl;
        Pageable fgPageable;
        PageFormat format = null;
        if (this._plugable instanceof ExtendedPlugable) {
            format = ((ExtendedPlugable)this._plugable).getPageFormat("docbook.file");
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        if (format == null) {
            format = job.defaultPage();
        }
        if ((fgPageable = this.createPageable(null, (cAppl = (CAppl)this._plugable.getAppl()).getPreferencies())) == null) {
            return;
        }
        try {
            job.setPageable(fgPageable);
            if (job.printDialog()) {
                try {
                    job.print();
                }
                catch (PrinterException e) {
                    _LOG.log(Level.FINE, "Probleme d'impression d'un resultat de MCS : " + this._rootItem.getStore().getInfo(BooleanStore.INFO_TREE), e);
                }
            }
        }
        catch (Throwable th) {
            _LOG.log(Level.WARNING, "Exception lors de l'impression d'un resultat de MCS : " + this._rootItem.getStore().getInfo(BooleanStore.INFO_TREE), th);
        }
    }

    public boolean isPreviewing() {
        return true;
    }

    public void preview() {
        if (!(this._plugable.getAppl() instanceof CAppl)) {
            return;
        }
        CAppl cAppl = (CAppl)this._plugable.getAppl();
        Pageable fgPageable = this.createPageable(cAppl.getPageFormat(), cAppl.getPreferencies());
        if (fgPageable == null) {
            return;
        }
        PrintPreviewPrefsDlg dlg = new PrintPreviewPrefsDlg(JOptionCecilia.getWindowOf((Component)this), fgPageable, cAppl, new PrefFieldsCategory[]{(PrefFieldsCategory)cAppl.getPreferencies().getOptions(PrintExportMCS.PREF_KEY)}){

            public void updatePreferencies() {
                this.setBook(CAAItemPanel.this.createPageable(this.getFormat(), this.getPreferencies()));
            }
        };
        dlg.setLocationRelativeTo((Component)JOptionCecilia.getWindowOf((Component)this));
        dlg.setVisible(true);
    }

    public Pageable createPageable(final PageFormat callFormat, final Preferencies preferencies) {
        PageableThread thread = new PageableThread(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Pageable doCreatePageable() {
                ListProcessorJavaInteractive pageable = null;
                PageFormat format = callFormat;
                if (format == null) {
                    if (CAAItemPanel.this._plugable instanceof ExtendedPlugable) {
                        format = ((ExtendedPlugable)CAAItemPanel.this._plugable).getPageFormat("docbook.file");
                    }
                    PrinterJob job = PrinterJob.getPrinterJob();
                    if (format == null) {
                        format = job.defaultPage();
                    }
                }
                try {
                    try (SrbInputStream scribe = new SrbInputStream("");){
                        ExportCAA export = new ExportCAA(CAAItemPanel.this._rootItem.getStore(), CAAItemPanel.this._parameters, CAAItemPanel.this._originResult, CAAItemPanel.this._rootItem, CAAItemPanel.this._caaSelector, (PrintExportMCS)preferencies.getOptions(PrintExportMCS.PREF_KEY), CAAItemPanel.this._currentFilter);
                        export.setRenderer(CAAItemPanel.this._renderer, false);
                        export.exportFormatScribe(scribe);
                    }
                    pageable = new ListProcessorJavaInteractive(scribe);
                    pageable.processScribeFile();
                    pageable.computePageCount(format);
                }
                catch (Throwable th) {
                    _LOG.log(Level.WARNING, "Exception lors de l'impression d'un resultat de CAA : " + CAAItemPanel.this._rootItem.getStore().getInfo(BooleanStore.INFO_TREE), th);
                }
                return pageable;
            }
        };
        thread.realiseDo();
        return thread.getPageable();
    }

    public boolean configCloseable(PlugPanelExtend.HelperClose helper) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File export(JChooserFileUtility.Type type) {
        if (this._rootItem.getChildCount() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), ResCompute.getString("KEY_1308"), ResMsgVoc.getString((String)"VOC_WARNING"), 2);
            return null;
        }
        StringBuilder defaultName = new StringBuilder();
        String treeName = FileUtility.protectFilename((String)this._rootItem.getStore().getInfo(BooleanStore.INFO_TREE));
        String treeVersion = this._rootItem.getStore().getInfo(BooleanStore.INFO_VERSION);
        defaultName.append(treeName).append("(").append(treeVersion).append(").caa");
        File result = ExpBookUtility.selectFile((JChooserFileUtility.Type)type, (Plugable)this._plugable, (Component)this, null, (String)".caa", (String)defaultName.toString());
        if (result == null) {
            return null;
        }
        ExportCAA export = new ExportCAA(this._rootItem.getStore(), this._parameters, this._originResult, this._rootItem, this._caaSelector, (PrintExportMCS)this._plugable.getPreferencies(PrintExportMCS.PREF_KEY), this._currentFilter);
        export.setRenderer(this._renderer, false);
        try {
            switch (type) {
                case DOCBOOK: 
                case WORD: {
                    if (export.verifyAnonymousReport(result, this)) {
                        DBKOutput writer = new DBKOutput(result.getAbsolutePath());
                        export.exportFormatDocBook(writer);
                        export.generateAnonymousReport(result, this);
                    }
                    break;
                }
                case XML: {
                    try (Writer writer = null;){
                        writer = new BufferedWriter(new FileWriter(result));
                        export.exportFormatXML(writer);
                        break;
                    }
                }
                default: {
                    throw new IOException("Unsupported format : " + type);
                }
            }
        }
        catch (IOException e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(ResMsgCore.getString((String)"FILE_ERROR_SAVE"));
            buffer.append("\n").append(result);
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this), buffer.toString(), this.getTitle(), 0);
            result = null;
        }
        return result;
    }

    public IModel getModel(String key) {
        File file = null;
        if (key.equals("docbook.file")) {
            file = this.export(JChooserFileUtility.Type.DOCBOOK);
        } else if (key.equals("word.file")) {
            file = this.export(JChooserFileUtility.Type.WORD);
        } else if (key.equals("xml.file")) {
            file = this.export(JChooserFileUtility.Type.XML);
        }
        if (file != null) {
            return new IModel.DefaultModel(key, file, this._idatum.getModel().getName(), this._idatum.getModel().getUID());
        }
        return null;
    }

    class CAATreeTable
    extends TreeTable<CAAItem> {
        public CAATreeTable(TreeTable.TreeTableModel model) {
            super(model);
            this.setPreferredScrollableViewportSize(new Dimension(300, 400));
            this.setFillsViewportHeight(true);
            this.setSelectionMode(2);
            this.getTree().setCellRenderer(new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
                    super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
                    if (value instanceof CAAItem) {
                        CAAItem item = (CAAItem)value;
                        int level = item.getLevel();
                        if (level > 4) {
                            level = 5;
                        }
                        this.setIcon(__levelIcons[level]);
                    }
                    return this;
                }
            });
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int row = CAATreeTable.this.getSelectedRow();
                    if (row < 0) {
                        return;
                    }
                    CAAItem caaItem = (CAAItem)CAATreeTable.this.getObjectAtRow(row);
                    CAAItemPanel.this._mcsPanel.setMCS(caaItem.getMCS());
                    caaItem = caaItem.getParent();
                    if (caaItem == null) {
                        caaItem = CAAItemPanel.this._rootItem;
                    }
                    CAAItemPanel.this._attrOrderModel.changeTable(caaItem);
                }
            });
            this.setDefaultRenderer(Number.class, new MCSTableCellRendererOrder());
            this.setDefaultRenderer(Double.class, new MCSTableCellRendererProbability(CAAItemPanel.this._renderer));
            TableColumnModel myModel = this.getColumnModel();
            for (int i = 0; i < myModel.getColumnCount(); ++i) {
                TableColumn tcol = myModel.getColumn(i);
                tcol.setPreferredWidth(i == 1 ? 40 : (i == 2 ? 70 : 300));
            }
        }

        protected void refreshValues() {
            this.getModel().fireTableRowsUpdated(0, this.getModel().getRowCount() - 1);
        }
    }

    class CAATreeModel
    implements TreeTable.TreeTableModel<CAAItem>,
    JTableTransfertHandler.HelperConvert {
        List<TreeModelListener> _listener = new ArrayList<TreeModelListener>();

        CAATreeModel() {
        }

        public CAAItem getRoot() {
            return CAAItemPanel.this._rootItem;
        }

        public Object getChild(Object parent, int index) {
            return ((CAAItem)parent).getChildAt(index);
        }

        public int getChildCount(Object parent) {
            return ((CAAItem)parent).getChildCount();
        }

        public boolean isLeaf(Object node) {
            return ((CAAItem)node).getChildCount() == 0;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public int getIndexOfChild(Object parent, Object child) {
            CAAItem caaItem = (CAAItem)parent;
            for (int i = caaItem.getChildCount() - 1; i >= 0; ++i) {
                if (caaItem.getChildAt(i) != child) continue;
                return i;
            }
            return -1;
        }

        public void addTreeModelListener(TreeModelListener l) {
            this._listener.add(l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this._listener.remove(l);
        }

        public int getColumnCount() {
            return CAAItemPanel.this._withCAAProbability ? 3 : 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResCompute.getString("CAA_ATTRIBUTE_CUTS");
                }
                case 1: {
                    return ResCompute.getString("VOC_NBR");
                }
                case 2: {
                    return ResMsgVoc.getString((String)"VOC_PROBABILITY");
                }
            }
            return null;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return TreeTable.TreeTableModel.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return Double.class;
                }
            }
            return null;
        }

        public Object getValueAt(CAAItem node, int row, int column) {
            switch (column) {
                case 0: {
                    return node.toString();
                }
                case 1: {
                    return node.getNumber();
                }
                case 2: {
                    return node.getProbability();
                }
            }
            return null;
        }

        public boolean isCellEditable(CAAItem node, int row, int column) {
            return false;
        }

        public void setValueAt(Object aValue, CAAItem node, int row, int column) {
        }

        public String convertToString(Object obj, int row, int col) {
            if (obj == null) {
                return "";
            }
            if (obj instanceof Double) {
                double dvalue = (Double)obj;
                if (Double.isNaN(dvalue)) {
                    return "-";
                }
                return Double.toString(CAAItemPanel.this._renderer.convertProbability(dvalue));
            }
            return obj.toString();
        }
    }
}

