/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ParamCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TaskIEnginePrepareAbstract
extends TaskItem {
    private static Logger _LOG = Logger.getLogger(TaskIEnginePrepareAbstract.class.getPackage().getName());
    EngineBDDAbstract _engineBDD;
    ParamCompute _parameters;
    BooleanStore _store;
    boolean _error;

    public TaskIEnginePrepareAbstract(TaskContainer container, EngineBDDAbstract engine, ParamCompute parameters, BooleanStore store) {
        super(container);
        this._engineBDD = engine;
        this._parameters = parameters;
        this._store = store;
    }

    @Override
    public void run() {
        this._error = true;
        if (this._engineBDD.isEngineDistrib() && CECILIAClient.getCECILIAClient() == null) {
            this.addError(ResCompute.getString("MSG_ENGINE_ERR_PREPARE"));
            _LOG.warning("Selection du calcul distribue dans les preferences alors que le client JXTA n'a pas pu etre demarre");
            return;
        }
        this._engineBDD.prepareComputeType();
        Appendable cmds = this._engineBDD.getCmdsAppendable();
        double missionTime = this._parameters.getMissionTimeH();
        if (missionTime >= 0.0 && this._parameters.getTypeProbability() != TypeProbability.NONE) {
            try {
                this._store.writeProbabilities(cmds);
            }
            catch (IOException e) {
                this.addError(ResCompute.getString("MSG_ENGINE_ERR_PREPARE"));
                _LOG.log(Level.WARNING, "IOException during write probabilities : " + e.getMessage(), e);
                return;
            }
        }
        this._error = !this.prepareEngineCommand();
    }

    protected abstract boolean prepareEngineCommand();

    @Override
    public String getInfo() {
        return ResCompute.getString("TASK_INFO_ENGINE_PREPARE");
    }

    @Override
    public void requestStop() {
    }

    @Override
    public boolean continueWhenFinnished() {
        return !this._error;
    }
}

