/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ParamCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDMCS;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIEnginePrepareAbstract;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskIEnginePrepareMCS
extends TaskIEnginePrepareAbstract {
    private static Logger _LOG = Logger.getLogger(TaskIEnginePrepareMCS.class.getPackage().getName());
    File _resFile;

    public TaskIEnginePrepareMCS(TaskContainer container, EngineBDDAbstract engine, ParamCompute parameters, BooleanStore store, File resFile) {
        super(container, engine, parameters, store);
        this._resFile = resFile;
    }

    @Override
    protected boolean prepareEngineCommand() {
        EngineBDDConfig.EngineType engineType = this._engineBDD.getEngineType();
        String resFileID = this._resFile.getAbsolutePath();
        resFileID = ((EngineBDDMCS)this._engineBDD).createResultID(resFileID);
        try {
            this._parameters.generateComputeScript(this._engineBDD.getCmdsAppendable(), this._store.getRoot(), engineType == EngineBDDConfig.EngineType.Aralia4, resFileID, this._store.iterate());
        }
        catch (IOException e) {
            this.addError(ResCompute.getString("MSG_ENGINE_ERR_PREPARE"));
            _LOG.log(Level.WARNING, "IOException during generate script : " + e.getMessage(), e);
            return false;
        }
        return true;
    }
}

