/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanCut;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ParamCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.compute.MCSInputStream;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TaskIResultLoadMCS
extends TaskItem {
    private static Logger _LOG = Logger.getLogger(TaskIResultLoadMCS.class.getPackage().getName());
    ComputeMCS _compute;
    InfoDatum _idatum;
    Plugable _launcher;
    boolean _withError;
    boolean _requestStop = false;
    private static DocumentBuilderFactory _dbf = null;

    public TaskIResultLoadMCS(TaskContainer container, ComputeMCS compute, InfoDatum idatum, Plugable launcher) {
        super(container);
        this._compute = compute;
        this._idatum = idatum;
        this._launcher = launcher;
        this._withError = false;
    }

    public static void loadProbabilitiesFromXML(InputStream inputStream, BooleanStore store, BooleanResult results) throws IOException {
        if (_dbf == null) {
            _dbf = DocumentBuilderFactory.newInstance();
            _dbf.setValidating(false);
            _dbf.setIgnoringComments(true);
            _dbf.setIgnoringElementContentWhitespace(true);
            _dbf.setCoalescing(false);
            _dbf.setExpandEntityReferences(true);
        }
        try {
            DocumentBuilder db = _dbf.newDocumentBuilder();
            Document doc = db.parse(inputStream);
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals("ftc")) {
                throw new IOException(ResMsgCore.msgFormat((String)"FILE_ERROR_OPEN_XML_ROOT", (Object[])new Object[]{"ftc"}));
            }
            TaskIResultLoadMCS.loadProbabilitiesFromXML(root, store, results);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Exception during read file parameters", e);
            StringBuffer sb = new StringBuffer(32);
            sb.append(e.getClass().getName());
            sb.append(" : ");
            String mess = e.getMessage();
            if (mess == null) {
                sb.append("<null>");
            } else {
                sb.append(mess);
            }
            throw new IOException(sb.toString());
        }
    }

    public static void loadProbabilitiesFromXML(Element xmlElt, BooleanStore store, BooleanResult results) throws SAXException, IOException {
        NodeList childs = xmlElt.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node xmlChild = childs.item(i);
            String xmlChildName = xmlChild.getNodeName();
            if (xmlChildName.equals("ftc.warning")) {
                String msg = ((Element)xmlChild).getAttribute("msg");
                results.addWarning(msg);
            }
            if (!xmlChildName.equals("ftc.probability")) continue;
            boolean isEvt = false;
            int idx = -1;
            String att = ((Element)xmlChild).getAttribute("id");
            if (att.startsWith("e")) {
                isEvt = true;
                att = att.substring(1);
            } else if (att.startsWith("g")) {
                att = att.substring(1);
            }
            try {
                idx = Integer.parseInt(att);
            }
            catch (NumberFormatException nfe) {
                throw new SAXException(nfe);
            }
            if (idx < 0 || idx > (isEvt ? store.getNbrLeaves() : store.getNbrGates())) {
                throw new SAXException("Incompatible store/result [id=" + (isEvt ? "e" : "g") + Integer.toString(idx) + "]");
            }
            String name = ((Element)xmlChild).getAttribute("name");
            double dblvalue = Double.NaN;
            String att2 = ((Element)xmlChild).getAttribute("pr");
            try {
                dblvalue = Double.parseDouble(att2);
            }
            catch (NumberFormatException nfe) {
                throw new SAXException(nfe);
            }
            if (isEvt) {
                BooleanNode leaf = store.getLeaf(idx);
                if (leaf == null || !leaf.getName().equals(name)) {
                    throw new IOException("Incompatible store/result [leaf '" + name + "," + idx + "']");
                }
                leaf.setProbability(dblvalue);
                for (ParamCompute.TypeImportanceFactor tif : ParamCompute.TypeImportanceFactor.values()) {
                    String att3 = ((Element)xmlChild).getAttribute(tif.toString().toLowerCase());
                    if (att3 == null || att3.isEmpty()) continue;
                    try {
                        dblvalue = Double.parseDouble(att3);
                    }
                    catch (NumberFormatException nfe) {
                        throw new SAXException(nfe);
                    }
                    results.addImportanceFactor(tif, idx, dblvalue);
                }
                continue;
            }
            BooleanNode gate = store.getGate(idx);
            if (gate == null || !gate.getName().equals(name)) {
                throw new IOException("Incompatible store/result [gate '" + name + "," + idx + "']");
            }
            results.addProbability(store.getRoot(), gate, dblvalue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadProbabilities(File file, BooleanStore store, BooleanResult results) {
        if (file == null) {
            throw new NullPointerException();
        }
        InputStream input = null;
        boolean bSuccess = false;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            TaskIResultLoadMCS.loadProbabilitiesFromXML(input, store, results);
            bSuccess = true;
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Error during load 'probabilities file'", e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    _LOG.log(Level.INFO, "Error during close 'probabilities file'", e);
                }
            }
        }
        if (bSuccess) {
            _LOG.finest("Load probabilities < " + file.toString());
        }
        return bSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadCuts(File file, BooleanStore store, BooleanMCS mcs) {
        if (file == null) {
            throw new NullPointerException();
        }
        boolean bSuccess = false;
        FilterInputStream inStream = null;
        try {
            int nbrLeaves = store.getNbrLeaves();
            inStream = new MCSInputStream(new BufferedInputStream(new FileInputStream(file)), nbrLeaves + 2);
            int format = inStream.read();
            if (format != 1) {
                throw new IOException("Incompatible data format [format = " + format + "]");
            }
            int nbrCuts = -1;
            nbrCuts = ((MCSInputStream)inStream).readInt();
            if (nbrCuts < 0) {
                throw new IOException("Bad number cuts (nbrCuts=" + nbrCuts + ")");
            }
            for (int i = 0; i < nbrCuts; ++i) {
                int order = ((MCSInputStream)inStream).readIndex();
                if (order < 0) {
                    throw new IOException("Bad order cut (idxCut=" + i + ", order=" + order + ")");
                }
                ArrayList<BooleanNode> cut = new ArrayList<BooleanNode>(order);
                for (int j = 0; j < order; ++j) {
                    int idx = ((MCSInputStream)inStream).readIndex();
                    if (idx < 0 || idx >= nbrLeaves) {
                        throw new IOException("Bad index event for cut (idxCut=" + i + ", idxEvt=" + j + ", idx=" + idx + ")");
                    }
                    cut.add(store.getLeaf(idx));
                }
                mcs.addCut(new BooleanCut(cut, false));
            }
            bSuccess = true;
        }
        catch (IOException e) {
            _LOG.log(Level.SEVERE, "Error during save 'cuts file'", e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    _LOG.log(Level.INFO, "Error during close 'cuts file'", e);
                }
            }
        }
        if (bSuccess) {
            _LOG.finest("Load cuts < " + file.toString());
        }
        return bSuccess;
    }

    @Override
    public void run() {
        File file;
        String key;
        InfoDatum idatum = this._idatum;
        if (!this._withError && (key = this._idatum.getKey()).endsWith(".Abstract")) {
            String config = (String)this._idatum.getParameters().get("Config");
            StringBuilder sbKey = new StringBuilder(key.length() + config.length());
            sbKey.append(key.substring(0, key.length() - ".Abstract".length()));
            sbKey.append("@").append(config);
            key = sbKey.toString();
            idatum = this._launcher.getDatum(key);
            if (idatum == null) {
                this.addError(ResCompute.getString("MSG_RESULT_ERR_GETDATUM"));
                this._withError = true;
            } else {
                String msgError = (String)idatum.getParameters().get("tree.error");
                if (msgError != null && !msgError.isEmpty()) {
                    this.addError(msgError);
                    this._withError = true;
                }
            }
        }
        if (!this._withError) {
            file = (File)idatum.getInputFiles().get("result.abstract");
            if (file == null) {
                _LOG.severe("No input file for key = 'result.abstract'");
                this._withError = true;
            } else if (!TaskIResultLoadMCS.loadProbabilities(file, this._compute.getStore(), this._compute.getResults())) {
                this._withError = true;
            }
        }
        if (!this._withError) {
            file = (File)idatum.getInputFiles().get("result.cuts");
            if (file == null) {
                _LOG.severe("No input file for key = 'result.cuts'");
                this._withError = true;
            } else if (!TaskIResultLoadMCS.loadCuts(file, this._compute.getStore(), this._compute.getResults().getMCS())) {
                this._withError = true;
            }
        }
        if (this._withError) {
            this.addError(ResCompute.getString("MSG_RESULT_ERR_LOAD"));
        }
    }

    @Override
    public String getInfo() {
        return ResCompute.getString("TASK_INFO_RESULT_LOAD");
    }

    @Override
    public void requestStop() {
        this._requestStop = true;
    }

    @Override
    public boolean continueWhenFinnished() {
        return !this._withError;
    }
}

