/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.seqconvert;

import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.plugin.seqconvert.ParametersSequenceConverter;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ParametersIOSequenceConverter
implements IOParameters {
    protected static final String KEY_XML_VIEWER = "xml-viewer";
    protected static final String KEY_ACTIVE = "active";
    protected static final String KEY_PATH = "executable-path";
    protected static final String KEY_ARGS = "arguments";

    ParametersIOSequenceConverter() {
    }

    public void writeXML(Writer out, Object parameters, PluginManager launcher) throws IOException {
        if (!(parameters instanceof ParametersSequenceConverter)) {
            throw new IOException("Unsupported object for IOSequenceConverter");
        }
        ParametersSequenceConverter viewer = (ParametersSequenceConverter)parameters;
        out.write("<");
        out.write(KEY_XML_VIEWER);
        out.write(" ");
        out.write(KEY_ACTIVE);
        out.write("=\"");
        out.write(Boolean.toString(viewer.getXmlViewer()));
        out.write("\"");
        out.write(" ");
        out.write(KEY_PATH);
        out.write("=\"");
        out.write(viewer.getXmlViewerPath());
        out.write("\"");
        out.write(" ");
        out.write(KEY_ARGS);
        out.write("=\"");
        out.write(viewer.getXmlViewerArgs());
        out.write("\"");
        out.write("/>\n");
    }

    public Object readXML(Node node, PluginManager launcher) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Element root = (Element)node;
        if (!root.getNodeName().equals(KEY_XML_VIEWER)) {
            return null;
        }
        ParametersSequenceConverter res = new ParametersSequenceConverter();
        Node attr = root.getAttributes().getNamedItem(KEY_ACTIVE);
        if (attr != null) {
            res._xmlViewer = Boolean.valueOf(attr.getNodeValue());
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_PATH)) != null) {
            res._xmlViewerPath = attr.getNodeValue();
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_ARGS)) != null) {
            res._xmlViewerArgs = attr.getNodeValue();
        }
        return res;
    }
}

