/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.seqconvert;

import com.dassault.cecilia.plugin.seqconvert.Event;
import com.dassault.cecilia.plugin.seqconvert.Sequence;
import java.util.ArrayList;

public class SequencesUtility {
    public Sequence filterSequence(Sequence sequence, Event[] eventsToFilter) {
        return new Sequence(sequence.filter(eventsToFilter));
    }

    public Sequence[] filterSequences(Sequence[] sequences, Event[] eventsToFilter) {
        ArrayList<Sequence> listSeq = new ArrayList<Sequence>();
        for (int i = 0; i < sequences.length; ++i) {
            listSeq.add(new Sequence(sequences[i].filter(eventsToFilter)));
        }
        Sequence[] retSequences = listSeq.toArray(new Sequence[listSeq.size()]);
        return retSequences;
    }

    public Sequence removeRedEvtsFromSequence(Sequence sequence) {
        return new Sequence(sequence.removeRedundantEvents());
    }

    public Sequence[] removeRedEvtsFromSequences(Sequence[] sequences) {
        ArrayList<Sequence> listSeq = new ArrayList<Sequence>();
        for (int i = 0; i < sequences.length; ++i) {
            listSeq.add(new Sequence(sequences[i].removeRedundantEvents()));
        }
        Sequence[] retSequences = listSeq.toArray(new Sequence[listSeq.size()]);
        return retSequences;
    }

    public Sequence[] removeEquivalentSequences(Sequence[] sequences) {
        ArrayList<Sequence> listSeq = new ArrayList<Sequence>();
        boolean hasAnEquivalent = false;
        for (int i = 0; i < sequences.length; ++i) {
            hasAnEquivalent = false;
            for (int j = i + 1; j < sequences.length; ++j) {
                if (!sequences[i].isEquivalent(sequences[j])) continue;
                hasAnEquivalent = true;
            }
            if (hasAnEquivalent) continue;
            listSeq.add(sequences[i]);
        }
        Sequence[] retSequences = listSeq.toArray(new Sequence[listSeq.size()]);
        return retSequences;
    }

    public Sequence[] removeNotMinSequences(Sequence[] sequences) {
        ArrayList<Sequence> listSeq = new ArrayList<Sequence>();
        boolean isMinimale = true;
        int nbMinimales = 0;
        for (int i = 0; i < sequences.length; ++i) {
            int j;
            isMinimale = true;
            for (j = i + 1; j < sequences.length; ++j) {
                if (!sequences[i].contains(sequences[j])) continue;
                isMinimale = false;
            }
            for (j = 0; j < nbMinimales; ++j) {
                if (!sequences[i].contains((Sequence)listSeq.get(j))) continue;
                isMinimale = false;
            }
            if (!isMinimale) continue;
            listSeq.add(sequences[i]);
            ++nbMinimales;
        }
        Sequence[] retSequences = listSeq.toArray(new Sequence[listSeq.size()]);
        return retSequences;
    }

    public Sequence[] classifySequences(Sequence[] sequences) {
        boolean invert;
        do {
            invert = false;
            for (int i = 0; i < sequences.length - 1; ++i) {
                if (sequences[i].getNbEvents() <= sequences[i + 1].getNbEvents()) continue;
                Sequence tempSequence = sequences[i];
                sequences[i] = sequences[i + 1];
                sequences[i + 1] = tempSequence;
                invert = true;
            }
        } while (invert);
        return sequences;
    }
}

