/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.stokstic;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.plugin.mbsa.stokstic.PluginCmdMocaRP;
import com.dassault.cecilia.plugin.mbsa.stokstic.ResMoca;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MocaDlgParams
extends JDialogCecilia {
    Plugable _launcher = null;
    JTextField _ctrlDuration;
    JTextField _ctrlDelay;
    JTextField _ctrlSeed;
    JTextField _ctrlStory;

    public MocaDlgParams(Window win) {
        super(win, true);
        this.init();
    }

    protected void init() {
        super.init();
        this.setTitle(ResMoca.getString("DLG_PARAM_MOCA"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel root = new JPanel(new GridBagLayout());
        root.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        int line = 0;
        root.add((Component)new JLabel(ResMoca.getString("DLG_PARAM_MOCA_DURATION")), new GridBagConstraints(0, line, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._ctrlDuration = new JTextField(10);
        root.add((Component)this._ctrlDuration, new GridBagConstraints(1, line, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        root.add((Component)new JLabel(ResMoca.getString("DLG_PARAM_MOCA_DELAY")), new GridBagConstraints(0, ++line, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._ctrlDelay = new JTextField(10);
        root.add((Component)this._ctrlDelay, new GridBagConstraints(1, line, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        root.add((Component)new JLabel(ResMoca.getString("DLG_PARAM_MOCA_SEED")), new GridBagConstraints(0, ++line, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._ctrlSeed = new JTextField(10);
        root.add((Component)this._ctrlSeed, new GridBagConstraints(1, line, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        root.add((Component)new JLabel(ResMoca.getString("DLG_PARAM_MOCA_STORY")), new GridBagConstraints(0, ++line, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._ctrlStory = new JTextField(10);
        root.add((Component)this._ctrlStory, new GridBagConstraints(1, line, 1, 1, 100.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        ++line;
        this.getContentPane().add((Component)root, "Center");
        AbstractAction okAct = new AbstractAction(ResMsgVoc.getString((String)"VOC_OK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MocaDlgParams.this.actionOK();
            }
        };
        JButton okBut = new JButton(okAct);
        AbstractAction escAct = new AbstractAction(ResMsgVoc.getString((String)"VOC_CANCEL")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MocaDlgParams.this.setVisible(false);
            }
        };
        JButton escBut = new JButton(escAct);
        JButton defBut = new JButton(ResMoca.getString("DLG_OPT_MOCA_DEFVALUE"));
        defBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MocaDlgParams.this._ctrlDuration.setText("1000");
                MocaDlgParams.this._ctrlDelay.setText("3600");
                MocaDlgParams.this._ctrlSeed.setText("12345678");
                MocaDlgParams.this._ctrlStory.setText("1000");
                MocaDlgParams.this._launcher.setOption(PluginCmdMocaRP.OPT_MOCA_DURATION, MocaDlgParams.this._ctrlDuration.getText());
                MocaDlgParams.this._launcher.setOption(PluginCmdMocaRP.OPT_MOCA_DELAY, MocaDlgParams.this._ctrlDelay.getText());
                MocaDlgParams.this._launcher.setOption(PluginCmdMocaRP.OPT_MOCA_SEED, MocaDlgParams.this._ctrlSeed.getText());
                MocaDlgParams.this._launcher.setOption(PluginCmdMocaRP.OPT_MOCA_STORY, MocaDlgParams.this._ctrlStory.getText());
            }
        });
        JPanel buts = new JPanel(new GridLayout(1, 3, 10, 5));
        buts.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buts.add(okBut);
        buts.add(escBut);
        buts.add(defBut);
        this.putAction("CECILIA_ENTER", okAct);
        this.putAction("CECILIA_CANCEL", escAct);
        this.getContentPane().add((Component)buts, "South");
        this.pack();
        Dimension size = this.getSize();
        Dimension pSize = this.getParent().getSize();
        Point pLocal = this.getParent().getLocation();
        this.setLocation(pLocal.x + (pSize.width - size.width) / 2, pLocal.y + (pSize.height - size.height) / 2);
    }

    protected void actionOK() {
        JTextField verify = null;
        try {
            verify = this._ctrlDuration;
            if (Double.parseDouble(verify.getText()) <= 0.0) {
                throw new NumberFormatException();
            }
            verify = this._ctrlDelay;
            if (Integer.parseInt(verify.getText()) <= 0) {
                throw new NumberFormatException();
            }
            verify = this._ctrlSeed;
            if (Long.parseLong(verify.getText()) <= 0L) {
                throw new NumberFormatException();
            }
            verify = this._ctrlStory;
            if (Integer.parseInt(verify.getText()) <= 0) {
                throw new NumberFormatException();
            }
            this._launcher.setOption(PluginCmdMocaRP.OPT_MOCA_DURATION, this._ctrlDuration.getText());
            this._launcher.setOption(PluginCmdMocaRP.OPT_MOCA_DELAY, this._ctrlDelay.getText());
            this._launcher.setOption(PluginCmdMocaRP.OPT_MOCA_SEED, this._ctrlSeed.getText());
            this._launcher.setOption(PluginCmdMocaRP.OPT_MOCA_STORY, this._ctrlStory.getText());
            this._result = true;
            this.setVisible(false);
        }
        catch (NumberFormatException exc) {
            if (verify != null) {
                verify.requestFocus();
            }
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)((Object)this)), ResMoca.getString("DLG_PARAM_MOCA_ERR"), ResMoca.getString("DEF_TITLE"), 0);
        }
    }

    public double getDuration() {
        try {
            double value = Double.parseDouble(this._ctrlDuration.getText());
            if (value > 0.0) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 1000.0;
    }

    public long getSeed() {
        try {
            long value = Long.parseLong(this._ctrlSeed.getText());
            if (value > 0L) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 12345678L;
    }

    public int getDelay() {
        try {
            int value = Integer.parseInt(this._ctrlDelay.getText());
            if (value > 0) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 3600;
    }

    public int getStory() {
        try {
            int value = Integer.parseInt(this._ctrlStory.getText());
            if (value > 0) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 1000;
    }

    public boolean DoModal(Plugable launcher) {
        this._launcher = launcher;
        this._ctrlDuration.setText(Double.toString(PlugableUtility.getDoubleOpt((Plugable)this._launcher, (String)PluginCmdMocaRP.OPT_MOCA_DURATION, (double)1000.0)));
        this._ctrlDelay.setText(Integer.toString(PlugableUtility.getIntOpt((Plugable)this._launcher, (String)PluginCmdMocaRP.OPT_MOCA_DELAY, (int)3600)));
        this._ctrlSeed.setText(Long.toString(PlugableUtility.getLongOpt((Plugable)this._launcher, (String)PluginCmdMocaRP.OPT_MOCA_SEED, (long)12345678L)));
        this._ctrlStory.setText(Integer.toString(PlugableUtility.getIntOpt((Plugable)this._launcher, (String)PluginCmdMocaRP.OPT_MOCA_STORY, (int)1000)));
        this.setVisible(true);
        return this.getResult();
    }
}

