/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.stokstic;

import com.dassault.cecilia.plugin.mbsa.stokstic.ResMoca;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class MocaLaunch {
    Throwable _exception;
    MocaState _state = MocaState.NONE;
    MocaStateError _errorState = MocaStateError.NONE;
    String _exec;
    String[] _envp;
    File _dir;
    String _prompt;
    Process _process;
    MocaInput _input;
    MocaOutput _output;
    MocaError _error;

    private void catchException(Throwable exc) {
        if (this._exception != null) {
            ResMoca.LOG.log(Level.WARNING, "Previous exception not clear : ", this._exception);
        }
        this._exception = exc;
    }

    public Throwable getException() {
        return this._exception;
    }

    public synchronized void setState(MocaState value) {
        ResMoca.LOG.finest("Change State : " + (Object)((Object)this._state) + " => " + (Object)((Object)value));
        this._state = value;
        this.notifyAll();
    }

    public synchronized void waitForState(MocaState value) {
        try {
            while (this._state != value && this._exception == null && this._process != null) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            this.catchException(e);
        }
    }

    public synchronized void waitForState(MocaState value, long milli) {
        try {
            if (this._state != value && this._exception == null && this._process != null) {
                this.wait(milli);
            }
        }
        catch (InterruptedException e) {
            this.catchException(e);
        }
    }

    public synchronized boolean isState(MocaState value) {
        return this._exception == null && this._state == value;
    }

    public synchronized void setStateError(MocaStateError value) {
        ResMoca.LOG.finest("Change ErrorState : " + (Object)((Object)this._errorState) + " => " + (Object)((Object)value));
        this._errorState = value;
        this.notifyAll();
    }

    public synchronized void waitForStateError(MocaStateError value) {
        try {
            if (this._errorState != value && this._exception == null && this._process != null) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            this.catchException(e);
        }
    }

    public MocaLaunch(String exec) {
        this(exec, null, null);
    }

    public MocaLaunch(String exec, String[] envp) {
        this(exec, envp, null);
    }

    public MocaLaunch(String exec, File dir) {
        this(exec, null, dir);
    }

    public MocaLaunch(String exec, String[] envp, File dir) {
        this._exec = exec;
        this._envp = envp;
        this._dir = dir;
        this._prompt = null;
        this._process = null;
    }

    public void setPrompt(String value) {
        this._prompt = value;
        if (this._process != null) {
            this._output.definePrompt(this._prompt);
        }
    }

    public boolean openSession() {
        try {
            this._process = Runtime.getRuntime().exec(this._exec, this._envp, this._dir);
            this._input = new MocaInput(this._process.getOutputStream());
            this._output = new MocaOutput(this._process.getInputStream());
            this._error = new MocaError(this._process.getErrorStream());
            this._output.definePrompt(this._prompt);
            this._output.start();
            this._error.start();
            this._input.start();
        }
        catch (Throwable t) {
            this.catchException(t);
        }
        if (this._exception == null) {
            this._output.setMemoriseResult(null);
            this._error.clearBuffer();
            this.setState(MocaState.READER);
            this.setStateError(MocaStateError.READER);
            this.waitForState(MocaState.WAIT);
            this.waitForStateError(MocaStateError.WAIT);
        }
        return this._exception == null;
    }

    public boolean sendCommand(String command, Collection<String> result) {
        this._output.setMemoriseResult(result);
        this._input.setCommand(command);
        this._error.clearBuffer();
        this.setState(MocaState.WRITER);
        this.setStateError(MocaStateError.READER);
        this.waitForState(MocaState.WAIT);
        this.waitForStateError(MocaStateError.WAIT);
        if (result != null) {
            this._error.copyError(result);
        }
        this._error.catchIfErrorExist();
        return this._exception == null;
    }

    public boolean closeSession() {
        this._output.setMemoriseResult(null);
        this._input.setCommand(null);
        this.setState(MocaState.WRITER);
        try {
            this._input.join(250L);
            this._output.join(250L);
            this._error.join(250L);
            this._process.getOutputStream().close();
        }
        catch (InterruptedException e) {
            this.catchException(e);
        }
        catch (IOException e) {
            this.catchException(e);
        }
        this._process.destroy();
        this._process = null;
        this.setState(MocaState.NONE);
        this.setStateError(MocaStateError.NONE);
        return this._exception == null;
    }

    class MocaError
    extends Thread {
        StringWriter _bufferWriter;
        BufferedReader _errorReader;

        MocaError(InputStream error) {
            super("MocaLaunch-Error");
            this._errorReader = new BufferedReader(new InputStreamReader(error));
            this._bufferWriter = new StringWriter(2048);
        }

        void clearBuffer() {
            StringBuffer sb = this._bufferWriter.getBuffer();
            if (sb.length() > 0) {
                sb.delete(0, sb.length() - 1);
            }
        }

        public void catchIfErrorExist() {
            String result = this._bufferWriter.toString().trim();
            if (result.length() == 0) {
                return;
            }
            MocaLaunch.this.catchException(new RuntimeException(result));
        }

        public void copyError(Collection<String> result) {
            if (result == null) {
                return;
            }
            BufferedReader reader = new BufferedReader(new StringReader(this._bufferWriter.toString()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    result.add(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            do {
                MocaLaunch.this.waitForStateError(MocaStateError.READER);
                try {
                    do {
                        MocaLaunch.this.waitForState(MocaState.WAIT, 100L);
                        while (this._errorReader.ready()) {
                            String line = this._errorReader.readLine();
                            this._bufferWriter.write(line);
                            this._bufferWriter.write("\n");
                        }
                    } while (!MocaLaunch.this.isState(MocaState.NONE) && !MocaLaunch.this.isState(MocaState.WAIT));
                    MocaLaunch.this.setStateError(MocaStateError.WAIT);
                }
                catch (IOException ioe) {
                    MocaLaunch.this.catchException(ioe);
                }
            } while (!MocaLaunch.this.isState(MocaState.NONE));
        }
    }

    class MocaOutput
    extends Thread {
        InputStreamReader _outputReader;
        Pattern _promptPattern;
        Collection<String> _results;

        MocaOutput(InputStream input) {
            super("MocaLaunch-Output");
            this._outputReader = new InputStreamReader(input);
            this._results = null;
        }

        void setMemoriseResult(Collection<String> results) {
            this._results = results;
        }

        void definePrompt(String value) {
            this._promptPattern = Pattern.compile("^" + value + ".*");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String readInputLine() {
            int stop = 0;
            StringBuffer buffer = new StringBuffer();
            try {
                block7: while (stop == 0) {
                    if (!this._outputReader.ready() && this._promptPattern.matcher(buffer.toString()).matches()) {
                        stop = 1;
                    }
                    if (stop != 0) continue;
                    int c = this._outputReader.read();
                    switch (c) {
                        case -1: {
                            stop = 2;
                            continue block7;
                        }
                        case 13: {
                            c = this._outputReader.read();
                            stop = 1;
                            continue block7;
                        }
                        case 10: {
                            stop = 2;
                            continue block7;
                        }
                    }
                    buffer.append((char)c);
                }
            }
            catch (IOException ioe) {
                MocaLaunch.this.catchException(ioe);
            }
            if (stop == 2 && buffer.length() == 0) {
                return null;
            }
            return buffer.toString();
        }

        int readInput() {
            int status = 1;
            while (status == 1) {
                String line = this.readInputLine();
                ResMoca.LOG.finest(line);
                if (line == null) {
                    status = 0;
                    continue;
                }
                if (this._promptPattern.matcher(line).matches()) {
                    status = 2;
                    continue;
                }
                if (this._results == null) continue;
                this._results.add(line);
            }
            return status;
        }

        @Override
        public void run() {
            int status = 1;
            while (status != 0) {
                MocaLaunch.this.waitForState(MocaState.READER);
                status = this.readInput();
                MocaLaunch.this.setState(MocaState.WAIT);
            }
        }
    }

    class MocaInput
    extends Thread {
        BufferedWriter _inputWriter;
        String _cmd;

        MocaInput(OutputStream output) {
            super("MocaLaunch-Input");
            this._inputWriter = new BufferedWriter(new OutputStreamWriter(output));
        }

        public void setCommand(String value) {
            this._cmd = value;
        }

        @Override
        public void run() {
            try {
                boolean stop = false;
                while (!stop) {
                    MocaLaunch.this.waitForState(MocaState.WRITER);
                    if (this._cmd != null) {
                        this._inputWriter.write(this._cmd + "\n");
                        this._inputWriter.flush();
                    } else {
                        stop = true;
                    }
                    MocaLaunch.this.setState(MocaState.READER);
                }
            }
            catch (IOException ioe) {
                MocaLaunch.this.catchException(ioe);
            }
        }
    }

    static enum MocaStateError {
        NONE,
        READER,
        WAIT;

    }

    static enum MocaState {
        NONE,
        WRITER,
        READER,
        WAIT;

    }
}

