/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.migration.db60to60;

import com.dassault.cecilia.migration.db60to60.DBCopyDefault;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class DBCopySequences
extends DBCopyDefault {
    protected int getMaxValue(Connection DBTarget, String sequenceName) throws SQLException {
        Statement statement = DBTarget.createStatement();
        ResultSet resultSet = statement.executeQuery(sequenceName);
        resultSet.next();
        int currentValue = resultSet.getInt(1);
        statement.close();
        return currentValue;
    }

    protected void updateSequence(Connection DBTarget, String sequence, String table, String field) throws SQLException {
        int maxValue = this.getMaxValue(DBTarget, "SELECT MAX(" + field + ") FROM " + table);
        Statement statement = DBTarget.createStatement();
        statement.executeUpdate("ALTER SEQUENCE " + sequence + " RESTART " + (maxValue + 1));
        statement.close();
    }

    @Override
    public void updateSequences(Connection DBTarget) throws SQLException {
        _LOG.fine("Update sequences started...");
        this.updateSequence(DBTarget, "cec_groups_pk_seq", "cec_groups", "grp_id");
        this.updateSequence(DBTarget, "cec_users_pk_seq", "cec_users", "usr_id");
        this.updateSequence(DBTarget, "cec_preferencies_pk_seq", "cec_preferencies", "upf_id");
        this.updateSequence(DBTarget, "cec_objects_pk_seq", "cec_objects", "obj_id");
        this.updateSequence(DBTarget, "cec_obj_models_pk_seq", "cec_obj_models", "mod_id");
        this.updateSequence(DBTarget, "cec_obj_properties_pk_seq", "cec_obj_properties", "opr_id");
        this.updateSequence(DBTarget, "cec_folders_pk_seq", "cec_folders", "fol_id");
        _LOG.info("Update sequences completed...");
    }
}

