/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.migration.db60to60;

import com.dassault.cecilia.migration.db60to60.DBCopyDefault;
import com.dassault.cecilia.migration.db60to60.DBCopyOracle;
import com.dassault.cecilia.migration.db60to60.DBCopyPostgre;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBTransfer {
    private static final Logger _LOG = Logger.getLogger(DBTransfer.class.getPackage().getName());

    private static DBType findDBType(String connect) {
        if (connect == null) {
            return null;
        }
        if (connect.trim().length() == 0) {
            return null;
        }
        if (connect.startsWith("jdbc:h2:file")) {
            return DBType.H2;
        }
        if (connect.startsWith("jdbc:oracle")) {
            return DBType.Oracle;
        }
        if (connect.startsWith("jdbc:postgresql")) {
            return DBType.Postgres;
        }
        if (connect.startsWith("jdbc:mysql")) {
            return DBType.MySQL;
        }
        return null;
    }

    private static boolean verifyDriver(DBType dbType) {
        try {
            Class.forName(dbType.getDriver());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static Connection createConnection(String connectString, String user, String password) {
        try {
            return DriverManager.getConnection(connectString, user, password);
        }
        catch (SQLException e) {
            _LOG.warning("Database error during create connection:" + connectString);
            _LOG.log(Level.FINE, "More informations : ", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Connection dbSrc = null;
        Connection dbTgt = null;
        try {
            int result = 1;
            DBType dbSrcType = null;
            DBType dbTgtType = null;
            String dbSrcConnect = null;
            String dbTgtConnect = null;
            if (args.length == 6) {
                dbSrcConnect = args[0];
                String dbSrcUser = args[1];
                String dbSrcPasswd = args[2];
                dbTgtConnect = args[3];
                String dbTgtUser = args[4];
                String dbTgtPasswd = args[5];
                dbSrcType = DBTransfer.findDBType(dbSrcConnect);
                if (dbSrcType == null) {
                    _LOG.warning("Database source type unknown");
                } else {
                    if (dbSrcType == DBType.H2) {
                        if (!dbSrcUser.isEmpty() || !dbSrcPasswd.isEmpty()) {
                            _LOG.warning("Database source : No user/passwd for H2");
                        }
                        dbSrcPasswd = "";
                        dbSrcUser = "";
                    }
                    if ((dbTgtType = DBTransfer.findDBType(dbTgtConnect)) == null) {
                        _LOG.warning("Database target type unknown");
                    } else if (dbTgtType == DBType.MySQL) {
                        _LOG.warning("Database target type MySQL impossible");
                    } else {
                        if (dbTgtType == DBType.H2) {
                            if (!dbTgtUser.isEmpty() || !dbTgtPasswd.isEmpty()) {
                                _LOG.warning("Database target : No user/passwd for H2");
                            }
                            dbTgtPasswd = "";
                            dbTgtUser = "";
                        }
                        result = 2;
                        if (!DBTransfer.verifyDriver(dbSrcType)) {
                            _LOG.warning("Database source error during load JDBC driver");
                        } else {
                            dbSrc = DBTransfer.createConnection(dbSrcConnect, dbSrcUser, dbSrcPasswd);
                            if (dbSrc != null) {
                                result = 3;
                                if (!DBTransfer.verifyDriver(dbTgtType)) {
                                    _LOG.warning("Database target error during load JDBC driver");
                                } else {
                                    dbTgt = DBTransfer.createConnection(dbTgtConnect, dbTgtUser, dbTgtPasswd);
                                    if (dbTgt != null) {
                                        result = 0;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (result != 0) {
                _LOG.severe("USAGE : java ... -classpath=... " + DBTransfer.class.getName() + " dbSrcConnect dbSrcUser dbSrcPasswd dbTgtConnect dbTgtUser dbTgtPasswd");
                System.exit(result);
            }
            _LOG.info("----------------------------------------------------------------------------");
            _LOG.info("- Dassault Aviation - Database Transfer (6.0 => 6.0)                       -");
            _LOG.info("----------------------------------------------------------------------------");
            _LOG.info("Transfer started");
            _LOG.info("  Source-Type      : " + dbSrcType);
            _LOG.info("  Source-Connection: " + dbSrcConnect);
            _LOG.info("  Target-Type      : " + (Object)((Object)dbTgtType));
            _LOG.info("  Target-Connection: " + dbTgtConnect);
            DBCopyDefault dbCopy = null;
            switch (dbTgtType) {
                case Oracle: {
                    dbCopy = new DBCopyOracle();
                    break;
                }
                case Postgres: {
                    dbCopy = new DBCopyPostgre();
                    break;
                }
                default: {
                    dbCopy = new DBCopyDefault();
                }
            }
            try {
                dbCopy.deleteTables(dbTgt);
                dbCopy.copyData(dbSrc, dbTgt);
                dbCopy.updateSequences(dbTgt);
                _LOG.info("----------------------------------------------------------------------------");
                _LOG.info("Transfer completed");
            }
            catch (SQLException e) {
                _LOG.log(Level.SEVERE, "Exception during Database transfer", e);
            }
            _LOG.info("----------------------------------------------------------------------------");
        }
        finally {
            if (dbSrc != null) {
                try {
                    dbSrc.close();
                }
                catch (SQLException e) {
                    _LOG.log(Level.INFO, "Exception during close database source", e);
                }
            }
            if (dbTgt != null) {
                try {
                    dbTgt.close();
                }
                catch (SQLException e) {
                    _LOG.log(Level.INFO, "Exception during close database target", e);
                }
            }
        }
    }

    private static enum DBType {
        Oracle("oracle.jdbc.driver.OracleDriver"),
        MySQL("com.mysql.jdbc.Driver"),
        H2("org.h2.Driver"),
        Postgres("org.postgresql.Driver");

        String _driver;

        private DBType(String driver) {
            this._driver = driver;
        }

        public String getDriver() {
            return this._driver;
        }
    }
}

