/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mcs;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class AraliaWriter {
    PrintWriter _araWriter;
    int _sizeBlock;
    char _sepGate;
    String _top;
    ArrayList<Idx> _idxLst;

    private int incIdx(int rg) {
        Idx idx = this._idxLst.get(rg);
        return ++idx._idx;
    }

    public AraliaWriter(Writer araWriter) {
        this(araWriter, 100, '.');
    }

    public AraliaWriter(Writer araWriter, int size, char sep) {
        this._araWriter = new PrintWriter(araWriter);
        this._sizeBlock = Math.max(size, 2);
        this._sepGate = sep;
        this._top = "'root'";
        this._idxLst = new ArrayList();
        this._idxLst.add(new Idx(0));
    }

    private void writeGroupMCS(int num, int rg) throws IOException {
        if (num % this._sizeBlock != 0) {
            return;
        }
        if (this._idxLst.size() == rg + 1) {
            this._idxLst.add(new Idx(0));
        }
        StringBuffer sb = new StringBuffer(3 + rg * 2);
        sb.append("g");
        sb.append(this._sepGate);
        for (int i = 0; i < rg; ++i) {
            sb.append(this._sizeBlock);
            sb.append(this._sepGate);
        }
        String baseName = sb.toString();
        int idx = this.incIdx(rg + 1);
        this._araWriter.print(baseName);
        this._araWriter.print(this._sizeBlock);
        this._araWriter.print(this._sepGate);
        this._araWriter.print(idx);
        this._araWriter.print(" := (");
        int beg = num % this._sizeBlock;
        beg = beg == 0 ? num - this._sizeBlock : num - beg;
        for (int i = beg; i < num; ++i) {
            this._araWriter.print(baseName);
            this._araWriter.print(i + 1);
            if (i + 1 >= num) continue;
            this._araWriter.print(" | ");
        }
        this._araWriter.print(");\n");
        this.writeGroupMCS(idx, rg + 1);
    }

    private void finishGroupMCS(int num, int rg, boolean force) throws IOException {
        if (this._idxLst.size() <= rg + 1) {
            return;
        }
        if (this._idxLst.size() == rg + 1) {
            this._idxLst.add(new Idx(0));
        }
        Idx idx = this._idxLst.get(rg + 1);
        if (force || num % this._sizeBlock != 0) {
            force = true;
            StringBuffer sb = new StringBuffer(3 + rg * 2);
            sb.append("g");
            sb.append(this._sepGate);
            for (int i = 0; i < rg; ++i) {
                sb.append(this._sizeBlock);
                sb.append(this._sepGate);
            }
            String baseName = sb.toString();
            ++idx._idx;
            this._araWriter.print(baseName);
            this._araWriter.print(this._sizeBlock);
            this._araWriter.print(this._sepGate);
            this._araWriter.print(idx._idx);
            this._araWriter.print(" := (");
            int beg = num % this._sizeBlock;
            beg = beg == 0 ? num - this._sizeBlock : num - beg;
            for (int i = beg; i < num; ++i) {
                this._araWriter.print(baseName);
                this._araWriter.print(i + 1);
                if (i + 1 >= num) continue;
                this._araWriter.print(" | ");
            }
            this._araWriter.print(");\n");
        }
        this.finishGroupMCS(idx._idx, rg + 1, force);
    }

    public void setTop(String top) {
        this._top = top;
    }

    public void write(Collection<? extends Object> mcs) throws IOException {
        int idx = this.incIdx(0);
        this._araWriter.print("g");
        this._araWriter.print(this._sepGate);
        this._araWriter.print(idx);
        this._araWriter.print(" := ");
        if (mcs.size() == 0) {
            this._araWriter.print("1");
        } else {
            this._araWriter.print("(");
            Iterator<? extends Object> iter = mcs.iterator();
            while (iter.hasNext()) {
                this._araWriter.print(iter.next().toString());
                if (!iter.hasNext()) continue;
                this._araWriter.print(" & ");
            }
            this._araWriter.print(")");
        }
        this._araWriter.print(";\n");
        this.writeGroupMCS(idx, 0);
    }

    public void close() throws IOException {
        int idx = this._idxLst.get((int)0)._idx;
        if (this._idxLst.size() == 1 && idx == 0) {
            this._araWriter.print(this._top);
            this._araWriter.print(" := 0;\n");
            return;
        }
        this.finishGroupMCS(idx, 0, false);
        int rg = this._idxLst.size() - 1;
        int num = this._idxLst.get((int)rg)._idx;
        StringBuffer sb = new StringBuffer(3 + rg * 2);
        sb.append("g");
        sb.append(this._sepGate);
        for (int i = 0; i < rg; ++i) {
            sb.append(this._sizeBlock);
            sb.append(this._sepGate);
        }
        String baseName = sb.toString();
        this._araWriter.print(this._top);
        this._araWriter.print(" := (");
        for (int i = 0; i < num; ++i) {
            this._araWriter.print(baseName);
            this._araWriter.print(i + 1);
            if (i + 1 >= num) continue;
            this._araWriter.print(" | ");
        }
        this._araWriter.print(");\n");
        this._araWriter.flush();
    }

    class Idx {
        int _idx;

        public Idx(int idx) {
            this._idx = idx;
        }
    }
}

