/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mcs.ban.aralia;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.launcher.DestinationOutputStream;
import com.dassault.cecilia.lib.ban.launcher.DestinationStopErrorStream;
import com.dassault.cecilia.lib.ban.launcher.LogExecLayoutSimple;
import com.dassault.cecilia.lib.ban.launcher.LogExecLayoutXML;
import com.dassault.cecilia.lib.ban.launcher.LogExecRecord;
import com.dassault.cecilia.lib.ban.launcher.LogExecRecorder;
import com.dassault.cecilia.lib.ban.type.LayoutDefiner;
import com.dassault.cecilia.lib.ban.type.Param;
import com.dassault.cecilia.lib.ban.type.destination;
import com.dassault.cecilia.lib.ban.util.FileUtility;
import com.dassault.cecilia.lib.ban.util.UtilFileDst;
import com.dassault.cecilia.lib.ban.util.UtilFileSrc;
import com.dassault.cecilia.lib.ban.util.UtilLaunch;
import com.dassault.cecilia.lib.mcs.ban.aralia.ItemCompute;
import com.dassault.cecilia.lib.mcs.ban.aralia.ItemMCS;
import com.dassault.cecilia.lib.mcs.ban.aralia.ItemPr;
import com.dassault.cecilia.lib.util.ControllableAction;
import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.DestinationConsole;
import com.dassault.cecilia.lib.util.destination.Layout;
import com.dassault.cecilia.lib.util.io.ProcessLauncher;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class AraliaCompute
extends Unit
implements UnitValued,
LayoutDefiner,
LogExecRecorder,
ControllableAction {
    UtilLaunch _launch = new UtilLaunch();
    String _failOnError;
    protected List<destination> _destinations = new ArrayList<destination>();
    List<Destination> _Dests;
    UtilFileSrc _src = new UtilFileSrc();
    String _root;
    String _realRoot;
    private static final String PATTERN_ID_ARALIA = "([A-Za-z][A-Za-z0-9_\\.\\-\\^]*)|('[^']+')";
    String _time;
    double _realTime = Double.NaN;
    UtilFileDst _dst = new UtilFileDst();
    String _format = Format.Aralia.name();
    Boolean _xmlFormat;
    ItemMCS _mcs;
    ArrayList<ItemCompute> _computeList = new ArrayList();
    protected List<Param> _options = new ArrayList<Param>();
    Map<String, String> _realOpts;
    protected Object _lockerLauncher = new Object();
    protected ProcessLauncher _launcher = null;
    int _result;

    public File getDir() {
        return this._launch.getDir();
    }

    public long getPriority() {
        return this._launch.getPriority();
    }

    public long getTimeout() {
        return this._launch.getTimeout();
    }

    public void setDir(String value) {
        this._launch.setDir(value);
    }

    public void setExecutable(String value) {
        this._launch.setExecutable(value);
    }

    public void setMemoryout(String value) {
        this._launch.setMemoryout(value);
    }

    public void setPriority(String value) {
        this._launch.setPriority(value);
    }

    public void setTimeout(String value) {
        this._launch.setTimeout(value);
    }

    public void setFailonerror(String value) {
        this._failOnError = value;
    }

    protected boolean failOnError() {
        boolean result = true;
        if (this._failOnError != null) {
            result = this.castBool(this.expanse(this._failOnError), "failonerror");
        }
        return result;
    }

    public destination createDestination() {
        destination app = new destination();
        this._destinations.add(app);
        return app;
    }

    @Override
    public Class<? extends Layout> configureLayout(String key, Map<String, String> params) {
        if (key.equals("default") || key.equals("txt")) {
            return LogExecLayoutSimple.class;
        }
        if (key.equals("xml")) {
            return LogExecLayoutXML.class;
        }
        throw new BanProcessException("layout unknow for diff unit : " + key);
    }

    protected void openDestination() {
        this._Dests = new ArrayList<Destination>();
        for (destination dest : this._destinations) {
            this._Dests.add(dest.constructDestination(this));
        }
    }

    @Override
    public void addRecord(LogExecRecord record) {
        if (this._Dests == null) {
            return;
        }
        for (Destination dest : this._Dests) {
            dest.publish(record);
        }
    }

    protected void closeDestination() {
        if (this._Dests == null) {
            return;
        }
        for (Destination dest : this._Dests) {
            dest.close();
        }
        this._Dests = null;
    }

    public void setSrcfile(String value) {
        this._src.setFile("srcfile", value);
    }

    public void setSrcref(String value) {
        this._src.setRef("srcref", value);
    }

    public void setRoot(String value) {
        this._root = value;
    }

    protected String getRoot() {
        if (this._realRoot != null) {
            return this._realRoot;
        }
        if (this._root != null) {
            this._realRoot = this.expanse(this._root);
            if (!Pattern.matches(PATTERN_ID_ARALIA, this._realRoot)) {
                throw new BanProcessException("Attribute 'root' must be a Aralia identifier.");
            }
        } else {
            this._realRoot = "{/root/(*)}";
        }
        return this._realRoot;
    }

    public void setTime(String value) {
        this._time = value;
    }

    protected double getTime() {
        if (Double.isNaN(this._realTime)) {
            this._realTime = 0.0;
            if (this._time != null) {
                String time = this.expanse(this._time);
                try {
                    this._realTime = Double.parseDouble(time);
                }
                catch (NumberFormatException e) {
                    throw new BanProcessException("Attribute 'time' must be double", e);
                }
                if (this._realTime < 0.0) {
                    throw new BanProcessException("Attribute 'time' must be double greater or equal to 0.");
                }
            }
        }
        return this._realTime;
    }

    public void setDestfile(String value) {
        this._dst.setFile("destfile", value);
    }

    public void setDestref(String value) {
        this._dst.setRef("destref", value);
    }

    public void setFormat(String value) {
        this._format = value;
    }

    protected boolean isXMLFormat() {
        if (this._xmlFormat == null) {
            String format = this.expanse(this._format);
            Format result = null;
            try {
                result = Format.valueOf(format);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (result == null) {
                throw new BanProcessException("Attribute 'format' not include possibles values : " + ItemPr.From.values());
            }
            this._xmlFormat = result == Format.XML;
        }
        return this._xmlFormat;
    }

    public ItemMCS createMcs() {
        if (this._mcs != null) {
            throw new BanProcessException("Only one child element 'mcs'");
        }
        this._mcs = new ItemMCS();
        this._computeList.add(this._mcs);
        return this._mcs;
    }

    public ItemMCS createMinimalcutsset() {
        return this.createMcs();
    }

    public ItemPr createPr() {
        ItemPr pr = new ItemPr();
        this._computeList.add(pr);
        return pr;
    }

    public ItemPr createProbability() {
        return this.createPr();
    }

    public Param createParam() {
        Param param = new Param();
        this._options.add(param);
        return param;
    }

    protected Map<String, String> getOptions() {
        if (this._realOpts == null) {
            this._realOpts = Param.mapParams(this._options);
        }
        return this._realOpts;
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._src.setProcess(process);
        this._dst.setProcess(process);
        this._launch.setProcess(process);
    }

    public void endValid() {
        this._src.endValid();
        this._dst.endValid();
        this._launch.endValid();
        if (this._computeList.size() == 0) {
            throw new BanProcessException("No compute define");
        }
        if (this._destinations.size() == 0) {
            destination dest = this.createDestination();
            dest.setProcess(this.getProcess());
            dest.setClass(DestinationConsole.class.getName());
        }
    }

    protected void findExecutable(ArrayList<String> cmds) {
        String execute = "aralia";
        execute = this._launch.getExecutable() != null ? this.expanse(this._launch.getExecutable()) : FileUtility.findExePath(execute, this.getClass());
        cmds.add(execute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createScript(File model, File dst) throws IOException {
        File fileCmds = this.createTempFile("aralia-cmd-", ".ara");
        this.getFinnisher().addTmpFile(fileCmds);
        String dstPath = dst.getAbsolutePath();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileCmds));){
            if (this.isXMLFormat()) {
                writer.write("echo \"");
                writer.write(this.getXMLHeader());
                writer.write("\" > \"");
                writer.write(dstPath);
                writer.write("\" ;");
                writer.newLine();
                writer.write("echo \"<aralia-compute-result>");
                writer.newLine();
                writer.write("\" >> \"");
                writer.write(dstPath);
                writer.write("\" ;");
                writer.newLine();
                writer.write("option set format XML ;");
                writer.newLine();
            } else {
                writer.write("echo \"/* Results of AraliaCompute */");
                writer.newLine();
                writer.newLine();
                writer.write("\" > \"");
                writer.write(dstPath);
                writer.write("\" ;");
                writer.newLine();
            }
            writer.write("load \"");
            writer.write(model.getAbsolutePath());
            writer.write("\" ;");
            writer.newLine();
            if (this._mcs != null) {
                this._mcs.writeMCSScript(writer, this);
            } else {
                writer.write("compute BDD to Good-BDD ");
                writer.write(this.getRoot());
                writer.write(" ;");
                writer.newLine();
            }
            for (ItemCompute item : this._computeList) {
                item.writeScript(writer, this, dst);
                if (this.isXMLFormat()) continue;
                writer.write("echo \"");
                writer.newLine();
                writer.write("\" >> \"");
                writer.write(dstPath);
                writer.write("\" ;");
                writer.newLine();
            }
            if (this.isXMLFormat()) {
                writer.write("echo \"</aralia-compute-result>");
                writer.newLine();
                writer.write("\" >> \"");
                writer.write(dstPath);
                writer.write("\" ;");
                writer.newLine();
            }
        }
        return fileCmds;
    }

    protected void initExecute() {
        this._realOpts = null;
        this._realRoot = null;
        this._realTime = Double.NaN;
        for (ItemCompute item : this._computeList) {
            item.initExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this._result = -1;
        this.initExecute();
        long timeOut = this._launch.getTimeout();
        File dir = this._launch.getDir();
        File src = this._src.getSrcFile();
        File dst = this._dst.getDstFile();
        ArrayList<String> cmds = new ArrayList<String>();
        this.findExecutable(cmds);
        this.openDestination();
        try {
            File filecmd = this.createScript(src, dst);
            cmds.add(filecmd.getAbsolutePath());
            this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "Launch [Aralia] at " + DateFormat.getDateTimeInstance().format(new Date()) + "\n"));
            this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "//------------------------------------------\n//Trace Aralia : \n"));
            DestinationStopErrorStream errorStream = new DestinationStopErrorStream(this);
            String[] cmdsArray = new String[1];
            Object object = this._lockerLauncher;
            synchronized (object) {
                this._launcher = new ProcessLauncher(new DestinationOutputStream(this, true), errorStream, new ByteArrayInputStream(new String("exit;\n").getBytes()), timeOut);
                errorStream.setProcessLauncher(this._launcher);
            }
            this._result = this._launcher.exec(cmds.toArray(cmdsArray), null, dir);
            this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "\n//------------------------------------------\n"));
            this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "ExitValue : " + this._result + " at " + DateFormat.getDateTimeInstance().format(new Date()) + "\n\n"));
            if (this._result != 0 && this.failOnError()) {
                throw new BanProcessException("AraliaCompute fail on error [result=" + this._result + "]");
            }
        }
        catch (IOException e) {
            this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "//------------------------------------------\n"));
            this.addRecord(new LogExecRecord(e));
            if (this.failOnError()) {
                throw new BanProcessException("AraliaCompute : IOException", e);
            }
        }
        finally {
            Object object = this._lockerLauncher;
            synchronized (object) {
                this._launcher = null;
            }
            this.closeDestination();
        }
    }

    @Override
    public void freeResult() {
    }

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void requestSuspend() {
    }

    @Override
    public void requestResume() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestStop() {
        Object object = this._lockerLauncher;
        synchronized (object) {
            if (this._launcher != null) {
                this._launcher.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfo(String key) {
        if (key.equals("process.msg") || key.equals("process.msg.high")) {
            Object object = this._lockerLauncher;
            synchronized (object) {
                if (this._launcher != null) {
                    return "Current process exec";
                }
            }
        }
        return null;
    }

    static enum Format {
        Aralia,
        XML;

    }
}

