/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mcs;

import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.other.JCRLabel;
import com.dassault.cecilia.plugin.mcs.MCSDiffParametersIO;
import com.dassault.cecilia.plugin.mcs.ResMCS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class MCSDiffParameters {
    String _src1FileKey;
    String _src2FileKey;
    boolean _trace;
    boolean _failure;
    protected static IOParameters _instance = new MCSDiffParametersIO();

    public String getSrc1File() {
        return this._src1FileKey;
    }

    public String getSrc2File() {
        return this._src2FileKey;
    }

    public boolean getTrace() {
        return this._trace;
    }

    public boolean getFailure() {
        return this._failure;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(ResMCS.getString("DLG_MCSDIFF_IN1FILE"));
        sb.append(" : ").append(this._src1FileKey).append("\n");
        sb.append(ResMCS.getString("DLG_MCSDIFF_IN2FILE"));
        sb.append(" : ").append(this._src2FileKey).append("\n");
        if (this._trace) {
            sb.append(ResMCS.getString("DLG_MCSDIFF_TRACE")).append("\n");
        }
        if (this._failure) {
            sb.append(ResMCS.getString("DLG_MCSDIFF_FAILURE")).append("\n");
        }
        return sb.toString();
    }

    public MCSDiffParameters() {
        this("");
    }

    public MCSDiffParameters(String style) {
        this._src1FileKey = "%{file}";
        this._src2FileKey = "%{path}/%{name}.ref";
        this._trace = true;
        this._failure = false;
    }

    public MCSDiffParameters(MCSDiffParameters src) {
        this._src1FileKey = src._src1FileKey;
        this._src2FileKey = src._src2FileKey;
        this._trace = src._trace;
        this._failure = src._failure;
    }

    public boolean change(PluginManager launcher) {
        Window win = SwingUtilities.getWindowAncestor(launcher.getWindow());
        if (win == null) {
            win = launcher.getWindow();
        }
        DlgChangeMCSDiffParameters dlg = new DlgChangeMCSDiffParameters(win);
        dlg._ctrlInput.setText(this._src1FileKey);
        dlg._ctrlOutput.setText(this._src2FileKey);
        dlg._ctrlTrace.setSelected(this._trace);
        dlg._ctrlFailure.setSelected(this._failure);
        dlg.setVisible(true);
        if (dlg.getResult()) {
            this._src1FileKey = dlg._ctrlInput.getText().trim();
            this._src2FileKey = dlg._ctrlOutput.getText().trim();
            this._trace = dlg._ctrlTrace.isSelected();
            this._failure = dlg._ctrlFailure.isSelected();
            return true;
        }
        return false;
    }

    public static IOParameters getIOParameters() {
        return _instance;
    }

    class DlgChangeMCSDiffParameters
    extends JDialogCecilia {
        JTextField _ctrlInput;
        JTextField _ctrlOutput;
        JCheckBox _ctrlTrace;
        JCheckBox _ctrlFailure;

        public DlgChangeMCSDiffParameters(Window win) {
            super(win, true);
            this.init();
        }

        protected JComponent createInOutPanel() {
            JPanel root = new JPanel(new GridBagLayout());
            int line = 0;
            root.add((Component)new JCRLabel(ResMCS.getString("DLG_MCSDIFF_IN1FILE")), new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlInput = new JTextField(20);
            root.add((Component)this._ctrlInput, new GridBagConstraints(1, line++, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            root.add((Component)new JCRLabel(ResMCS.getString("DLG_MCSDIFF_IN2FILE")), new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._ctrlOutput = new JTextField(20);
            root.add((Component)this._ctrlOutput, new GridBagConstraints(1, line, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            return root;
        }

        protected JComponent createOptionsPanel() {
            JPanel root = new JPanel(new GridBagLayout());
            root.setBorder(BorderFactory.createTitledBorder(ResMCS.getString("DLG_MCSDIFF_OPTIONS")));
            int line = 0;
            this._ctrlTrace = new JCheckBox(ResMCS.getString("DLG_MCSDIFF_TRACE"));
            root.add((Component)this._ctrlTrace, new GridBagConstraints(0, line++, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            this._ctrlFailure = new JCheckBox(ResMCS.getString("DLG_MCSDIFF_FAILURE"));
            root.add((Component)this._ctrlFailure, new GridBagConstraints(0, line, 1, 1, 10.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
            return root;
        }

        protected void init() {
            super.init();
            JPanel rPanel = new JPanel(new GridBagLayout());
            rPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            rPanel.add((Component)this.createInOutPanel(), new GridBagConstraints(0, 0, 1, 1, 10.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            rPanel.add((Component)this.createOptionsPanel(), new GridBagConstraints(0, 1, 1, 1, 10.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            rPanel.add((Component)this.createButPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)rPanel, "Center");
            this.pack();
            Dimension tSize = this.getSize();
            Dimension pSize = this.getOwner().getSize();
            Point pLoc = this.getOwner().getLocation();
            this.setLocation(pLoc.x + pSize.width / 2 - tSize.width / 2, pLoc.y + pSize.height / 2 - tSize.height / 2);
            this.setTitle(ResMCS.getString("TREAT_DIFF_NAME"));
        }

        protected boolean verifyParameters() {
            return true;
        }
    }
}

