/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mcs;

import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.plugin.mcs.MCSDiffParameters;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class MCSDiffParametersIO
implements IOParameters {
    protected static final String KEY_MCSDIFF_PARAMS = "mcsdiff-treatment";
    protected static final String KEY_FILE1 = "file1";
    protected static final String KEY_FILE2 = "file2";
    protected static final String KEY_TRACE = "trace";
    protected static final String KEY_FAILURE = "failure";

    MCSDiffParametersIO() {
    }

    public void writeXML(Writer out, Object parameters, PluginManager launcher) throws IOException {
        if (!(parameters instanceof MCSDiffParameters)) {
            throw new IOException("Unsupported object for MCSDiffParametersIO");
        }
        MCSDiffParameters mcsdiff = (MCSDiffParameters)parameters;
        out.write("      <");
        out.write(KEY_MCSDIFF_PARAMS);
        out.write(" ");
        out.write(KEY_FILE1);
        out.write("=\"");
        out.write(mcsdiff.getSrc1File());
        out.write("\"");
        out.write(" ");
        out.write(KEY_FILE2);
        out.write("=\"");
        out.write(mcsdiff.getSrc2File());
        out.write("\"");
        out.write(" ");
        out.write(KEY_TRACE);
        out.write("=\"");
        out.write(Boolean.toString(mcsdiff.getTrace()));
        out.write("\"");
        out.write(" ");
        out.write(KEY_FAILURE);
        out.write("=\"");
        out.write(Boolean.toString(mcsdiff.getFailure()));
        out.write("\"");
        out.write("/>\n");
    }

    public Object readXML(Node node, PluginManager launcher) {
        if (node.getNodeType() != 1) {
            return null;
        }
        Element root = (Element)node;
        if (!root.getNodeName().equals(KEY_MCSDIFF_PARAMS)) {
            return null;
        }
        MCSDiffParameters mcsdiff = new MCSDiffParameters();
        Node attr = root.getAttributes().getNamedItem(KEY_FILE1);
        if (attr != null) {
            mcsdiff._src1FileKey = attr.getNodeValue();
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_FILE2)) != null) {
            mcsdiff._src2FileKey = attr.getNodeValue();
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_TRACE)) != null) {
            mcsdiff._trace = Boolean.parseBoolean(attr.getNodeValue());
        }
        if ((attr = root.getAttributes().getNamedItem(KEY_FAILURE)) != null) {
            mcsdiff._failure = Boolean.parseBoolean(attr.getNodeValue());
        }
        return mcsdiff;
    }
}

