/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.cstepper.opt;

import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.inference.StepperInference;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.cstepper.ResCStep;
import com.dassault.cecilia.plugin.mbsa.cstepper.opt.DlgTargetsIAralia;
import com.dassault.cecilia.plugin.mbsa.cstepper.opt.PluginCmdITree;
import com.dassault.cecilia.plugin.mbsa.cstepper.opt.TaskIAralia;
import com.dassault.cecilia.plugin.mbsa.cstepper.opt.TaskITree;
import com.dassault.cecilia.plugin.mbsa.viewer.DlgTargetsSelection;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PluginCmdIAralia
extends PluginCmdITree {
    public static final String OPT_EXEC_ARALIA = PluginCmdIAralia.class.getName() + "#Execute";
    public static final String OPT_SCRIPT = PluginCmdIAralia.class.getName() + "#Script";
    public static final String OPT_SCRIPT_DEFAULT = "compute BDD roots(*);\ncompute ZQC roots(*);\ndisplay orders ZQC roots(*);\ndisplay orders ZQC roots(*) > \"%res%\";\ndisplay products ZQC roots(*) >> \"%res%\";\n";
    IAraliaOptsPanel _optsIAralia = null;

    protected PluginCmdIAralia() {
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCStep.getString("PLUG_CMD_IARALIA_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResCStep.getString("PLUG_CMD_IARALIA_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    @Override
    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A2-01.svg"));
        }
        return super.getIcon(key);
    }

    @Override
    public boolean withOption(Plugable plugable) {
        return true;
    }

    @Override
    public PlugPanel displayOption(Plugable launcher) {
        if (this._optsIAralia == null) {
            this._optsIAralia = new IAraliaOptsPanel();
        }
        this._optsIAralia.prepareWith(launcher);
        return this._optsIAralia;
    }

    @Override
    public void refreshOptions(Plugable launcher) {
        if (this._optsIAralia != null) {
            this._optsIAralia.prepareWith(launcher);
        }
    }

    @Override
    protected DlgTargetsSelection createComputeOpts(Plugable launcher, Stepper stepper) {
        ViewStepper viewStepper = new ViewStepper();
        try {
            viewStepper.open(stepper);
        }
        catch (StepperException e) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResCStep.getString("ERR_STEPPER_EXC") + "\n" + e.getMessage(), this.getInfo("plugin.name"), 0);
            return null;
        }
        viewStepper.getRoot().setWithDomain(true);
        TargetModel defTgt = new TargetModel();
        defTgt.defineDefault(launcher, viewStepper, null);
        DlgTargetsIAralia dlg = new DlgTargetsIAralia(launcher.getWindow());
        dlg.create(defTgt);
        dlg.enableDbOutput(launcher.getAppl() != null && !launcher.getAppl().isReader());
        if (!dlg.doModal(launcher)) {
            dlg = null;
        }
        viewStepper.close();
        return dlg;
    }

    protected void createTask(Plugable launcher, IModel model, List<TargetModel> tgts, Object dataInference) {
        File fileInfo = this.createFile(launcher, "IAralia", ".log");
        if (fileInfo == null) {
            return;
        }
        TaskIAralia task = new TaskIAralia(launcher, model, (StepperInference)dataInference, fileInfo.getAbsolutePath());
        Iterator<TargetModel> i = tgts.iterator();
        while (i.hasNext()) {
            ((TaskITree)task).addCompute(i.next());
        }
        launcher.addTask((PlugTask)task, model.getUID());
    }

    class IAraliaOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JLabel _lblExec;
        JTextField _ctrlExec;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlExec.setText(PlugableUtility.getStrOpt((Plugable)this._launcher, (String)OPT_EXEC_ARALIA, (String)"aralia"));
        }

        public IAraliaOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            this._lblExec = new JLabel(ResCStep.getString("DLG_OPT_IARALIA_EXEC"));
            this._ctrlExec = new JTextField(40);
            this._ctrlExec.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    IAraliaOptsPanel.this._launcher.setOption(OPT_EXEC_ARALIA, IAraliaOptsPanel.this._ctrlExec.getText());
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.add((Component)this._lblExec, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._ctrlExec, new GridBagConstraints(0, 1, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        }

        public Component getPanel() {
            return this;
        }

        public void trash() {
        }

        public String getInfo(String key) {
            return PluginCmdIAralia.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }
}

