/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.cstepper.opt;

import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMStepper;
import com.dassault.cecilia.lib.ban.BanEntry;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mbsa.cstepper.BanInferencePlugin;
import com.dassault.cecilia.plugin.mbsa.cstepper.PluginInference;
import com.dassault.cecilia.plugin.mbsa.cstepper.ResCStep;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class PluginStepperInference
extends PluginInference
implements PluginMStepper {
    public static final String OPT_LOOP = PluginStepperInference.class.getName() + "#SimulLoop";
    StepperInferenceOptsPanel _opts = null;

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCStep.getString("PLUG_STEPPER_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResCStep.getString("PLUG_STEPPER_DESC");
        }
        if (key.equals("type")) {
            return "PluginStepper";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("A2-02.svg"));
        }
        return super.getIcon(key);
    }

    public boolean withOption(Plugable plugable) {
        return true;
    }

    public PlugPanel displayOption(Plugable launcher) {
        if (this._opts == null) {
            this._opts = new StepperInferenceOptsPanel();
        }
        this._opts.prepareWith(launcher);
        return this._opts;
    }

    public void refreshOptions(Plugable launcher) {
        if (this._opts != null) {
            this._opts.prepareWith(launcher);
        }
    }

    public Stepper createStepper(Plugable launcher, Object parameters) {
        if (this.verifyPluginTranslator(launcher) == null) {
            return null;
        }
        IModel model = launcher.getModel("altarica.file");
        if (model == null) {
            return null;
        }
        BanInferencePlugin plugInf = new BanInferencePlugin(model){

            @Override
            protected void prepareBanEntry(Plugable launch, Object ... objects) {
                super.prepareBanEntry(launch, objects);
                BanEntry ban = this.getBanEntry();
                ban.setUserProperty("altr.input", this.getModel().getFile().getAbsolutePath());
                ban.setUserProperty("altr.main", this.getModel().getName());
                ban.setUserProperty("simulator.loop", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)OPT_LOOP, (boolean)false)));
                ban.setUserProperty("instantaneous.auto", Boolean.toString(PlugableUtility.getBoolOpt((Plugable)launch, (String)Stepper.OPTION_INSTANTANEOUS_AUTO, (boolean)true)));
                String instLoop = PlugableUtility.getStrOpt((Plugable)launch, (String)Stepper.OPTION_INSTANTANEOUS_LOOP, (String)Integer.toString(100));
                try {
                    int value = Integer.parseInt(instLoop);
                    if (value > 0) {
                        ban.setUserProperty("instantaneous.loop", Integer.toString(value));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        BanEntry ban = plugInf.banExecute(launcher, null, new Object[0]);
        if (ban != null) {
            return (Stepper)ban.getIdObject("stepper-id");
        }
        return null;
    }

    class StepperInferenceOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JCheckBox _ctrlLoop;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlLoop.setSelected(PlugableUtility.getBoolOpt((Plugable)this._launcher, (String)OPT_LOOP, (boolean)false));
        }

        public StepperInferenceOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            JPanel root = new JPanel(new GridBagLayout());
            root.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ResCStep.getString("PLUG_STEPPER_NAME")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            this._ctrlLoop = new JCheckBox(ResCStep.getString("DLG_OPT_STEPPER_LOOP"));
            this._ctrlLoop.setHorizontalTextPosition(2);
            this._ctrlLoop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StepperInferenceOptsPanel.this._launcher.setOption(OPT_LOOP, StepperInferenceOptsPanel.this._ctrlLoop.isSelected() ? "true" : "false");
                }
            });
            root.add((Component)this._ctrlLoop, new GridBagConstraints(0, 0, 2, 1, 100.0, 100.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)root, new GridBagConstraints(0, 0, 1, 1, 100.0, 100.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        public Component getPanel() {
            return this;
        }

        public void trash() {
        }

        public String getInfo(String key) {
            return PluginStepperInference.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }
}

