/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.cstepper.opt;

import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.plugin.mbsa.cstepper.ResCStep;
import com.dassault.cecilia.plugin.mbsa.cstepper.opt.PluginCmdISeq;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetModel;
import com.dassault.cecilia.plugin.mbsa.viewer.TargetsPanel;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Robot;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TargetsISeqPanel
extends TargetsPanel {
    private JCheckBox _ctrlEvtLooker;
    private JCheckBox _ctrlDisplayCuts;
    private JCheckBox _ctrlFastGenerator;
    JRadioButton _ctrlSeqComb;
    JRadioButton _ctrlSeqPermut;
    JRadioButton _ctrlSeqRepeat;

    public TargetsISeqPanel(TargetModel def, String title) {
        super(def, title);
    }

    protected JPanel createOtherInfoPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        this._ctrlEvtLooker = new JCheckBox(ResCStep.getString("PRV_CMD_ISEQ_EVT_LOOKER"));
        this._ctrlDisplayCuts = new JCheckBox(ResCStep.getString("PRV_CMD_ISEQ_DISPLAY_CUTS"));
        this._ctrlFastGenerator = new JCheckBox(ResCStep.getString("PRV_CMD_ISEQ_FAST_GENERATOR"));
        Box seqType = Box.createVerticalBox();
        seqType.setBorder(BorderFactory.createTitledBorder(ResCStep.getString("PRV_CMD_ISEQ_TYPE")));
        ButtonGroup grp = new ButtonGroup();
        this._ctrlSeqComb = new JRadioButton(ResCStep.getString("PRV_CMD_ISEQ_TYPE_COMB"));
        this._ctrlSeqComb.setToolTipText(ResCStep.getString("PRV_CMD_ISEQ_TYPE_COMB_TOOLTIP"));
        grp.add(this._ctrlSeqComb);
        seqType.add(this._ctrlSeqComb);
        this._ctrlSeqPermut = new JRadioButton(ResCStep.getString("PRV_CMD_ISEQ_TYPE_PERMUT"));
        this._ctrlSeqPermut.setToolTipText(ResCStep.getString("PRV_CMD_ISEQ_TYPE_PERMUT_TOOLTIP"));
        grp.add(this._ctrlSeqPermut);
        seqType.add(this._ctrlSeqPermut);
        this._ctrlSeqRepeat = new JRadioButton(ResCStep.getString("PRV_CMD_ISEQ_TYPE_REPEAT"));
        this._ctrlSeqRepeat.setToolTipText(ResCStep.getString("PRV_CMD_ISEQ_TYPE_REPEAT_TOOLTIP"));
        grp.add(this._ctrlSeqRepeat);
        seqType.add(this._ctrlSeqRepeat);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridheight = 3;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 100.0;
        gbc.weightx = 100.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        result.add((Component)seqType, gbc);
        ++gbc.gridx;
        result.add(Box.createHorizontalStrut(15), gbc);
        ++gbc.gridx;
        gbc.gridheight = 1;
        result.add((Component)this._ctrlEvtLooker, gbc);
        ++gbc.gridy;
        result.add((Component)this._ctrlDisplayCuts, gbc);
        ++gbc.gridy;
        result.add((Component)this._ctrlFastGenerator, gbc);
        return result;
    }

    public void copyToCtrl(Plugable launcher) {
        super.copyToCtrl(launcher);
        this._ctrlEvtLooker.setSelected(PlugableUtility.getBoolOpt((Plugable)launcher, (String)PluginCmdISeq.OPT_EVT_LOCKER, (boolean)true));
        this._ctrlDisplayCuts.setSelected(PlugableUtility.getBoolOpt((Plugable)launcher, (String)PluginCmdISeq.OPT_DISPLAY_CUTS, (boolean)true));
        this._ctrlFastGenerator.setSelected(PlugableUtility.getBoolOpt((Plugable)launcher, (String)PluginCmdISeq.OPT_FAST_GENERATOR, (boolean)false));
        String value = launcher.getOption(PluginCmdISeq.OPT_TYPE);
        if (value == null) {
            this._ctrlSeqPermut.setSelected(true);
        } else if (value.equalsIgnoreCase("Comb")) {
            this._ctrlSeqComb.setSelected(true);
        } else if (value.equalsIgnoreCase("Repeat")) {
            this._ctrlSeqRepeat.setSelected(true);
        } else {
            this._ctrlSeqPermut.setSelected(true);
        }
    }

    public void copyFromCtrl(Plugable launcher) {
        super.copyFromCtrl(launcher);
        String value = "Permut";
        if (this._ctrlSeqComb.isSelected()) {
            value = "Comb";
        } else if (this._ctrlSeqRepeat.isSelected()) {
            value = "Repeat";
        }
        launcher.setOption(PluginCmdISeq.OPT_TYPE, value);
        String trueStr = "true";
        String falseStr = "false";
        launcher.setOption(PluginCmdISeq.OPT_DISPLAY_CUTS, this._ctrlDisplayCuts.isSelected() ? trueStr : falseStr);
        launcher.setOption(PluginCmdISeq.OPT_EVT_LOCKER, this._ctrlEvtLooker.isSelected() ? trueStr : falseStr);
        launcher.setOption(PluginCmdISeq.OPT_FAST_GENERATOR, this._ctrlFastGenerator.isSelected() ? trueStr : falseStr);
    }

    protected void testUI() {
        Point pt = this.getLocation();
        Dimension sz = this.getSize();
        try {
            Robot robot = new Robot();
            int xBeg = pt.x;
            int yBeg = pt.y;
            int xEnd = pt.x + sz.width;
            int yEnd = pt.y + sz.height;
            int nbr = 30;
            int delay = 100;
            for (int i = 1; i <= nbr; ++i) {
                robot.mouseMove(xBeg + (xEnd - xBeg) * i / nbr, yBeg + (yEnd - yBeg) * i / nbr);
                robot.delay(delay);
            }
            xBeg = pt.x + sz.width / 2;
            yBeg = pt.y + sz.height / 2;
            delay = 250;
            int button = 1024;
            robot.mouseMove(xBeg, yBeg);
            robot.delay(delay);
            robot.mousePress(button);
            robot.delay(delay);
            robot.mouseRelease(button);
            JRadioButton ctrl = this._ctrlSeqComb;
            Point ptCtrl = ctrl.getLocationOnScreen();
            Dimension szCtrl = ctrl.getSize();
            xBeg = ptCtrl.x + szCtrl.width / 2;
            yBeg = ptCtrl.y + szCtrl.height / 2;
            delay = 250;
            button = 1024;
            robot.mouseMove(xBeg, yBeg);
            robot.delay(delay);
            robot.mousePress(button);
            robot.delay(delay);
            robot.mouseRelease(button);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }
}

