/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.plugin.faulttree.compute.BooleanEvt;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import java.util.Arrays;
import java.util.List;

public class BooleanCut
implements Cut {
    BooleanEvt[] _cuts;
    double _probability;
    public static final char FLAG_NO = '\u0000';
    public static final char FLAG_MEL_WITH = '\u1000';
    public static final char FLAG_MEL_IGNORE = '\u2000';
    char _flag = '\u0000';

    public BooleanCut(List<? extends BooleanEvt> cuts, boolean sort) {
        int size = cuts.size();
        this._cuts = new BooleanEvt[size];
        this._cuts = cuts.toArray(this._cuts);
        if (sort) {
            Arrays.sort(this._cuts, BooleanMCS.__COMPARE_EVENTS);
        }
        this._probability = Double.NaN;
    }

    @Override
    public int getOrder() {
        return this._cuts.length;
    }

    @Override
    public double getProbability() {
        return this._probability;
    }

    public double setProbability(double proba) {
        this._probability = proba;
        return this._probability;
    }

    public char getFlag() {
        return this._flag;
    }

    public void setFlag(char value) {
        this._flag = value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int j = 0; j < this._cuts.length; ++j) {
            if (j > 0) {
                sb.append(", ");
            }
            sb.append(this._cuts[j].getName());
        }
        sb.append("}");
        if (!Double.isNaN(this._probability)) {
            sb.append("=").append(this._probability);
        }
        return sb.toString();
    }

    @Override
    public BooleanEvt getEvent(int idx) {
        return this._cuts[idx];
    }
}

