/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.plugin.faulttree.compute.BooleanParser;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BooleanExpression {
    private static Logger _LOG = Logger.getLogger(BooleanExpression.class.getPackage().getName());
    private static final Pattern PATTERN_ID = Pattern.compile("['`]([^'\\[]+)\\[([0-9]+)\\]'");

    public abstract double getValue(double var1);

    public abstract boolean convert(BooleanStore var1);

    public abstract void export(Appendable var1, ArborRenderer var2) throws IOException;

    public double getLambda() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static BooleanExpression createNamedParameter(String name, String value) {
        return new NamedParameter(name, value);
    }

    public static BooleanExpression createParameterFloat(double value) {
        return new ParameterFloat(value);
    }

    public static BooleanExpression createParameterNamed(String name) {
        return new ParameterNamed(name);
    }

    public static BooleanExpression createParameterLaw(TypeParameterLaw type, Object ... params) {
        return new ParameterLaw(type, params);
    }

    public static BooleanExpression createLaw(TypeLaw type, Object ... params) {
        return new Law(type, params);
    }

    public static BooleanExpression createLawFactor(BooleanExpression law, Object ... params) {
        return new ComposedLaw(TypeLaw.FACTOR, law, params);
    }

    public static BooleanExpression createLawBound(BooleanExpression law, Object ... params) {
        return new ComposedLaw(TypeLaw.BOUND, law, params);
    }

    public static double verifyPrba(double value) {
        if (value < 0.0) {
            return 0.0;
        }
        if (value > 1.0) {
            return 1.0;
        }
        return value;
    }

    public static double verifyRate(double value) {
        if (value < 0.0) {
            return 0.0;
        }
        return value;
    }

    public static double verifyDate(double value) {
        if (value < 0.0) {
            return 0.0;
        }
        return value;
    }

    public static double verifyBool(double value) {
        if (value == 0.0) {
            return 0.0;
        }
        return 1.0;
    }

    private static double computeFullTestPeriodic(double lambda, double lambdaStar, double mu, double tau, double theta, double gamma, double pi, double x, double sigma, double omega, double T) {
        if (T < theta) {
            return 1.0 - Math.exp(-lambda * T);
        }
        double A = Math.exp(-lambda * theta);
        double F = 1.0 - A;
        double R = 0.0;
        double t = theta;
        while (true) {
            boolean stop;
            double dt;
            if (T < t + pi) {
                dt = T - t;
                stop = true;
            } else {
                dt = pi;
                stop = false;
            }
            double A1 = 0.0;
            double F1 = 0.0;
            double R1 = 0.0;
            double A2 = A * (1.0 - gamma);
            double F2 = A * gamma;
            double pf = Math.exp(-lambdaStar * dt);
            A1 += A2 * pf;
            F1 += (F2 += A2 * (1.0 - pf)) * (1.0 - sigma);
            R1 += F2 * sigma;
            F1 += F * (1.0 - sigma);
            R1 += F * sigma;
            double pr = Math.exp(-mu * dt);
            pf = lambda == mu ? mu * dt * pr : mu / (mu - lambda) * (Math.exp(-lambda * dt) - pr);
            double R2 = R * pr;
            A2 = R * (1.0 - omega) * pf;
            F2 = R - R2 - A2;
            A = A1 += A2;
            F = F1 += F2;
            R = R1 += R2;
            if (stop) {
                return x == 0.0 ? 1.0 - A2 : 1.0 - A;
            }
            if (T < t + tau) {
                dt = T - t - pi;
                stop = true;
            } else {
                dt = tau - pi;
                stop = false;
            }
            A1 = 0.0;
            F1 = 0.0;
            R1 = 0.0;
            pf = Math.exp(-lambda * dt);
            A1 += A * pf;
            F1 += A * (1.0 - pf);
            F1 += F;
            pr = Math.exp(-mu * dt);
            pf = lambda == mu ? mu * dt * pr : mu / (mu - lambda) * (Math.exp(-lambda * dt) - pr);
            R2 = R * pr;
            A2 = R * (1.0 - omega) * pf;
            F2 = R - R2 - A2;
            A = A1 += A2;
            F = F1 += F2;
            R = R1 += R2;
            if (stop) {
                return 1.0 - A;
            }
            t += tau;
        }
    }

    public static void exportXML(BooleanExpression expression, double defValue, Appendable writer, String indent, ArborRenderer renderer) throws IOException {
        if (expression instanceof Law) {
            Law law = (Law)expression;
            writer.append(indent).append("<").append(law._type.getXMLExport()).append(">\n");
            if (law._type == TypeLaw.CST && law._parameters.length == 0 && !Double.isNaN(defValue)) {
                writer.append(indent).append("<VALUE_PARAMETER VALUE=\"").append(renderer.formatNumber(defValue)).append("\">");
                writer.append("</VALUE_PARAMETER>\n");
            } else {
                for (BooleanExpression param : law._parameters) {
                    BooleanExpression.exportXML(param, Double.NaN, writer, indent + "\t", renderer);
                }
            }
            writer.append(indent).append("</").append(law._type.getXMLExport()).append(">\n");
        } else if (expression instanceof ParameterFloat) {
            ParameterFloat param = (ParameterFloat)expression;
            writer.append(indent).append("<VALUE_PARAMETER VALUE=\"").append(renderer.formatNumber(param._value)).append("\">");
            writer.append("</VALUE_PARAMETER>\n");
        } else if (expression instanceof ParameterLaw) {
            ParameterLaw law = (ParameterLaw)expression;
            switch (law._type) {
                case UNIF: {
                    writer.append(indent).append("<UNIFORM").append(" MIN=\"").append(renderer.formatNumber(law._parameters[0].getValue(1.0))).append("\" MAX=\"").append(renderer.formatNumber(law._parameters[1].getValue(1.0))).append("\">");
                    writer.append("</UNIFORM>\n");
                    break;
                }
                case NLOG: {
                    writer.append(indent).append("<LOGNORMAL").append(" MEAN=\"").append(renderer.formatNumber(law._parameters[0].getValue(1.0))).append("\" ERROR=\"").append(renderer.formatNumber(law._parameters[1].getValue(1.0))).append("\">");
                    writer.append("</LOGNORMAL>\n");
                    break;
                }
                case NORM: {
                    writer.append(indent).append("<NORMAL").append(" MEAN=\"").append(renderer.formatNumber(law._parameters[0].getValue(1.0))).append("\" STDDEV=\"").append(renderer.formatNumber(law._parameters[1].getValue(1.0))).append("\">");
                    writer.append("</NORMAL>\n");
                }
            }
        } else if (expression instanceof ParameterNamed) {
            ParameterNamed param = (ParameterNamed)expression;
            String strParam = param.toString();
            if (strParam.length() > 2 && strParam.startsWith("'") && strParam.endsWith("'")) {
                writer.append(indent).append("<PARAMETER_REF VALUE=\"").append(strParam.substring(1, strParam.length() - 1)).append("\">");
                writer.append("</PARAMETER_REF>\n");
            } else {
                Matcher matcher = PATTERN_ID.matcher(param.toString());
                if (matcher.matches()) {
                    writer.append(indent).append("<PARAMETER_REF VALUE=\"").append(matcher.group(1)).append("/").append(matcher.group(2)).append("\">");
                    writer.append("</PARAMETER_REF>\n");
                } else {
                    _LOG.severe("The named parameter '" + param.toString() + "' unmatched");
                }
            }
        } else if (expression instanceof ComposedLaw) {
            ComposedLaw composedLaw = (ComposedLaw)expression;
            if (composedLaw._type == TypeLaw.BOUND) {
                Law law = (Law)composedLaw._delegate;
                writer.append(indent).append("<").append(law._type.getXMLExport()).append(">\n");
                writer.append(indent).append("\t<").append(composedLaw._type.getXMLExport()).append(" BEGIN=\"").append(renderer.formatNumber(composedLaw._parameters[0].getValue(1.0))).append("\" DURATION=\"").append(renderer.formatNumber(composedLaw._parameters[1].getValue(1.0))).append("\">");
                writer.append("</").append(composedLaw._type.getXMLExport()).append(">\n");
                for (BooleanExpression param : law._parameters) {
                    BooleanExpression.exportXML(param, defValue, writer, indent + "\t", renderer);
                }
                writer.append(indent).append("</").append(law._type.getXMLExport()).append(">\n");
            }
        }
    }

    public static class NamedParameter
    extends BooleanExpression {
        String _name;
        Object _delegate;

        NamedParameter(String name, String value) {
            this._name = name;
            this._delegate = value;
        }

        @Override
        public boolean convert(BooleanStore store) {
            BooleanParser parser = store.getParser();
            parser.restart(new StringReader(this._delegate.toString()), 278);
            parser.run();
            if (!parser.withError()) {
                this._delegate = parser.getBooleanExpression();
                return true;
            }
            return false;
        }

        @Override
        public double getValue(double missionTime) {
            return ((BooleanExpression)this._delegate).getValue(missionTime);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._name);
            sb.append("[=").append(this.getValue(0.0)).append("]");
            return sb.toString();
        }

        @Override
        public void export(Appendable output, ArborRenderer renderer) throws IOException {
            output.append(this._name);
            output.append("[=");
            ((BooleanExpression)this._delegate).export(output, renderer);
            output.append("]");
        }
    }

    public static class ParameterFloat
    extends BooleanExpression {
        double _value;

        ParameterFloat(double value) {
            this._value = value;
        }

        @Override
        public boolean convert(BooleanStore store) {
            return true;
        }

        @Override
        public double getValue(double missionTime) {
            return this._value;
        }

        public String toString() {
            return Double.toString(this._value);
        }

        @Override
        public void export(Appendable output, ArborRenderer renderer) throws IOException {
            output.append(renderer.formatNumber(this._value));
        }
    }

    public static class ParameterNamed
    extends BooleanExpression {
        Object _delegate;

        ParameterNamed(String name) {
            this._delegate = name;
        }

        @Override
        public boolean convert(BooleanStore store) {
            String name = (String)this._delegate;
            this._delegate = store.getNamedParameter(name);
            return this._delegate != null;
        }

        @Override
        public double getValue(double missionTime) {
            return ((BooleanExpression)this._delegate).getValue(missionTime);
        }

        public String toString() {
            if (this._delegate instanceof NamedParameter) {
                return ((NamedParameter)this._delegate)._name;
            }
            return this._delegate.toString();
        }

        @Override
        public void export(Appendable output, ArborRenderer renderer) throws IOException {
            if (this._delegate instanceof NamedParameter) {
                output.append(((NamedParameter)this._delegate)._name);
            } else if (this._delegate instanceof BooleanExpression) {
                ((NamedParameter)this._delegate).export(output, renderer);
            } else {
                output.append(this._delegate.toString());
            }
        }
    }

    public static class ParameterLaw
    extends AbstractLaw {
        TypeParameterLaw _type;

        ParameterLaw(TypeParameterLaw type, Object[] params) {
            super(params);
            this._type = type;
        }

        @Override
        public boolean convert(BooleanStore store) {
            if (this._parameters.length != 2) {
                return false;
            }
            return super.convert(store);
        }

        @Override
        public double getValue(double missionTime) {
            switch (this._type) {
                case UNIF: {
                    return (this._parameters[0].getValue(missionTime) + this._parameters[1].getValue(missionTime)) / 2.0;
                }
                case NLOG: {
                    return this._parameters[0].getValue(missionTime);
                }
                case NORM: {
                    return this._parameters[0].getValue(missionTime);
                }
            }
            return Double.NaN;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._type.getExport());
            this.appendParameters(sb);
            return sb.toString();
        }

        @Override
        public void export(Appendable output, ArborRenderer renderer) throws IOException {
            output.append(this._type.getExport());
            this.exportParameters(output, renderer);
        }
    }

    public static enum TypeParameterLaw {
        UNIF("uniform"),
        NORM("normal"),
        NLOG("nlog");

        String _export;

        String getExport() {
            return this._export;
        }

        private TypeParameterLaw(String export) {
            this._export = export;
        }
    }

    public static class Law
    extends AbstractLaw {
        TypeLaw _type;

        Law(TypeLaw type, Object[] params) {
            super(params);
            this._type = type;
        }

        @Override
        public boolean convert(BooleanStore store) {
            switch (this._type) {
                case CST: 
                case EXP: {
                    if (this._parameters.length == 1) break;
                    return false;
                }
                case NRD: 
                case GLMa: {
                    if (this._parameters.length == 2) break;
                    return false;
                }
                case GLM: 
                case WEB: 
                case PT3: 
                case CMT: 
                case DRM: {
                    if (this._parameters.length == 3) break;
                    return false;
                }
                case PT4: {
                    if (this._parameters.length == 4) break;
                    return false;
                }
                case PT10: {
                    if (this._parameters.length == 10) break;
                    return false;
                }
            }
            return super.convert(store);
        }

        @Override
        public double getValue(double computeTime) {
            switch (this._type) {
                case CST: {
                    return Law.verifyPrba(this._parameters[0].getValue(computeTime));
                }
                case EXP: {
                    double lbd = Law.verifyRate(this._parameters[0].getValue(computeTime));
                    return 1.0 - Math.exp(-lbd * computeTime);
                }
                case NRD: {
                    double mu = Law.verifyRate(this._parameters[0].getValue(computeTime));
                    double duree = Law.verifyDate(this._parameters[1].getValue(computeTime));
                    return Math.exp(-mu * duree);
                }
                case GLMa: {
                    double l = Law.verifyRate(this._parameters[0].getValue(computeTime));
                    double m = Law.verifyRate(this._parameters[1].getValue(computeTime));
                    return l / (l + m);
                }
                case GLM: {
                    double g = Law.verifyPrba(this._parameters[0].getValue(computeTime));
                    double l = Law.verifyRate(this._parameters[1].getValue(computeTime));
                    double m = Law.verifyRate(this._parameters[2].getValue(computeTime));
                    return l / (l + m) - (l - g * (l + m)) / (l + m) * Math.exp(-(l + m) * computeTime);
                }
                case WEB: {
                    double value;
                    double t;
                    double alpha = this._parameters[0].getValue(computeTime);
                    double beta = this._parameters[1].getValue(computeTime);
                    double t0 = this._parameters[2].getValue(computeTime);
                    double d = t = computeTime < t0 ? 0.0 : computeTime - t0;
                    if (alpha <= 0.0) {
                        alpha = 1.0E-9;
                    }
                    if (beta <= 0.0) {
                        beta = 1.0E-9;
                    }
                    if ((value = 1.0 - Math.exp(-Math.pow(t / alpha, beta))) < 0.0) {
                        value = 0.0;
                    }
                    if (value > 1.0) {
                        value = 1.0;
                    }
                    return value;
                }
                case PT3: {
                    double lambda = Law.verifyRate(this._parameters[0].getValue(computeTime));
                    double period = Law.verifyDate(this._parameters[1].getValue(computeTime));
                    double t0 = this._parameters[2].getValue(computeTime);
                    double t = computeTime;
                    if (t >= t0) {
                        t = computeTime - t0;
                        t -= period * Math.floor(t / period);
                    }
                    double value = 1.0 - Math.exp(-lambda * t);
                    return Law.verifyPrba(value);
                }
                case CMT: {
                    double lbd = Law.verifyRate(this._parameters[0].getValue(computeTime));
                    double MT = Law.verifyDate(this._parameters[1].getValue(computeTime));
                    double Q = Law.verifyPrba(this._parameters[2].getValue(computeTime));
                    return Law.verifyPrba(Q + 1.0 - Math.exp(-lbd * MT));
                }
                case DRM: {
                    double lambda = Law.verifyRate(this._parameters[0].getValue(computeTime));
                    double MTTR = Law.verifyDate(this._parameters[1].getValue(computeTime));
                    double delay = Law.verifyDate(this._parameters[2].getValue(computeTime));
                    double d = lambda * delay;
                    double e = 1.0 - Math.exp(-lambda * delay);
                    double m = lambda * MTTR * e;
                    double value = (d - e + m) / (d + m);
                    return Law.verifyPrba(value);
                }
                case PT4: {
                    double lambda = Law.verifyRate(this._parameters[0].getValue(computeTime));
                    double mu = Law.verifyRate(this._parameters[1].getValue(computeTime));
                    double tau = Law.verifyDate(this._parameters[2].getValue(computeTime));
                    double theta = Law.verifyDate(this._parameters[3].getValue(computeTime));
                    double lambdaStar = lambda;
                    double gamma = 0.0;
                    double pi = 0.0;
                    double x = 1.0;
                    double sigma = 1.0;
                    double omega = 0.0;
                    return BooleanExpression.computeFullTestPeriodic(lambda, lambdaStar, mu, tau, theta, gamma, pi, x, sigma, omega, computeTime);
                }
                case PT10: {
                    double lambda = Law.verifyRate(this._parameters[0].getValue(computeTime));
                    double lambdaStar = Law.verifyRate(this._parameters[1].getValue(computeTime));
                    double mu = Law.verifyRate(this._parameters[2].getValue(computeTime));
                    double tau = Law.verifyDate(this._parameters[3].getValue(computeTime));
                    double theta = Law.verifyDate(this._parameters[4].getValue(computeTime));
                    double gamma = Law.verifyPrba(this._parameters[5].getValue(computeTime));
                    double pi = Law.verifyDate(this._parameters[6].getValue(computeTime));
                    double x = Law.verifyBool(this._parameters[7].getValue(computeTime));
                    double sigma = Law.verifyPrba(this._parameters[8].getValue(computeTime));
                    double omega = Law.verifyPrba(this._parameters[9].getValue(computeTime));
                    return BooleanExpression.computeFullTestPeriodic(lambda, lambdaStar, mu, tau, theta, gamma, pi, x, sigma, omega, computeTime);
                }
            }
            return Double.NaN;
        }

        @Override
        public double getLambda() throws UnsupportedOperationException {
            if (this._type == TypeLaw.EXP) {
                return Law.verifyRate(this._parameters[0].getValue(0.0));
            }
            throw new UnsupportedOperationException();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._type.getExport());
            this.appendParameters(sb);
            return sb.toString();
        }

        @Override
        public void export(Appendable output, ArborRenderer renderer) throws IOException {
            output.append(this._type.getExport());
            this.exportParameters(output, renderer);
        }
    }

    public static enum TypeLaw {
        CST("constant", "CONSTANT"),
        EXP("exponential", "EXPONENTIAL"),
        GLM("GLM", "GLM"),
        GLMa("GLM-asymptotic", "GLM_ASYMP"),
        WEB("Weibull", "WEIBULL"),
        PT3("periodic-test", "PERIODIC"),
        PT4("periodic-test", "PERIODIC_E"),
        PT10("periodic-test", "PERIODIC_C"),
        CMT("CMT", "CMT"),
        DRM("dormant", "DORMANT"),
        NRD("NRD", "NRD"),
        FACTOR("factor", "FACTOR"),
        BOUND("bound-time", "BOUND");

        String _export;
        String _xmlExport;

        String getExport() {
            return this._export;
        }

        String getXMLExport() {
            return this._xmlExport;
        }

        private TypeLaw(String export, String xmlExport) {
            this._export = export;
            this._xmlExport = xmlExport;
        }
    }

    public static class ComposedLaw
    extends AbstractLaw {
        TypeLaw _type;
        BooleanExpression _delegate;

        ComposedLaw(TypeLaw type, BooleanExpression delegate, Object[] params) {
            super(params);
            this._type = type;
            this._delegate = delegate;
        }

        @Override
        public boolean convert(BooleanStore store) {
            switch (this._type) {
                case FACTOR: {
                    if (this._parameters.length == 1) break;
                    return false;
                }
                case BOUND: {
                    if (this._parameters.length == 2) break;
                    return false;
                }
            }
            if (!this._delegate.convert(store)) {
                return false;
            }
            return super.convert(store);
        }

        @Override
        public double getValue(double missionTime) {
            switch (this._type) {
                case FACTOR: {
                    return ComposedLaw.verifyPrba(this._parameters[0].getValue(missionTime) * this._delegate.getValue(missionTime));
                }
                case BOUND: {
                    double time = missionTime;
                    double begin = this._parameters[0].getValue(missionTime);
                    double duration = ComposedLaw.verifyDate(this._parameters[1].getValue(missionTime));
                    time = missionTime < begin ? 0.0 : (missionTime > begin + duration ? duration : missionTime - begin);
                    return this._delegate.getValue(time);
                }
            }
            return Double.NaN;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._type.getExport());
            this.appendParameters(sb);
            sb.append(" ");
            sb.append(this._delegate.toString());
            return sb.toString();
        }

        @Override
        public void export(Appendable output, ArborRenderer renderer) throws IOException {
            output.append(this._type.getExport());
            this.exportParameters(output, renderer);
            output.append(" ");
            this._delegate.export(output, renderer);
        }
    }

    static abstract class AbstractLaw
    extends BooleanExpression {
        BooleanExpression[] _parameters;

        AbstractLaw(Object[] params) {
            this._parameters = new BooleanExpression[params.length];
            for (int i = params.length - 1; i >= 0; --i) {
                this._parameters[i] = (BooleanExpression)params[i];
            }
        }

        @Override
        public boolean convert(BooleanStore store) {
            for (int i = this._parameters.length - 1; i >= 0; --i) {
                if (this._parameters[i].convert(store)) continue;
                return false;
            }
            return true;
        }

        protected void appendParameters(StringBuffer output) {
            for (int i = 0; i < this._parameters.length; ++i) {
                output.append(" ").append(this._parameters[i].toString());
            }
        }

        protected void exportParameters(Appendable output, ArborRenderer renderer) throws IOException {
            for (int i = 0; i < this._parameters.length; ++i) {
                output.append(" ");
                this._parameters[i].export(output, renderer);
            }
        }
    }
}

