/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.dbobj.faulttree.criticity.CriticityResult;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.plugin.faulttree.compute.ActionControl;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.MCSReaderControl;
import com.dassault.cecilia.plugin.faulttree.compute.ParamCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BooleanResult {
    private static Logger _LOG = Logger.getLogger(BooleanResult.class.getPackage().getName());
    BooleanStore _store;
    ParamComputeMCS _parameters;
    double _probaTop = Double.NaN;
    double[] _probaGates;
    Map<ParamCompute.TypeImportanceFactor, double[]> _impf;
    BooleanMCS _mcs;
    String _warning;
    CriticityResult _criticityResult;
    static final String RULE_IMPF = "((CPr)|(CIF)|(DIF)|(MIF)|(RAW)|(RRW))";
    static final String RULE_ID = "(([a-zA-Z][a-zA-Z_\\.0-9\\-\\^]*)|(\\'[^']*\\')|(\\`[^']*\\'))";
    static final String RULE_DBL = "([\\-+]?(([0-9]+)|(([0-9]+[eE][\\-+]?[0-9]+)|([0-9]*\\.[0-9]*([eE][\\-+]?[0-9]+)?))))";
    static final Pattern PATTERN_LINE_PR = Pattern.compile("^Pr\\((([a-zA-Z][a-zA-Z_\\.0-9\\-\\^]*)|(\\'[^']*\\')|(\\`[^']*\\'))\\)(/(([a-zA-Z][a-zA-Z_\\.0-9\\-\\^]*)|(\\'[^']*\\')|(\\`[^']*\\')))?\\t([\\-+]?(([0-9]+)|(([0-9]+[eE][\\-+]?[0-9]+)|([0-9]*\\.[0-9]*([eE][\\-+]?[0-9]+)?))))");
    static final Pattern PATTERN_LINE_IF = Pattern.compile("^((CPr)|(CIF)|(DIF)|(MIF)|(RAW)|(RRW))\\((([a-zA-Z][a-zA-Z_\\.0-9\\-\\^]*)|(\\'[^']*\\')|(\\`[^']*\\')),(([a-zA-Z][a-zA-Z_\\.0-9\\-\\^]*)|(\\'[^']*\\')|(\\`[^']*\\'))\\)(/(([a-zA-Z][a-zA-Z_\\.0-9\\-\\^]*)|(\\'[^']*\\')|(\\`[^']*\\')))?\\t(([\\-+]?(([0-9]+)|(([0-9]+[eE][\\-+]?[0-9]+)|([0-9]*\\.[0-9]*([eE][\\-+]?[0-9]+)?))))|_)");

    public BooleanResult(BooleanStore store, ParamComputeMCS parameters) {
        this._store = store;
        this._parameters = parameters;
        this._impf = new LinkedHashMap<ParamCompute.TypeImportanceFactor, double[]>();
        this._mcs = new BooleanMCS(store);
    }

    public BooleanResult(BooleanMCS mcs, ParamComputeMCS parameters) {
        this._mcs = mcs;
        this._store = mcs.getStore();
        this._parameters = parameters;
        this._impf = new LinkedHashMap<ParamCompute.TypeImportanceFactor, double[]>();
    }

    public BooleanStore getStore() {
        return this._store;
    }

    public BooleanMCS getMCS() {
        return this._mcs;
    }

    public double getRootProbability() {
        return this._probaTop;
    }

    public Map<ParamCompute.TypeImportanceFactor, double[]> getLeavesImportanceFactors() {
        return this._impf;
    }

    public double[] getGatesProbability() {
        return this._probaGates;
    }

    public String getWarning() {
        return this._warning;
    }

    public void addWarning(String msg) {
        if (msg == null) {
            return;
        }
        if (this._warning == null) {
            this._warning = msg;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(this._warning);
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(msg);
            this._warning = sb.toString();
        }
    }

    public void setCriticityResult(CriticityResult result) {
        this._criticityResult = result;
    }

    public CriticityResult getCriticityResult() {
        return this._criticityResult;
    }

    public void computeProbabilities(TypeProbability type, double missionTime, ActionControl ctrl) {
        if (type != TypeProbability.NONE) {
            double proba = this._mcs.computeProbabilities(type, missionTime, ctrl);
            if (type != TypeProbability.BDD) {
                this._probaGates = null;
                this._impf = new LinkedHashMap<ParamCompute.TypeImportanceFactor, double[]>();
                BooleanNode root = this._store.getRoot();
                this.addProbability(root, root, proba);
            }
        } else {
            int i;
            this._probaGates = null;
            this._impf = new LinkedHashMap<ParamCompute.TypeImportanceFactor, double[]>();
            this._probaTop = Double.NaN;
            int nbrLeaves = this._store.getNbrLeaves();
            for (i = 0; i < nbrLeaves; ++i) {
                BooleanNode leaf = this._store.getLeaf(i);
                leaf.setProbability(Double.NaN);
            }
            int nbrGates = this._store.getNbrGates();
            for (i = 0; i < nbrGates; ++i) {
                BooleanNode gate = this._store.getGate(i);
                gate.setProbability(Double.NaN);
            }
        }
        this._mcs.prepare();
    }

    public String getResultAbstract() {
        StringBuilder sb = new StringBuilder();
        if (!Double.isNaN(this._probaTop)) {
            sb.append("[").append(this._probaTop).append("] ");
        }
        sb.append(this._mcs.getOrderAbstract());
        return sb.toString();
    }

    public String getResultsString() {
        int len;
        StringBuilder sb = new StringBuilder();
        sb.append(this._mcs.getOrderString());
        sb.append(this._mcs.getProductString());
        if (this._probaGates != null) {
            len = this._store.getNbrGates();
            for (int i = 0; i < len; ++i) {
                if (Double.isNaN(this._probaGates[i])) continue;
                sb.append("Pr(").append(this._store.getGate(i).getName()).append(")=").append(this._probaGates[i]).append("\n");
            }
        } else if (!Double.isNaN(this._probaTop)) {
            sb.append("Pr(").append(this._store.getRoot().getName()).append(")=").append(this._probaTop);
        }
        if (this._impf.size() > 0) {
            len = this._store.getNbrLeaves();
            for (ParamCompute.TypeImportanceFactor keyIF : this._impf.keySet()) {
                double[] result = this._impf.get((Object)keyIF);
                for (int i = 0; i < len; ++i) {
                    if (Double.isNaN(result[i])) continue;
                    sb.append((Object)keyIF).append("(").append(this._store.getLeaf(i).getName()).append(")=").append(result[i]);
                }
            }
        }
        return sb.toString();
    }

    public void parse(BooleanNode root, Reader reader, MCSReaderControl ctrl) throws IOException {
        int readCuts = 0;
        String line = null;
        try {
            BufferedReader lineReader = new BufferedReader(reader, 1024);
            while ((line = lineReader.readLine()) != null) {
                Matcher match;
                if (ctrl.isCanceled()) {
                    return;
                }
                if (readCuts == 1) {
                    if (line.startsWith("end")) {
                        readCuts = 2;
                        continue;
                    }
                    if (this._mcs.addCut(line, ctrl)) continue;
                    throw new IOException("Parser cut error : " + line);
                }
                if (line.startsWith("Pr(")) {
                    match = PATTERN_LINE_PR.matcher(line);
                    if (!match.matches()) {
                        throw new IOException("Parser result error : " + line);
                    }
                    this.addProbability(root, match.group(1), match.group(10));
                    continue;
                }
                if (line.length() > 5 && line.charAt(3) == '(') {
                    match = PATTERN_LINE_IF.matcher(line);
                    if (!match.matches()) {
                        throw new IOException("Parser result error : " + line);
                    }
                    this.addImportanceFactor(match.group(1), match.group(12), match.group(21));
                    continue;
                }
                if (!line.startsWith("products(")) continue;
                if (readCuts != 0) {
                    throw new IOException("Parser result error ; already read cuts");
                }
                readCuts = 1;
            }
            if (ctrl.isCanceled()) {
                return;
            }
            if (readCuts == 1) {
                throw new IOException("Parser result error ; no finnish read cuts ");
            }
            if (readCuts == 0) {
                throw new IOException("Parser result error ; no read cuts ");
            }
            if (ctrl.hasLimited()) {
                this.addWarning(ctrl.getWarningMsg());
            }
            if (this._mcs.isAlwaysTrue()) {
                this.addWarning(ResCompute.getString("MCS_MSG_TREE_TRUE"));
            } else if (this._mcs.isAlwaysFalse()) {
                this.addWarning(ResCompute.getString("MCS_MSG_TREE_FALSE"));
            }
        }
        catch (OutOfMemoryError e) {
            this._mcs.limitAt(1);
            throw new IOException("OutOfMemoryError", e);
        }
    }

    private void addProbability(BooleanNode root, String name, String value) throws IOException {
        BooleanNode node;
        if (name.startsWith("'") || name.startsWith("`")) {
            name = name.substring(1, name.length() - 1);
        }
        if ((node = this._store.getNode(name)) == null) {
            _LOG.info("BooleanResult - Unknown variable during read probability : " + name);
            return;
        }
        this.addProbability(root, node, Double.parseDouble(value));
    }

    public void addProbability(BooleanNode root, BooleanNode node, double dblvalue) {
        if (node == root) {
            this._probaTop = dblvalue;
        }
        if (node.getType() == 2) {
            return;
        }
        node.setProbability(dblvalue);
        if (this._probaGates == null && node != root) {
            this._probaGates = new double[this._store.getNbrGates()];
            Arrays.fill(this._probaGates, Double.NaN);
            if (!Double.isNaN(this._probaTop)) {
                this._probaGates[root.getIndex()] = this._probaTop;
            }
        }
        if (this._probaGates != null) {
            this._probaGates[node.getIndex()] = dblvalue;
        }
    }

    private void addImportanceFactor(String mifCode, String name, String value) throws IOException {
        BooleanNode node;
        if (name.startsWith("'") || name.startsWith("`")) {
            name = name.substring(1, name.length() - 1);
        }
        if ((node = this._store.getNode(name)) == null) {
            _LOG.info("BooleanResult - Unknown variable during read importance factor : " + name);
            return;
        }
        if (node.getType() != 2) {
            _LOG.info("BooleanResult - Variable is not leaf during read importance factor : " + name);
            return;
        }
        ParamCompute.TypeImportanceFactor mif = ParamCompute.TypeImportanceFactor.getEnum(mifCode);
        if (mif == null) {
            _LOG.fine("BooleanResult - No understand ImpFactor code : " + mifCode);
            return;
        }
        if (value.equals("_")) {
            this.addImportanceFactor(mif, node.getIndex(), Double.NaN);
        } else {
            this.addImportanceFactor(mif, node.getIndex(), Double.parseDouble(value));
        }
    }

    public void addImportanceFactor(ParamCompute.TypeImportanceFactor mif, int idxLeaf, double dblvalue) {
        if (this._parameters == null) {
            _LOG.warning("No parameters during addImportanceFactor");
            return;
        }
        Boolean enable = this._parameters.getImportanceFactors().get((Object)mif);
        if (enable == null || !enable.booleanValue()) {
            _LOG.finest("No requested importance factor : " + mif);
            return;
        }
        double[] impfvalues = this._impf.get((Object)mif);
        if (impfvalues == null) {
            impfvalues = new double[this._store.getNbrLeaves()];
            this._impf.put(mif, impfvalues);
        }
        impfvalues[idxLeaf] = dblvalue;
    }
}

