/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.CAACut;
import com.dassault.cecilia.plugin.faulttree.compute.CAAItem;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class CAASelector {
    List<Attr.Key> _attributes;
    boolean _merge;

    public CAASelector(Collection<Attr.Key> attrs, boolean merge) {
        this._attributes = new ArrayList<Attr.Key>(attrs);
        this._merge = merge;
    }

    public CAASelector(CAASelector src) {
        this._attributes = new ArrayList<Attr.Key>(src._attributes);
        this._merge = src._merge;
    }

    public CAASelector getCopy() {
        return new CAASelector(this);
    }

    public List<Attr.Key> getAttributes() {
        return this._attributes;
    }

    public void setAttributes(Collection<Attr.Key> attrs) {
        this._attributes = new ArrayList<Attr.Key>(attrs);
    }

    public boolean getMerge() {
        return this._merge;
    }

    public void setMerge(boolean value) {
        this._merge = value;
    }

    public CAAItem playMCS(BooleanMCS mcs) {
        CAAItem rootItem = new CAAItem(null, mcs.getStore(), 0, null);
        rootItem._mcs = mcs;
        BooleanMCS.BooleanMCSOrderCutIterator iCut = mcs.cutIterate();
        while (iCut.hasNext()) {
            Cut cut = iCut.next();
            this.constructCAAItems(cut, rootItem, 0);
        }
        rootItem.prepare();
        return rootItem;
    }

    private void constructCAAItems(Cut cut, CAAItem item, int idxAttr) {
        if (idxAttr >= this._attributes.size()) {
            return;
        }
        Attr.Key attribute = this._attributes.get(idxAttr);
        CAACut caaCut = this.convertCutToCAACut(cut, attribute);
        CAAItem childItem = item._subCuts.get(caaCut);
        if (childItem == null) {
            childItem = new CAAItem(caaCut, item.getStore(), item.getLevel() + 1, item);
            item._subCuts.put(caaCut, childItem);
        }
        childItem.addCut(cut);
        this.constructCAAItems(cut, childItem, idxAttr + 1);
    }

    private CAACut convertCutToCAACut(Cut cut, Attr.Key attribute) {
        ArrayList<Object> values = new ArrayList<Object>();
        int order = cut.getOrder();
        for (int i = 0; i < order; ++i) {
            Evt evt = cut.getEvent(i);
            Attr attr = evt.getAttribute(attribute);
            Object val = CAACut.__undefValue;
            if (attr != null) {
                val = attr.getValue();
            }
            if (this._merge) {
                if (values.contains(val)) continue;
                values.add(val);
                continue;
            }
            values.add(val);
        }
        return new CAACut(attribute, values);
    }

    public boolean checkAttributes(Map<Attr.Key, Set<String>> attrs) {
        if (this._attributes.size() == 0) {
            return false;
        }
        for (Attr.Key attr : this._attributes) {
            if (attr.getType() == AttrType.ALIAS) {
                return false;
            }
            if (attr.getType() == AttrType.FIELD) {
                return false;
            }
            if (Attr.Key.containsAttribut(attrs, (Attr.Key)attr)) continue;
            return false;
        }
        return true;
    }

    public String verifyAttributes(Map<Attr.Key, Set<String>> attrs) {
        if (this._attributes.size() == 0) {
            return "Internal error: No attribute";
        }
        StringBuffer warning = new StringBuffer();
        ListIterator<Attr.Key> iter = this._attributes.listIterator();
        while (iter.hasNext()) {
            Attr.Key attr = iter.next();
            if (attr.getType() == AttrType.ALIAS) {
                return "Internal error: alias attribute";
            }
            if (attr.getType() == AttrType.FIELD) {
                return "Internal error: field attribute";
            }
            Attr.Key substitute = Attr.Key.findAttribut(attrs, (Attr.Key)attr);
            if (substitute == null) {
                if (warning.length() > 0) {
                    warning.append(", ");
                }
                warning.append(attr.getName());
                continue;
            }
            iter.set(substitute);
        }
        if (warning.length() > 0) {
            return ResCompute.msgFormat("CAA_WARNING_ATTRIBUTE_UNKNOWN", warning.toString());
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CAASelector)) {
            return false;
        }
        CAASelector selector = (CAASelector)obj;
        if (selector.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (selector.getAttributes() != null && !selector.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        return selector.getMerge() == this.getMerge();
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = hashCode * 2 + (this.getAttributes() != null ? this.getAttributes().hashCode() : 0);
        hashCode = hashCode * 3 + (this.getMerge() ? 1 : 0);
        return hashCode;
    }

    public void appendAbstract(StringBuilder buffer) {
        buffer.append(ResCompute.getString("BATCH_EXPORT_CAA_MSG_ATTRIBUTES"));
        List<Attr.Key> attrs = this.getAttributes();
        if (attrs == null || attrs.size() == 0) {
            buffer.append("???");
        } else {
            Iterator<Attr.Key> iAttr = attrs.iterator();
            while (iAttr.hasNext()) {
                buffer.append(iAttr.next().getName());
                if (!iAttr.hasNext()) continue;
                buffer.append(", ");
            }
        }
        buffer.append("<br/>");
        if (this.getMerge()) {
            buffer.append(ResCompute.getString("BATCH_EXPORT_CAA_MSG_MERGE"));
            buffer.append("<br/>");
        }
    }
}

