/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.PlugTask;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.plugin.faulttree.compute.PluginCmdEngine;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchContainer;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchPanel;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDConfig;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborPreferenciesRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class PluginCmdBatch
extends AbstractPluginModel
implements PluginMAction {
    private static Logger _LOG = Logger.getLogger(PluginCmdBatch.class.getPackage().getName());

    public boolean withOption(Plugable plugable) {
        return false;
    }

    public PlugPanel displayOption(Plugable launcher) {
        return null;
    }

    public void refreshOptions(Plugable launcher) {
    }

    public boolean withParameters() {
        return false;
    }

    public Object getDefaultParameters(PluginManager plugable) {
        return null;
    }

    public Object changeParameters(PluginManager parent, Object parameters) {
        return null;
    }

    public IOParameters getIOParameters() {
        return null;
    }

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCompute.getString("PLUG_CMD_BATCH_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResCompute.getString("PLUG_CMD_BATCH_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        if (key.equals("plugin.shortcut")) {
            return "ctrl alt B";
        }
        return "Info";
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoCompute.getImageIcon("PLUGIN_BATCH");
        }
        return super.getIcon(key);
    }

    protected void addBatchTask(Plugable launcher, EngineBDDConfig engineBDDCfg, BatchCompute batch) {
        _LOG.finest("PLuginCmdBatch.addBatchTask(...)");
        BatchContainer batchContainer = new BatchContainer(launcher, engineBDDCfg, batch);
        PlugTask plugTask = batchContainer.createPlugTask(ResCompute.getString("PLUG_CMD_BATCH_NAME"), ResCompute.msgFormat("BATCH_TASK_DESCRIPTION", batch.getNbrItem()));
        launcher.addTask(plugTask, -1L);
    }

    public void createSession(final Plugable launcher, Object parameters) {
        PluginModel pluginEngine = launcher.getPlugin(PluginCmdEngine.class.getName());
        if (pluginEngine == null || !(pluginEngine instanceof EngineBDDConfig)) {
            _LOG.logp(Level.SEVERE, "PluginCmdBatch", "createSession", "No EngineBDDConfig");
            return;
        }
        final EngineBDDConfig engineBDDCfg = (EngineBDDConfig)pluginEngine;
        final BatchCompute batch = new BatchCompute();
        class DlgBatch
        extends JDialogCecilia {
            BatchPanel _options;

            DlgBatch(Window owner, String title, BatchCompute batchCmp) {
                super(owner, title, false);
                this._options = new BatchPanel(launcher, (JDialog)((Object)this), batchCmp);
                this._options.setRenderer(new ArborPreferenciesRenderer(launcher));
                this._options.setEngineBDDConfig(engineBDDCfg);
                this.getContentPane().setLayout(new BorderLayout());
                this.getContentPane().add((Component)((Object)this._options), "Center");
                this.getContentPane().add((Component)this.createButPanel(true), "South");
                this.init();
            }

            protected boolean verifyParameters() {
                return !this._options.withError();
            }

            protected void validDialog() {
                if (this._options.withError()) {
                    return;
                }
                this._options.checkErrors();
                if (this._options.withError()) {
                    return;
                }
                this._options.generateNewFolders();
                Collection<File> files = batch.getExportFiles();
                Iterator<File> fIter = files.iterator();
                while (fIter.hasNext()) {
                    if (fIter.next().exists()) continue;
                    fIter.remove();
                }
                if (files.size() > 0) {
                    StringBuffer buffer = new StringBuffer();
                    if (files.size() > 1) {
                        buffer.append("<html>");
                        buffer.append(ResMsgCore.getString((String)"FILE_MSG_EXIST"));
                        buffer.append("<ul>");
                        int nbr = 0;
                        for (File file : files) {
                            if (nbr++ >= 10) {
                                buffer.append("<li> ... </li>");
                                break;
                            }
                            buffer.append("<li>").append(file).append("</li>");
                        }
                        buffer.append("</ul>");
                        buffer.append("</html>");
                    } else {
                        buffer.append(ResMsgCore.getString((String)"FILE_MSG_EXIST"));
                        buffer.append("\n").append(files.iterator().next());
                    }
                    if (JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), buffer.toString(), PluginCmdBatch.this.getInfo("plugin.name"), 0) == 1) {
                        return;
                    }
                }
                this.setVisible(false);
                PluginCmdBatch.this.addBatchTask(launcher, engineBDDCfg, batch);
            }

            protected void init() {
                super.init();
                this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "actionAskBeforeLaunching");
                this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "actionAskBeforeEscaping");
                this.getRootPane().getActionMap().put("actionAskBeforeLaunching", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int wantToContinue = JOptionPane.showConfirmDialog(this.getRootPane(), ResCompute.getString("BATCH_DLG_ASK_USER_ENTER"), this.getTitle(), 0);
                        if (wantToContinue == 2 || wantToContinue == -1 || wantToContinue == 1) {
                            return;
                        }
                        this.getRootPane().getActionMap().get("CECILIA_ENTER").actionPerformed(e);
                    }
                });
                this.getRootPane().getActionMap().put("actionAskBeforeEscaping", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int wantToContinue = JOptionPane.showConfirmDialog(this.getRootPane(), ResCompute.getString("BATCH_DLG_ASK_USER_ECHAP"), this.getTitle(), 0);
                        if (wantToContinue == 2 || wantToContinue == -1 || wantToContinue == 1) {
                            return;
                        }
                        this.getRootPane().getActionMap().get("CECILIA_CANCEL").actionPerformed(e);
                    }
                });
            }
        }
        DlgBatch dlg = new DlgBatch(launcher.getWindow(), this.getInfo("plugin.name"), batch);
        dlg.pack();
        dlg.setLocationRelativeTo(launcher.getWindow());
        dlg.setVisible(true);
    }
}

