/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.batch;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchItem;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportItem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BatchCompute {
    private static Logger _LOG = Logger.getLogger(BatchCompute.class.getPackage().getName());
    protected SaveResults _saveResults = SaveResults.SOMETIMES;
    protected boolean _bIgnoreReference = false;
    protected ArrayList<BatchItem> _array = new ArrayList();
    private static DocumentBuilderFactory _dbf = null;

    public SaveResults getSaveResults() {
        return this._saveResults;
    }

    public void setSaveResults(SaveResults value) {
        this._saveResults = value;
    }

    public boolean getIgnoreReference() {
        return this._bIgnoreReference;
    }

    public void setIgnoreReference(boolean value) {
        this._bIgnoreReference = value;
    }

    public int getNbrItem() {
        return this._array.size();
    }

    public BatchItem getItem(int idx) {
        return this._array.get(idx);
    }

    public void setItem(int idx, BatchItem item) {
        this._array.set(idx, item);
    }

    public boolean withError() {
        Iterator<BatchItem> i = this._array.iterator();
        while (i.hasNext()) {
            if (!i.next().withError()) continue;
            return true;
        }
        return false;
    }

    public Collection<File> getExportFiles() {
        ArrayList<File> files = new ArrayList<File>();
        Iterator<BatchItem> i = this._array.iterator();
        while (i.hasNext()) {
            for (ExportItem item : i.next().getExports()) {
                files.add(item.getFile());
            }
        }
        return files;
    }

    public int insert(BatchItem obj, int idx) {
        if (idx == -1) {
            idx = this._array.size();
        }
        this._array.add(idx, obj);
        return idx;
    }

    public void remove(int idx) {
        this._array.remove(idx);
    }

    public void down(int idxMin, int idxMax) {
        BatchItem obj = this._array.remove(idxMax + 1);
        this._array.add(idxMin, obj);
    }

    public void up(int idxMin, int idxMax) {
        BatchItem obj = this._array.remove(idxMin - 1);
        this._array.add(idxMax, obj);
    }

    public void save(File output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        writer.write("<?xml version=\"1.0\" encoding=\"iso-8859-15\"?>\n");
        writer.write("<!-- Pas de DTD par defaut -->\n");
        writer.append("<cecilia.batch save-results='");
        writer.append(this._saveResults.toString()).append("'");
        if (this._bIgnoreReference) {
            writer.append(" ignore-reference='true'");
        }
        writer.append(">\n");
        Iterator<BatchItem> i = this._array.iterator();
        while (i.hasNext()) {
            i.next().save(writer);
        }
        writer.write("</cecilia.batch>\n");
        ((Writer)writer).close();
    }

    public void load(File input) throws IOException {
        ArrayList<BatchItem> list = new ArrayList<BatchItem>();
        SaveResults save = this._saveResults;
        boolean ignore = this._bIgnoreReference;
        if (_dbf == null) {
            _dbf = DocumentBuilderFactory.newInstance();
            _dbf.setValidating(false);
            _dbf.setIgnoringComments(true);
            _dbf.setIgnoringElementContentWhitespace(true);
            _dbf.setCoalescing(false);
            _dbf.setExpandEntityReferences(true);
        }
        try {
            String strIgnore;
            DocumentBuilder db = _dbf.newDocumentBuilder();
            Document doc = db.parse(new File(input.getPath()));
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals("cecilia.batch")) {
                throw new IOException(ResMsgCore.msgFormat((String)"FILE_ERROR_OPEN_XML_ROOT", (Object[])new Object[]{"cecilia.batch"}));
            }
            String strSave = root.getAttribute("save-results");
            if (strSave != null) {
                SaveResults tmpSave = SaveResults.valueOf(strSave);
                if (tmpSave == null) {
                    _LOG.warning("Unknown value of XML attribute 'save-results' : " + strSave);
                } else {
                    save = tmpSave;
                }
            }
            if ((strIgnore = root.getAttribute("ignore-reference")) != null && !strIgnore.isEmpty()) {
                if (strIgnore.equalsIgnoreCase("true")) {
                    ignore = true;
                } else if (strIgnore.equalsIgnoreCase("false")) {
                    ignore = false;
                } else {
                    _LOG.warning("Unknown value of XML attribute 'ignore-reference' : " + strIgnore);
                }
            }
            NodeList childs = root.getElementsByTagName("cecilia.compute");
            for (int i = 0; i < childs.getLength(); ++i) {
                Element xmlTgt = (Element)childs.item(i);
                BatchItem tgt = new BatchItem(xmlTgt);
                list.add(tgt);
            }
            this._array = list;
            this._saveResults = save;
            this._bIgnoreReference = ignore;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Exception during read file batch", e);
            StringBuffer sb = new StringBuffer(32);
            sb.append(e.getClass().getName());
            sb.append(" : ");
            String mess = e.getMessage();
            if (mess == null) {
                sb.append("<null>");
            } else {
                sb.append(mess);
            }
            throw new IOException(sb.toString());
        }
    }

    public static enum SaveResults {
        ALWAYS("BATCH_SAVE_ALWAYS"),
        NEVER("BATCH_SAVE_NEVER"),
        SOMETIMES("BATCH_SAVE_SOMETIMES");

        String _keyLbl;

        private SaveResults(String keyLbl) {
            this._keyLbl = keyLbl;
        }

        public String getLabel() {
            return ResCompute.getString(this._keyLbl);
        }
    }
}

